/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.entity.api.EntitySpecSerializer;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MaltegoEntityEntry
extends Entry<MaltegoEntitySpec> {
    static final String DefaultFolder = "Entities";
    public static final String Type = "entity";

    public MaltegoEntityEntry(MaltegoEntitySpec maltegoEntitySpec) {
        super(maltegoEntitySpec, DefaultFolder, maltegoEntitySpec.getTypeName() + "." + Type, maltegoEntitySpec.getDisplayName());
    }

    public MaltegoEntityEntry(String string) {
        super(string);
    }

    @Override
    protected MaltegoEntitySpec read(InputStream inputStream) throws IOException {
        try {
            return EntitySpecSerializer.getDefault().read(inputStream);
        }
        catch (XmlSerializationException xmlSerializationException) {
            throw new IOException(xmlSerializationException);
        }
        catch (TypeInstantiationException typeInstantiationException) {
            throw new IOException(typeInstantiationException);
        }
    }

    @Override
    protected void write(MaltegoEntitySpec maltegoEntitySpec, OutputStream outputStream) throws IOException {
        EntitySpecSerializer.getDefault().write(maltegoEntitySpec, outputStream);
    }
}

