/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.repository.FSTransformRepository;
import com.paterva.maltego.util.ListMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class FSTransformRepositoryRegistry
extends TransformRepositoryRegistry {
    private Map<String, FSTransformRepository> _repositories;

    public TransformDefinition findTransform(String string) {
        for (FSTransformRepository fSTransformRepository : this.repositories().values()) {
            TransformDefinition transformDefinition = fSTransformRepository.get(string);
            if (transformDefinition == null) continue;
            return transformDefinition;
        }
        return null;
    }

    public Set<TransformDefinition> find(TransformFilter transformFilter) {
        HashSet<TransformDefinition> hashSet = new HashSet<TransformDefinition>();
        for (FSTransformRepository fSTransformRepository : this.repositories().values()) {
            fSTransformRepository.find(transformFilter, hashSet);
        }
        return hashSet;
    }

    private Map<String, FSTransformRepository> repositories() {
        if (this._repositories == null) {
            try {
                this._repositories = new ListMap();
                for (FileObject fileObject : FSTransformRepositoryRegistry.getRoot().getChildren()) {
                    if (!fileObject.isFolder()) continue;
                    this._repositories.put(fileObject.getName(), new FSTransformRepository(fileObject.getName(), fileObject));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this._repositories;
    }

    public FSTransformRepository getRepository(String string) {
        FileObject fileObject;
        FSTransformRepository fSTransformRepository = this.repositories().get(string);
        if (fSTransformRepository == null && (fileObject = FSTransformRepositoryRegistry.findRepository(string)) != null) {
            fSTransformRepository = new FSTransformRepository(string, fileObject);
            this.repositories().put(string, fSTransformRepository);
        }
        return fSTransformRepository;
    }

    public FSTransformRepository getOrCreateRepository(String string) throws IOException {
        FSTransformRepository fSTransformRepository = this.getRepository(string);
        if (fSTransformRepository == null) {
            fSTransformRepository = FSTransformRepositoryRegistry.createRepository(string);
            this.repositories().put(string, fSTransformRepository);
        }
        return fSTransformRepository;
    }

    private static FSTransformRepository createRepository(String string) throws IOException {
        FileObject fileObject = FSTransformRepositoryRegistry.getRoot().createFolder(string);
        return new FSTransformRepository(string, fileObject);
    }

    private static FileObject findRepository(String string) {
        try {
            return FSTransformRepositoryRegistry.getRoot().getFileObject(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static FileObject getRoot() throws IOException {
        FileObject fileObject;
        FileObject fileObject2 = FileUtil.getConfigRoot().getFileObject("Maltego");
        if (fileObject2 == null) {
            fileObject2 = FileUtil.getConfigRoot().createFolder("Maltego");
        }
        if ((fileObject = fileObject2.getFileObject("TransformRepositories")) == null) {
            fileObject = fileObject2.createFolder("TransformRepositories");
        }
        return fileObject;
    }

    public boolean removeTransform(String string) {
        boolean bl = false;
        for (FSTransformRepository fSTransformRepository : this.repositories().values()) {
            if (!fSTransformRepository.remove(string)) continue;
            bl = true;
        }
        return bl;
    }
}

