/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.netigso;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ArchiveResources;
import org.netbeans.Module;
import org.netbeans.NetigsoFramework;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Stamps;
import org.netbeans.core.netigso.NetigsoActivator;
import org.netbeans.core.netigso.NetigsoArchiveFactory;
import org.netbeans.core.netigso.NetigsoLoader;
import org.netbeans.core.netigso.NetigsoServices;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public final class Netigso
extends NetigsoFramework
implements Stamps.Updater {
    static final Logger LOG = Logger.getLogger(Netigso.class.getName());
    private static final ThreadLocal<Boolean> SELF_QUERY = new ThreadLocal();
    private static final String[] EMPTY = new String[0];
    private Framework framework;
    private NetigsoActivator activator;
    private final Map<String, String[]> registered = new HashMap<String, String[]>();

    Framework getFramework() {
        return this.framework;
    }

    protected ClassLoader findFrameworkClassLoader() {
        Framework f = this.framework;
        if (f != null) {
            return f.getClass().getClassLoader();
        }
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected void prepare(Lookup lkp, Collection<? extends Module> preregister) {
        if (this.framework == null) {
            this.readBundles();
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            String string = this.getNetigsoCache().getPath();
            configMap.put("org.osgi.framework.storage", string);
            this.activator = new NetigsoActivator();
            configMap.put("netigso.archive", NetigsoArchiveFactory.DEFAULT.create(this));
            configMap.put("felix.bootdelegation.classloaders", this.activator);
            FrameworkFactory frameworkFactory = (FrameworkFactory)lkp.lookup(FrameworkFactory.class);
            if (frameworkFactory == null) {
                throw new IllegalStateException("Cannot find OSGi framework implementation. Is org.netbeans.libs.felix module or similar enabled?");
            }
            this.framework = frameworkFactory.newFramework(configMap);
            try {
                this.framework.init();
            }
            catch (BundleException ex) {
                LOG.log(Level.SEVERE, "Cannot start OSGi framework", ex);
            }
            NetigsoServices ns = new NetigsoServices(this.framework);
            LOG.finer("OSGi Container initialized");
        }
        this.activator.register(preregister);
        for (Module module : preregister) {
            try {
                this.fakeOneModule(module, null);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Cannot fake " + module.getCodeName(), ex);
            }
        }
    }

    protected Set<String> start(Collection<? extends Module> allModules) {
        return Netigso.toActivate(this.framework, allModules);
    }

    protected void start() {
        try {
            this.framework.start();
        }
        catch (BundleException ex) {
            LOG.log(Level.WARNING, "Cannot start Container" + this.framework, ex);
        }
    }

    private static Set<String> toActivate(Framework f, Collection<? extends Module> allModules) {
        ServiceReference sr = f.getBundleContext().getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        if (sr == null) {
            return null;
        }
        PackageAdmin pkgAdm = (PackageAdmin)f.getBundleContext().getService(sr);
        if (pkgAdm == null) {
            return null;
        }
        HashSet<String> allCnbs = new HashSet<String>(allModules.size() * 2);
        for (Module module : allModules) {
            allCnbs.add(module.getCodeNameBase());
        }
        HashSet<String> needEnablement = new HashSet<String>();
        for (Bundle b : f.getBundleContext().getBundles()) {
            RequiredBundle[] arr;
            String loc = b.getLocation();
            if (!loc.startsWith("netigso://")) continue;
            loc = loc.substring("netigso://".length());
            for (RequiredBundle rb : arr = pkgAdm.getRequiredBundles(loc)) {
                for (Bundle n : rb.getRequiringBundles()) {
                    if (!allCnbs.contains(n.getSymbolicName().replace('-', '_'))) continue;
                    needEnablement.add(loc);
                }
            }
        }
        return needEnablement;
    }

    protected void shutdown() {
        try {
            this.framework.stop();
            this.framework.waitForStop(10000L);
            this.framework = null;
        }
        catch (InterruptedException ex) {
            LOG.log(Level.WARNING, "Wait for shutdown failed" + this.framework, ex);
        }
        catch (BundleException ex) {
            LOG.log(Level.WARNING, "Cannot start Container" + this.framework, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> createLoader(ModuleInfo m, ProxyClassLoader pcl, File jar) throws IOException {
        try {
            assert (this.registered.containsKey(m.getCodeNameBase())) : m.getCodeNameBase();
            Bundle b = this.findBundle(m.getCodeNameBase());
            if (b == null) {
                for (Bundle bb : this.framework.getBundleContext().getBundles()) {
                    LOG.log(Level.FINE, "Bundle {0}: {1}", new Object[]{bb.getBundleId(), bb.getSymbolicName()});
                }
                throw new IOException("Not found bundle:" + m.getCodeNameBase());
            }
            NetigsoLoader l = new NetigsoLoader(b, m, jar);
            HashSet<String> pkgs = new HashSet<String>();
            String[] knownPkgs = this.registered.get(m.getCodeNameBase());
            if (knownPkgs == EMPTY) {
                try {
                    SELF_QUERY.set(true);
                    Enumeration en = b.findEntries("", null, true);
                    if (en == null) {
                        LOG.log(Level.INFO, "Bundle {0}: {1} is empty", new Object[]{b.getBundleId(), b.getSymbolicName()});
                    } else {
                        while (en.hasMoreElements()) {
                            URL url = (URL)en.nextElement();
                            if (url.getFile().startsWith("/META-INF")) continue;
                            pkgs.add(url.getFile().substring(1).replaceFirst("/[^/]*$", "").replace('/', '.'));
                        }
                    }
                    Object exported = b.getHeaders("").get("Export-Package");
                    if (exported instanceof String) {
                        for (String p : exported.toString().split(",")) {
                            int semic = p.indexOf(59);
                            if (semic >= 0) {
                                p = p.substring(0, semic);
                            }
                            pkgs.add(p);
                        }
                    }
                }
                finally {
                    SELF_QUERY.set(false);
                }
                this.registered.put(m.getCodeNameBase(), pkgs.toArray(new String[0]));
                Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, "netigso-bundles", false);
            } else {
                pkgs.addAll(Arrays.asList(knownPkgs));
            }
            pcl.append(new ClassLoader[]{l});
            try {
                LOG.log(Level.FINE, "Starting bundle {0}", m.getCodeNameBase());
                b.start();
            }
            catch (BundleException possible) {
                if (Netigso.isRealBundle(b)) {
                    throw possible;
                }
                LOG.log(Level.FINE, "Not starting fragment {0}", m.getCodeNameBase());
            }
            return pkgs;
        }
        catch (BundleException ex) {
            throw new IOException("Cannot start " + jar, ex);
        }
    }

    private static boolean isRealBundle(Bundle b) {
        return b.getHeaders("").get("Fragment-Host") == null;
    }

    protected void stopLoader(ModuleInfo m, ClassLoader loader) {
        NetigsoLoader nl = (NetigsoLoader)((Object)loader);
        Bundle b = nl.bundle;
        try {
            assert (b != null);
            try {
                LOG.log(Level.FINE, "Stopping bundle {0}", m.getCodeNameBase());
                b.stop();
            }
            catch (BundleException possible) {
                if (Netigso.isRealBundle(b)) {
                    throw possible;
                }
                LOG.log(Level.FINE, "Not stopping fragment {0}", m.getCodeNameBase());
            }
        }
        catch (BundleException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected void reload(Module m) throws IOException {
        try {
            Bundle b = this.findBundle(m.getCodeNameBase());
            b.stop();
            this.fakeOneModule(m, b);
        }
        catch (BundleException ex) {
            throw new IOException(ex);
        }
    }

    private File getNetigsoCache() throws IllegalStateException {
        String ud = System.getProperty("netbeans.user");
        if (ud == null) {
            throw new IllegalStateException();
        }
        File udf = new File(ud);
        return new File(new File(new File(udf, "var"), "cache"), "netigso");
    }

    private void deleteRec(File dir) {
        File[] arr = dir.listFiles();
        if (arr != null) {
            for (File f : arr) {
                this.deleteRec(f);
            }
        }
        dir.delete();
    }

    private void fakeOneModule(Module m, Bundle original) throws IOException {
        if (this.registered.get(m.getCodeNameBase()) != null && original == null) {
            return;
        }
        this.registered.put(m.getCodeNameBase(), EMPTY);
        try {
            String symbolicName = (String)m.getAttribute("Bundle-SymbolicName");
            if (!"org.netbeans.core.osgi".equals(symbolicName)) {
                if (symbolicName != null) {
                    if (original != null) {
                        LOG.log(Level.FINE, "Updating bundle {0}", original.getLocation());
                        original.update();
                        Bundle b = original;
                    } else {
                        BundleContext bc = this.framework.getBundleContext();
                        File jar = m.getJarFile();
                        String loc = m.isReloadable() ? Netigso.toURI(jar) : "reference:" + Netigso.toURI(jar);
                        LOG.log(Level.FINE, "Installing bundle {0}", loc);
                        Bundle b = bc.installBundle(loc);
                    }
                } else {
                    InputStream is = Netigso.fakeBundle((ModuleInfo)m);
                    if (is != null) {
                        if (original != null) {
                            original.update(is);
                            Bundle b = original;
                        } else {
                            Bundle b = this.framework.getBundleContext().installBundle("netigso://" + m.getCodeNameBase(), is);
                        }
                        is.close();
                    }
                }
            }
            Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, "netigso-bundles", false);
        }
        catch (BundleException ex) {
            throw new IOException(ex);
        }
    }

    private static String threeDotsWithMajor(String version, String withMajor) {
        int indx = withMajor.indexOf(47);
        int major = 0;
        if (indx > 0) {
            major = Integer.parseInt(withMajor.substring(indx + 1));
        }
        String[] segments = (version + ".0.0.0").split("\\.");
        assert (segments.length >= 3 && segments[0].length() > 0);
        return Integer.parseInt(segments[0]) + major * 100 + "." + segments[1] + "." + segments[2];
    }

    private static InputStream fakeBundle(ModuleInfo m) throws IOException {
        String exp = (String)m.getAttribute("OpenIDE-Module-Public-Packages");
        if ("-".equals(exp)) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Manifest man = new Manifest();
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        man.getMainAttributes().putValue("Bundle-SymbolicName", m.getCodeNameBase());
        if (m.getSpecificationVersion() != null) {
            String spec = Netigso.threeDotsWithMajor(m.getSpecificationVersion().toString(), m.getCodeName());
            man.getMainAttributes().putValue("Bundle-Version", spec.toString());
        }
        if (exp != null) {
            man.getMainAttributes().putValue("Export-Package", exp.replaceAll("\\.\\*", ""));
        } else {
            man.getMainAttributes().putValue("Export-Package", m.getCodeNameBase());
        }
        JarOutputStream jos = new JarOutputStream((OutputStream)os, man);
        jos.close();
        return new ByteArrayInputStream(os.toByteArray());
    }

    private void readBundles() {
        assert (this.registered.isEmpty());
        try {
            InputStream is = Stamps.getModulesJARs().asStream("netigso-bundles");
            if (is == null) {
                File f;
                try {
                    f = this.getNetigsoCache();
                }
                catch (IllegalStateException ex) {
                    return;
                }
                this.deleteRec(f);
                return;
            }
            Properties p = new Properties();
            p.load(is);
            is.close();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String k = (String)entry.getKey();
                String v = (String)entry.getValue();
                this.registered.put(k, v.split(","));
                LOG.log(Level.FINE, "readBundle: {0}", k);
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Cannot read cache", ex);
        }
    }

    public void flushCaches(DataOutputStream os) throws IOException {
        Properties p = new Properties();
        for (Map.Entry<String, String[]> entry : this.registered.entrySet()) {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (String s : entry.getValue()) {
                sb.append(sep);
                sb.append(s);
                sep = ",";
            }
            p.setProperty(entry.getKey(), sb.toString());
        }
        p.store(os, null);
    }

    public void cacheReady() {
    }

    private Bundle findBundle(String codeNameBase) {
        for (Bundle bb : this.framework.getBundleContext().getBundles()) {
            String bbName = bb.getSymbolicName().replace('-', '_');
            if (!bbName.equals(codeNameBase)) continue;
            return bb;
        }
        return null;
    }

    public byte[] fromArchive(long bundleId, String resource, ArchiveResources ar) throws IOException {
        if (Boolean.TRUE.equals(SELF_QUERY.get())) {
            return ar.resource(resource);
        }
        return this.fromArchive(ar, resource);
    }

    private static String toURI(File file) {
        class VFile
        extends File {
            final /* synthetic */ File val$file;

            public VFile(File file) {
                this.val$file = file;
                super(file.getPath());
            }

            @Override
            public boolean isDirectory() {
                return false;
            }

            @Override
            public File getAbsoluteFile() {
                return this;
            }
        }
        return new VFile(file).toURI().toString();
    }
}

