/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.modules.favorites.FavoritesNode;
import org.netbeans.modules.favorites.Tab;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public final class Actions {
    private static File currentDir = null;
    private static final Logger LOG = Logger.getLogger(Actions.class.getName());

    private Actions() {
    }

    public static ContextAwareAction add() {
        return Add.getDefault();
    }

    public static Action addOnFavoritesNode() {
        return AddOnFavoritesNode.getDefault();
    }

    public static Action remove() {
        return Remove.getDefault();
    }

    public static ContextAwareAction select() {
        return Select.getDefault();
    }

    public static class AddOnFavoritesNode
    extends Add {
        static final long serialVersionUID = -6471284573153172312L;
        private static final AddOnFavoritesNode ADD_ON_FAVORITES_NODE = new AddOnFavoritesNode();

        public static ContextAwareAction getDefault() {
            return ADD_ON_FAVORITES_NODE;
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(Actions.class, (String)"ACT_AddOnFavoritesNode");
        }
    }

    public static class Add
    extends NodeAction {
        static final long serialVersionUID = -6471281373153172312L;
        private static final Add ADD = new Add();

        public static ContextAwareAction getDefault() {
            return ADD;
        }

        private Add() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        public boolean enable(Node[] arr) {
            if (arr == null || arr.length == 0) {
                return false;
            }
            if (arr.length == 1 && arr[0] instanceof FavoritesNode) {
                return true;
            }
            for (int i = 0; i < arr.length; ++i) {
                DataObject dataObject = (DataObject)arr[i].getCookie(DataObject.class);
                if (Add.isAllowed(dataObject)) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(Actions.class, (String)"ACT_Add");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(Add.class);
        }

        protected void performAction(Node[] activatedNodes) {
            try {
                List<Object> toShadows;
                if (activatedNodes.length == 1 && activatedNodes[0] instanceof FavoritesNode) {
                    FileObject fo = Add.chooseFileObject();
                    if (fo == null) {
                        return;
                    }
                    toShadows = Collections.singletonList(DataObject.find((FileObject)fo));
                } else {
                    toShadows = new ArrayList();
                    for (Node node : activatedNodes) {
                        DataObject obj = (DataObject)node.getCookie(DataObject.class);
                        if (obj == null) continue;
                        toShadows.add(obj);
                    }
                }
                Tab.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        Add.addToFavorites(toShadows);
                    }
                });
            }
            catch (DataObjectNotFoundException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }

        private static FileObject chooseFileObject() {
            int option;
            FileObject retVal = null;
            File chooserSelection = null;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(2);
            chooser.setDialogTitle(NbBundle.getBundle(Actions.class).getString("CTL_DialogTitle"));
            chooser.setApproveButtonText(NbBundle.getBundle(Actions.class).getString("CTL_ApproveButtonText"));
            if (currentDir != null) {
                chooser.setCurrentDirectory(currentDir);
            }
            if ((option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                chooserSelection = chooser.getSelectedFile();
                File selectedFile = FileUtil.normalizeFile((File)chooserSelection);
                if (!selectedFile.exists() && selectedFile.getParentFile() != null && selectedFile.getParentFile().exists() && selectedFile.getName().equals(selectedFile.getParentFile().getName())) {
                    selectedFile = selectedFile.getParentFile();
                }
                if (!new File(selectedFile, "").exists()) {
                    String message = NbBundle.getMessage(Actions.class, (String)"ERR_FileDoesNotExist", (Object)selectedFile.getPath());
                    String title = NbBundle.getMessage(Actions.class, (String)"ERR_FileDoesNotExistDlgTitle");
                    DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)message, title, -1, 1, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.OK_OPTION));
                } else {
                    retVal = FileUtil.toFileObject((File)selectedFile);
                    assert (retVal != null);
                }
            }
            currentDir = chooser.getCurrentDirectory();
            return retVal;
        }

        public static void selectAfterAddition(DataObject createdDO) {
            final Tab projectsTab = Tab.findDefault();
            projectsTab.open();
            projectsTab.requestActive();
            if (createdDO != null) {
                Node[] nodes = projectsTab.getExplorerManager().getRootContext().getChildren().getNodes(true);
                final Node[] toSelect = new Node[1];
                boolean setSelected = false;
                for (int i = 0; i < nodes.length; ++i) {
                    if (!createdDO.getName().equals(nodes[i].getName())) continue;
                    toSelect[0] = nodes[i];
                    setSelected = true;
                    break;
                }
                if (setSelected) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                projectsTab.getExplorerManager().setExploredContextAndSelection(toSelect[0], toSelect);
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }

        static DataObject createShadows(DataFolder favourities, List<DataObject> dos, List<DataObject> listAdd) {
            DataShadow createdDO = null;
            for (DataObject obj : dos) {
                try {
                    DataShadow added = Add.findShadow(favourities, obj);
                    if (added != null) {
                        if (createdDO != null) continue;
                        createdDO = added;
                        continue;
                    }
                    if (createdDO == null) {
                        createdDO = obj.createShadow(favourities);
                        listAdd.add((DataObject)createdDO);
                        continue;
                    }
                    listAdd.add((DataObject)obj.createShadow(favourities));
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
            return createdDO;
        }

        private static DataShadow findShadow(DataFolder f, DataObject dobj) {
            FileObject fo = dobj.getPrimaryFile();
            if (fo != null) {
                DataObject[] arr = f.getChildren();
                for (int i = 0; i < arr.length; ++i) {
                    DataShadow obj;
                    if (!(arr[i] instanceof DataShadow) || !fo.equals((obj = (DataShadow)arr[i]).getOriginal().getPrimaryFile())) continue;
                    return obj;
                }
            }
            return null;
        }

        public static void reorderAfterAddition(DataFolder favourities, DataObject[] children, List<? extends DataObject> listAdd) {
            ArrayList<Object> listDest = new ArrayList<Object>();
            if (listAdd.size() > 0) {
                int i;
                Object root = null;
                for (i = 0; i < children.length; ++i) {
                    FileObject fo = children[i].getPrimaryFile();
                    if (!"Favorites/Root.instance".equals(fo.getPath())) continue;
                    root = children[i];
                }
                if (root != null) {
                    for (i = 0; i < children.length; ++i) {
                        if (root.equals(children[i])) continue;
                        listDest.add(children[i]);
                    }
                    listDest.addAll(listAdd);
                    listDest.add(root);
                } else {
                    listDest.addAll(Arrays.asList(children));
                    listDest.addAll(listAdd);
                }
                DataObject[] newOrder = listDest.toArray(new DataObject[listDest.size()]);
                try {
                    favourities.setOrder(newOrder);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }

        static void addToFavorites(List<DataObject> toShadows) {
            assert (!EventQueue.isDispatchThread());
            DataFolder f = FavoritesNode.getFolder();
            DataObject[] arr = f.getChildren();
            ArrayList<DataObject> listAdd = new ArrayList<DataObject>();
            final DataObject toSelect = Add.createShadows(f, toShadows, listAdd);
            Add.reorderAfterAddition(f, arr, listAdd);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Add.selectAfterAddition(toSelect);
                }
            });
        }

        static boolean isAllowed(DataObject dataObject) {
            if (dataObject == null) {
                return false;
            }
            FileObject fo = dataObject.getPrimaryFile();
            if (fo != null) {
                if (URLMapper.findURL((FileObject)fo, (int)1) == null) {
                    return false;
                }
                File file = FileUtil.toFile((FileObject)fo);
                if (file != null && file.getParent() == null) {
                    return false;
                }
            }
            try {
                if (dataObject.getPrimaryFile().getFileSystem().isDefault()) {
                    return false;
                }
            }
            catch (FileStateInvalidException fsie) {
                return false;
            }
            return true;
        }
    }

    private static class Remove
    extends NodeAction {
        static final long serialVersionUID = -6471281373153172312L;
        private static final Remove REMOVE = new Remove();

        private Remove() {
        }

        public static Action getDefault() {
            return REMOVE;
        }

        public boolean enable(Node[] arr) {
            if (arr == null || arr.length == 0) {
                return false;
            }
            for (int i = 0; i < arr.length; ++i) {
                DataObject shad = (DataObject)arr[i].getCookie(DataObject.class);
                if (shad != null && shad.getFolder() == FavoritesNode.getFolder()) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(Actions.class, (String)"ACT_Remove");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(Remove.class);
        }

        protected void performAction(Node[] arr) {
            for (int i = 0; i < arr.length; ++i) {
                DataObject shad = (DataObject)arr[i].getCookie(DataObject.class);
                if (shad == null || shad.getFolder() != FavoritesNode.getFolder()) continue;
                try {
                    shad.delete();
                    continue;
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class Select
    extends NodeAction {
        private static final Select SELECT = new Select();

        public static ContextAwareAction getDefault() {
            return SELECT;
        }

        private Select() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        protected void performAction(final Node[] activatedNodes) {
            final Tab proj = Tab.findDefault();
            Tab.RP.post(new Runnable(){

                @Override
                public void run() {
                    proj.doSelectNode((DataObject)activatedNodes[0].getCookie(DataObject.class));
                }
            });
        }

        protected boolean enable(Node[] activatedNodes) {
            if (activatedNodes.length != 1) {
                return false;
            }
            DataObject dobj = (DataObject)activatedNodes[0].getCookie(DataObject.class);
            return dobj != null;
        }

        public String getName() {
            return NbBundle.getMessage(Select.class, (String)"ACT_Select_Main_Menu");
        }

        protected String iconResource() {
            return "org/netbeans/modules/favorites/resources/actionView.png";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return false;
        }
    }
}

