/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import java.lang.reflect.Array;

public class Converter {
    public static Class getPrimitiveType(Class clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    public static Class getReferenceType(Class clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    public static boolean isAssignableFrom(Class clazz, Class clazz2) {
        if (clazz == null || clazz2 == null) {
            return false;
        }
        return Converter.getReferenceType(clazz).isAssignableFrom(Converter.getReferenceType(clazz2));
    }

    public static Object changeArrayType(Object object, Class clazz) {
        if (object == null) {
            return null;
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("objectArray parameter must be an array");
        }
        int n = Array.getLength(object);
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = Array.get(object, i);
        }
        return objectArray;
    }

    public static Object convertFrom(String string, Class clazz) throws IllegalArgumentException {
        return Converter.descriptor(clazz).convert(string);
    }

    public static String convertTo(Object object, Class clazz) throws IllegalArgumentException {
        return Converter.descriptor(clazz).convert(object);
    }

    public static Object convertFrom(String string, String string2) throws IllegalArgumentException {
        return Converter.descriptor(string2).convert(string);
    }

    public static String convertTo(Object object, String string) throws IllegalArgumentException {
        return Converter.descriptor(string).convert(object);
    }

    public static Class getClassForType(String string) throws IllegalArgumentException {
        return Converter.descriptor(string).getType();
    }

    public static Object convert(Object object, Class clazz, Class clazz2) {
        TypeDescriptor typeDescriptor = Converter.descriptor(clazz);
        TypeDescriptor typeDescriptor2 = Converter.descriptor(clazz2);
        String string = typeDescriptor.convert(object);
        return typeDescriptor2.convert(string);
    }

    private static TypeDescriptor descriptor(String string) {
        TypeDescriptor typeDescriptor = TypeRegistry.getDefault().getType(string);
        if (typeDescriptor == null) {
            throw new IllegalArgumentException("No type descriptor found for type name " + string);
        }
        return typeDescriptor;
    }

    private static TypeDescriptor descriptor(Class clazz) {
        TypeDescriptor typeDescriptor = TypeRegistry.getDefault().getType(clazz);
        if (typeDescriptor == null) {
            throw new IllegalArgumentException("No type descriptor found for type " + clazz);
        }
        return typeDescriptor;
    }
}

