/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.StringConverter;
import com.paterva.maltego.typing.transforms.TransformMatcher;
import com.paterva.maltego.util.StringUtilities;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.Transformer;

public class DefaultStringConverter
implements StringConverter {
    private Transformer _transformer;
    private static DefaultStringConverter _default;

    public DefaultStringConverter(Matcher matcher) {
        this._transformer = new Transformer(matcher);
    }

    public static DefaultStringConverter instance() {
        if (_default == null) {
            _default = new DefaultStringConverter(new TransformMatcher());
        }
        return _default;
    }

    @Override
    public Object convertFrom(String string, Class clazz) throws IllegalArgumentException {
        if (String.class.equals((Object)clazz)) {
            return string;
        }
        if (StringUtilities.isNullOrEmpty((String)string)) {
            return null;
        }
        try {
            return this._transformer.read(string, clazz);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot convert value \"" + string + "\" to type \"" + clazz.getSimpleName() + "\"", exception);
        }
    }

    @Override
    public String convertTo(Object object, Class clazz) throws IllegalArgumentException {
        if (object == null) {
            return null;
        }
        try {
            return this._transformer.write(object, clazz);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot convert value \"" + object + "\" of type \"" + clazz.getSimpleName() + "\" to type \"string\"", exception);
        }
    }
}

