/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.about;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.welcome.about.AboutBoxControl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Locale;
import javax.swing.JDialog;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class AboutBoxAction
extends CallableSystemAction {
    private static final String PROP_FULLNAME = "maltego.registeredto.fullname";
    private static final String PROP_VALIDFROM = "maltego.registeredto.validfrom";
    private static final String PROP_VALIDTO = "maltego.registeredto.validto";
    private static final String PROP_LICENSE_KEY = "maltego.registeredto.license-key";
    private static final String PROP_PRODUCT_NAME = "maltego.product-name";

    public void performAction() {
        Component component = this.createAbountControl();
        JDialog jDialog = new JDialog();
        jDialog.setUndecorated(true);
        jDialog.setModal(true);
        jDialog.add(component);
        jDialog.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = (dimension.width - jDialog.getWidth()) / 2;
        int n2 = (dimension.height - jDialog.getHeight()) / 2;
        jDialog.setLocation(n, n2);
        jDialog.setVisible(true);
    }

    private Component createAbountControl() {
        AboutBoxControl aboutBoxControl = new AboutBoxControl();
        String string = String.format("%s %s %s", System.getProperty(PROP_PRODUCT_NAME, "Maltego Client"), System.getProperty("maltego.fullversion"), System.getProperty("maltego.version-subtitle", ""));
        String string2 = System.getProperty("maltego.oem", "");
        if (!StringUtilities.isNullOrEmpty((String)string2)) {
            string = string + " (" + string2 + ")";
        }
        aboutBoxControl.setProductTitle(string);
        String string3 = System.getProperty(PROP_LICENSE_KEY, null);
        if (string3 == null) {
            aboutBoxControl.setRegistrationStatus("No valid license found");
        } else {
            aboutBoxControl.setOwner(System.getProperty(PROP_FULLNAME, ""));
            aboutBoxControl.setLicenseKey(string3);
            aboutBoxControl.setValidUntil(System.getProperty(PROP_VALIDTO, ""));
            aboutBoxControl.setValidFrom(System.getProperty(PROP_VALIDFROM, ""));
            aboutBoxControl.setRegistrationStatus("Valid license");
        }
        aboutBoxControl.setOS(this.getOSInfo());
        aboutBoxControl.setJavaVersion(System.getProperty("java.version", "unknown"));
        aboutBoxControl.setJavaVM(System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", ""));
        aboutBoxControl.setLocale(Locale.getDefault().toString());
        return aboutBoxControl;
    }

    private String getOSInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("os.name", "unknown"));
        stringBuilder.append(" ");
        stringBuilder.append(System.getProperty("os.version", "unknown"));
        stringBuilder.append(" ");
        stringBuilder.append(System.getProperty("os.arch", "unknown"));
        return stringBuilder.toString();
    }

    public String getName() {
        return NbBundle.getMessage(AboutBoxAction.class, (String)"CTL_AboutBoxAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

