/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.login;

import com.paterva.maltego.typing.editing.inputform.InputForm;
import com.paterva.maltego.typing.editing.inputform.InputFormSerializer;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import com.paterva.maltego.util.ui.http.HttpAgent;
import com.paterva.maltego.welcome.login.LoginFailedControl;
import com.paterva.maltego.welcome.login.LoginResponseForm;
import com.paterva.maltego.welcome.login.LoginSegment;
import com.paterva.maltego.welcome.login.LoginSuccessControl;
import com.paterva.maltego.welcome.login.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.util.NbPreferences;

class LoginResponseController
extends PassFailProgressController<LoginResponseForm, LoginSuccessControl, LoginFailedControl> {
    LoginResponseController() {
    }

    protected LoginResponseForm doProcessing(WizardDescriptor wizardDescriptor, ProgressHandle progressHandle) throws IOException {
        URL uRL = this.getResponseUrl(wizardDescriptor);
        InputForm inputForm = (InputForm)wizardDescriptor.getProperty("loginForm");
        String string = new InputFormSerializer().writeFormData(inputForm);
        String string2 = (String)inputForm.getValue("username");
        NbPreferences.forModule(LoginSegment.class).put("maltego.ce.username", string2);
        string = Utils.addHeader(string);
        HttpAgent httpAgent = new HttpAgent(uRL);
        httpAgent.setTrustAllCerts(false);
        httpAgent.setRequireCNSuffix(".paterva.com");
        String string3 = httpAgent.doPostString("text/xml", string);
        string3 = Utils.stripMessageHeader(string3);
        LoginResponseForm loginResponseForm = new LoginResponseForm();
        new InputFormSerializer().readFormData((InputForm)loginResponseForm, string3);
        if (loginResponseForm.isEmpty()) {
            throw new IOException("Could not parse response from server");
        }
        return loginResponseForm;
    }

    private URL getResponseUrl(WizardDescriptor wizardDescriptor) {
        InputForm inputForm = (InputForm)wizardDescriptor.getProperty("loginForm");
        String string = inputForm.getPostBack();
        URL uRL = null;
        if (!StringUtilities.isNullOrEmpty((String)string)) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            uRL = (URL)wizardDescriptor.getProperty("loginResponseUrl");
        }
        return uRL;
    }

    protected LoginSuccessControl createPassComponent() {
        return new LoginSuccessControl();
    }

    protected LoginFailedControl createFailComponent() {
        return new LoginFailedControl();
    }

    protected void pass(WizardDescriptor wizardDescriptor, LoginSuccessControl loginSuccessControl, LoginResponseForm loginResponseForm) {
        loginSuccessControl.setEmail(loginResponseForm.getEmail());
        loginSuccessControl.setFirstName(loginResponseForm.getFirstName());
        loginSuccessControl.setSurname(loginResponseForm.getLastName());
        loginSuccessControl.setValidUntil(loginResponseForm.getValidUntil());
        LoginSegment.updateLoginInformation(loginResponseForm);
    }

    protected void fail(LoginFailedControl loginFailedControl, Exception exception) {
        loginFailedControl.setRegistrationUrl((URL)this.getDescriptor().getProperty("registrationUrl"));
        loginFailedControl.setError(exception.getMessage());
    }
}

