/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.login;

import com.paterva.maltego.transform.descriptor.TransformApiKeyProvider;
import com.paterva.maltego.typing.editing.inputform.InputForm;
import com.paterva.maltego.typing.editing.inputform.InputFormSerializer;
import com.paterva.maltego.util.ListMap;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.AbstractWizardSegment;
import com.paterva.maltego.util.ui.dialog.WizardSegment;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import com.paterva.maltego.welcome.login.LoginRequestController;
import com.paterva.maltego.welcome.login.LoginResponseController;
import com.paterva.maltego.welcome.login.LoginResponseForm;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.prefs.Preferences;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class LoginSegment
extends AbstractWizardSegment {
    private String _loginRequestUrl = "https://www.paterva.com/CEIntegration/";
    private String _loginResponseUrl = "https://www.paterva.com/CEIntegration/";
    private String _registrationUrl = "http://www.paterva.com/redirect/m3ceregister.html";

    private LoginSegment(Map map) {
        super(map);
    }

    public WizardDescriptor.Panel[] createPanels() {
        LoginRequestController loginRequestController = new LoginRequestController();
        loginRequestController.setName("Login");
        LoginResponseController loginResponseController = new LoginResponseController();
        loginResponseController.setName("Login result");
        return new WizardDescriptor.Panel[]{loginRequestController, loginResponseController};
    }

    public void initialize(WizardDescriptor wizardDescriptor, WizardDescriptor.Panel[] panelArray) {
        super.initialize(wizardDescriptor, panelArray);
        try {
            wizardDescriptor.putProperty("loginRequestUrl", (Object)new URL(this._loginRequestUrl));
            wizardDescriptor.putProperty("loginResponseUrl", (Object)new URL(this._loginResponseUrl));
            wizardDescriptor.putProperty("registrationUrl", (Object)new URL(this._registrationUrl));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
    }

    public static WizardDescriptor createWizard() {
        WizardDescriptor wizardDescriptor = WizardUtilities.createWizard((WizardSegment)new LoginSegment(Collections.emptyMap()));
        wizardDescriptor.setTitle("Invalid API key - please login");
        return wizardDescriptor;
    }

    public static WizardSegment segment(Map map) {
        if (LoginSegment.isLoggedIn()) {
            return null;
        }
        return new LoginSegment(map);
    }

    private static boolean isLoggedIn() {
        InputFormSerializer inputFormSerializer = new InputFormSerializer();
        Preferences preferences = NbPreferences.forModule(LoginSegment.class);
        String string = preferences.get("maltego.ce.login-details", null);
        if (string != null) {
            try {
                System.out.println("--==<isLoggedIn>==--");
                System.out.println(string);
                LoginResponseForm loginResponseForm = new LoginResponseForm();
                inputFormSerializer.readFormData((InputForm)loginResponseForm, string);
                if (!StringUtilities.isNullOrEmpty((String)loginResponseForm.getApiKey()) && loginResponseForm.getValidUntil() != null) {
                    LoginSegment.updateLoginInformation(loginResponseForm);
                    return loginResponseForm.getValidUntil().after(new Date());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static synchronized void updateLoginInformation(LoginResponseForm loginResponseForm) {
        System.setProperty("maltego.registeredto.license-key", "Community Access");
        System.setProperty("maltego.registeredto.fullname", loginResponseForm.getFullName());
        System.setProperty("maltego.registeredto.email", loginResponseForm.getEmail());
        System.setProperty("maltego.registeredto.firstname", loginResponseForm.getFirstName());
        System.setProperty("maltego.registeredto.lastname", loginResponseForm.getLastName());
        System.setProperty("maltego.registeredto.country", "");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        System.setProperty("maltego.registeredto.validfrom", dateFormat.format(new Date()));
        System.setProperty("maltego.registeredto.validto", dateFormat.format(loginResponseForm.getValidUntil()));
        System.setProperty("maltego.registeredto.lastname", loginResponseForm.getLastName());
        if (loginResponseForm.getNamespace() != null) {
            System.setProperty("maltego.registeredto.namespace", loginResponseForm.getNamespace());
        }
        if (TransformApiKeyProvider.Mapped.instance() != null) {
            TransformApiKeyProvider.Mapped.instance().setKeyMap(LoginSegment.parseApiKeys(loginResponseForm.getApiKey()));
        }
        try {
            InputFormSerializer inputFormSerializer = new InputFormSerializer();
            String string = inputFormSerializer.writeFormData((InputForm)loginResponseForm);
            Preferences preferences = NbPreferences.forModule(LoginSegment.class);
            preferences.put("maltego.ce.login-details", string);
            System.out.println("--==<updateLoginInformation>==--");
            System.out.println(string);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static Map<String, String> parseApiKeys(String string) {
        int n = string.indexOf(64);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        ListMap listMap = new ListMap();
        listMap.put((Object)string3, (Object)string2);
        return listMap;
    }
}

