/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.entity.manager.forms.DisplayDescriptorNode;
import com.paterva.maltego.entity.manager.forms.DisplayDescriptorTableModel;
import com.paterva.maltego.entity.manager.forms.NewDisplayDescriptorController;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.table.EditableTableDecorator;
import com.paterva.maltego.util.ui.table.TableButtonCallback;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class DisplayDescriptorEditControl
extends JPanel {
    private DisplayDescriptorTableModel _tableModel;
    private PropertySheet _properties;
    private DisplayDescriptor _valueDescriptor;
    private JButton _addButton;
    private JPanel _buttonPanel;
    private JSplitPane _splitPane;
    private ETable _table;
    private JScrollPane jScrollPane1;

    public DisplayDescriptorEditControl() {
        this.initComponents();
        this.setName("Additional Properties");
        this._properties = new PropertySheet();
        this._properties.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this._splitPane.setRightComponent((Component)this._properties);
        this._tableModel = new DisplayDescriptorTableModel();
        this._table.setModel((TableModel)((Object)this._tableModel));
        HighlightRenderer highlightRenderer = new HighlightRenderer();
        this._table.setDefaultRenderer(String.class, (TableCellRenderer)highlightRenderer);
        EditableTableDecorator editableTableDecorator = new EditableTableDecorator();
        editableTableDecorator.addDelete((JTable)this._table, new TableButtonCallback(){

            public boolean isButtonEnabled(JTable jTable, String string, int n) {
                return DisplayDescriptorEditControl.this._valueDescriptor != DisplayDescriptorEditControl.this._tableModel.getRow(n);
            }
        });
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DisplayDescriptorEditControl.this.updateSelection();
            }
        });
    }

    private void updateSelection() {
        List list = this._tableModel.getRows(this._table.getSelectedRows());
        DisplayDescriptorNode[] displayDescriptorNodeArray = new DisplayDescriptorNode[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            displayDescriptorNodeArray[i] = new DisplayDescriptorNode((DisplayDescriptor)list.get(i));
        }
        this._properties.setNodes((Node[])displayDescriptorNodeArray);
    }

    private void initComponents() {
        this._buttonPanel = new JPanel();
        this._addButton = new JButton();
        this._splitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this._table = new ETable();
        this.setPreferredSize(new Dimension(200, 150));
        this.setLayout(new BorderLayout());
        this._addButton.setText(NbBundle.getMessage(DisplayDescriptorEditControl.class, (String)"DisplayDescriptorEditControl._addButton.text"));
        this._addButton.setBorderPainted(false);
        this._addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplayDescriptorEditControl.this._addButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this._buttonPanel);
        this._buttonPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(252, Short.MAX_VALUE).addComponent(this._addButton).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this._addButton).addContainerGap()));
        this.add((Component)this._buttonPanel, "First");
        this._splitPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._splitPane.setDividerLocation(200);
        this._table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._table.setPreferredScrollableViewportSize(new Dimension(250, 300));
        this.jScrollPane1.setViewportView((Component)this._table);
        this._splitPane.setLeftComponent(this.jScrollPane1);
        this.add((Component)this._splitPane, "Center");
    }

    private void _addButtonActionPerformed(ActionEvent actionEvent) {
        EditDialogDescriptor editDialogDescriptor = new EditDialogDescriptor("Add New Property", (WizardDescriptor.Panel)new NewDisplayDescriptorController());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)editDialogDescriptor) == EditDialogDescriptor.OK_OPTION) {
            String string = (String)editDialogDescriptor.getProperty("name");
            TypeDescriptor typeDescriptor = (TypeDescriptor)editDialogDescriptor.getProperty("type");
            String string2 = (String)editDialogDescriptor.getProperty("displayName");
            DisplayDescriptor displayDescriptor = new DisplayDescriptor(typeDescriptor.getType(), string, string2);
            this._tableModel.addRow(displayDescriptor);
        }
    }

    public void setDescriptors(DisplayDescriptorCollection displayDescriptorCollection) {
        this._tableModel.setRows((List)displayDescriptorCollection);
    }

    public void setValueDescriptor(DisplayDescriptor displayDescriptor) {
        this._valueDescriptor = displayDescriptor;
    }

    private class HighlightRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private HighlightRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Font font = component.getFont();
            if (DisplayDescriptorEditControl.this._tableModel.getRow(n) == DisplayDescriptorEditControl.this._valueDescriptor) {
                component.setFont(new Font(font.getName(), font.getSize(), 1));
            } else {
                component.setFont(new Font(font.getName(), font.getSize(), 0));
            }
            return component;
        }
    }
}

