/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.netbeans.modules.options.keymap.Popupable;
import org.netbeans.modules.options.keymap.ShortcutTextField;
import org.netbeans.modules.options.keymap.SpecialkeyPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ShortcutCellPanel
extends JPanel
implements Comparable,
Popupable {
    private Popup popup;
    private final SpecialkeyPanel specialkeyList;
    PopupFactory factory = PopupFactory.getSharedInstance();
    private JButton changeButton;
    private JTextField scField;

    public ShortcutCellPanel() {
        this.initComponents();
        this.specialkeyList = new SpecialkeyPanel(this, this.scField);
        this.changeButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ShortcutCellPanel.this.hidePopup();
            }
        });
        this.changeButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    JTable table = (JTable)ShortcutCellPanel.this.scField.getParent().getParent();
                    int editingRow = table.getEditingRow();
                    table.editCellAt(editingRow, 1);
                    table.setRowSelectionInterval(editingRow, editingRow);
                    ShortcutCellPanel.this.scField.requestFocus();
                }
            }
        });
        this.scField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ShortcutCellPanel.this.changeButton.setText("");
                ShortcutCellPanel.this.changeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/options/keymap/more.png")));
            }

            @Override
            public void focusLost(FocusEvent e) {
                ShortcutCellPanel.this.changeButton.setIcon(null);
                ShortcutCellPanel.this.changeButton.setText("...");
            }
        });
    }

    ShortcutCellPanel(String displayedShortcut) {
        this();
        this.setText(displayedShortcut);
    }

    public void setText(String shortcut) {
        this.scField.setText(shortcut);
    }

    public void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public String toString() {
        return this.scField.getText();
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        int buttonWidth = this.changeButton.getPreferredSize().width;
        this.scField.setPreferredSize(new Dimension(d.width - buttonWidth, d.height));
        this.changeButton.setPreferredSize(new Dimension(buttonWidth, d.height));
    }

    void setBgColor(Color col) {
        this.scField.setBackground(col);
        this.changeButton.setBackground(new Color(204, 204, 204));
    }

    void setFgCOlor(Color col) {
        this.scField.setForeground(col);
    }

    public JButton getButton() {
        return this.changeButton;
    }

    public JTextField getTextField() {
        return this.scField;
    }

    private void initComponents() {
        this.scField = new ShortcutTextField();
        this.changeButton = new JButton();
        this.setBackground(new Color(204, 204, 204));
        this.setPreferredSize(new Dimension(134, 15));
        this.scField.setText(NbBundle.getMessage(ShortcutCellPanel.class, (String)"ShortcutCellPanel.scField.text"));
        this.scField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.changeButton.setBackground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((AbstractButton)this.changeButton, (String)NbBundle.getMessage(ShortcutCellPanel.class, (String)"ShortcutCellPanel.changeButton.text"));
        this.changeButton.setMaximumSize(new Dimension(20, 15));
        this.changeButton.setMinimumSize(new Dimension(20, 15));
        this.changeButton.setPreferredSize(new Dimension(20, 15));
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShortcutCellPanel.this.changeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scField, -1, 119, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.changeButton, -2, 15, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scField, -2, 15, -2).addComponent(this.changeButton, -2, 15, -2));
    }

    private void changeButtonActionPerformed(ActionEvent evt) {
        JComponent tf = (JComponent)evt.getSource();
        Point p = new Point(tf.getX(), tf.getY());
        SwingUtilities.convertPointToScreen(p, this);
        if (this.popup == null) {
            this.popup = Utilities.isUnix() ? PopupFactory.getSharedInstance().getPopup(null, this.specialkeyList, p.x, p.y) : this.factory.getPopup(this, this.specialkeyList, p.x, p.y);
        }
        this.popup.show();
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public Popup getPopup() {
        return this.popup;
    }

    void setButtontext(String text) {
        this.changeButton.setText(text);
    }
}

