/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.attachments;

import com.paterva.maltego.typing.editing.AttachmentUtils;
import com.paterva.maltego.typing.types.Attachment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public class AttachmentsExportAction
extends NodeAction {
    public static String PREF_PREV_DIR = "attachmentExportPrevDir";

    public String getName() {
        return "Export";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodeArray) {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.getPrevDir());
        jFileChooser.setDialogTitle("Select a folder");
        jFileChooser.setFileSelectionMode(1);
        if (0 == jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) && (file = jFileChooser.getSelectedFile()).isDirectory()) {
            String string = file.getAbsolutePath();
            this.setPrevDir(string);
            this.saveSelectedItems(string, this.getAttachments(nodeArray));
        }
    }

    public boolean enable(Node[] nodeArray) {
        return !this.getAttachments(nodeArray).isEmpty();
    }

    private List<Attachment> getAttachments(Node[] nodeArray) {
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        for (Node node : nodeArray) {
            Attachment attachment = (Attachment)node.getLookup().lookup(Attachment.class);
            if (attachment == null) continue;
            arrayList.add(attachment);
        }
        return arrayList;
    }

    private void saveSelectedItems(String string, List<Attachment> list) {
        int n = AttachmentUtils.export(string, list);
        String string2 = list.size() == n ? (n == 1 ? "The file was exported successfully." : "All files were exported successfully.") : (n == 0 ? "No files were exported" : n + " of " + list.size() + " files exported successfully.");
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private String getPrevDir() {
        return NbPreferences.forModule(AttachmentsExportAction.class).get(PREF_PREV_DIR, "");
    }

    private void setPrevDir(String string) {
        NbPreferences.forModule(AttachmentsExportAction.class).put(PREF_PREV_DIR, string);
    }
}

