/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.typing.editing.controls.SimpleColorPicker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class SimpleColorButton
extends JButton {
    public static final String PROP_SELECTED_COLOR = "selectedColor";
    private Color _selectedColor = Color.WHITE;
    private ColorPickerPopup _popup;
    private PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    public SimpleColorButton() {
        this.setText("   ");
        ColorButtonListener colorButtonListener = new ColorButtonListener();
        this.addMouseListener(colorButtonListener);
        this.addAncestorListener(colorButtonListener);
    }

    public void setSelectedColor(Color color) {
        Color color2 = this._selectedColor;
        this._selectedColor = color;
        this._changeSupport.firePropertyChange(PROP_SELECTED_COLOR, color2, this._selectedColor);
    }

    public Color getSelectedColor() {
        return this._selectedColor;
    }

    public void addColorListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeColorListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = 4;
        graphics.setColor(this._selectedColor);
        graphics.fillRect(4, 4, this.getWidth() - 8, this.getHeight() - 8);
    }

    private class ColorButtonListener
    extends MouseAdapter
    implements AncestorListener {
        private ColorButtonListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.toggleShowPopup();
        }

        public void toggleShowPopup() {
            if (SimpleColorButton.this._popup == null) {
                SimpleColorButton.this._popup = new ColorPickerPopup();
            }
            if (!SimpleColorButton.this._popup.isVisible()) {
                SimpleColorButton.this._popup.show(SimpleColorButton.this, 0, SimpleColorButton.this.getHeight());
            } else {
                SimpleColorButton.this._popup.setVisible(false);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            if (SimpleColorButton.this._popup != null) {
                SimpleColorButton.this._popup.setVisible(false);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }

    private class ColorPickerPopup
    extends JPopupMenu
    implements PropertyChangeListener {
        SimpleColorPicker picker;

        public ColorPickerPopup() {
            this.createColorPicker();
            this.setLayout(new BorderLayout());
            this.add((Component)this.picker, "Center");
        }

        private void createColorPicker() {
            this.picker = new SimpleColorPicker();
            this.picker.setSelectedColor(SimpleColorButton.this._selectedColor);
            this.picker.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SimpleColorButton.PROP_SELECTED_COLOR.equals(propertyChangeEvent.getPropertyName())) {
                SimpleColorButton.this.setSelectedColor(this.picker.getSelectedColor());
                this.setVisible(false);
            }
        }
    }
}

