/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.types.TimeSpan;
import java.beans.PropertyEditorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeSpanPropertyEditor
extends PropertyEditorSupport {
    @Override
    public String getAsText() {
        TimeSpan timeSpan = (TimeSpan)this.getValue();
        if (timeSpan == null) {
            timeSpan = new TimeSpan(0L);
        }
        long l = timeSpan.getMilliseconds();
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        long l5 = l4 / 24L;
        double d = (double)(l % 60000L) / 1000.0;
        String string = String.format("%dd %dh%dm%.3fs", l5, l4 %= 24L, l3 %= 60L, d);
        return string;
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        Matcher matcher = Pattern.compile("(\\d+)d (\\d+)h(\\d+)m(\\d+(?:\\.\\d+)?)s").matcher(string);
        if (matcher.matches()) {
            long l = Long.parseLong(matcher.group(1));
            long l2 = Long.parseLong(matcher.group(2));
            long l3 = Long.parseLong(matcher.group(3));
            long l4 = (long)(1000.0 * Double.parseDouble(matcher.group(4)));
            long l5 = l4 + 1000L * (60L * (l3 + 60L * (l2 + 24L * l)));
            this.setValue(new TimeSpan(l5));
        }
    }
}

