// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
function escapeQuotesIfString(input, previous) {
    let result = input;
    if (typeof input === "string") {
        result = escapeQuotes(input);
        // check if we need to escape this literal
        if (previous !== "" && !previous.trim().endsWith("'")) {
            result = `'${result}'`;
        }
    }
    return result;
}
export function escapeQuotes(input) {
    return input.replace(/'/g, "''");
}
function encodeDate(input) {
    return input instanceof Date ? `datetime'${input.toISOString()}'` : input;
}
/**
 * Escapes an odata filter expression to avoid errors with quoting string literals.
 * Encodes Date objects.
 */
export function odata(strings, ...values) {
    const fixEncoding = (value, string) => {
        return encodeDate(escapeQuotesIfString(value, string));
    };
    const results = [];
    for (let i = 0; i < strings.length; i++) {
        results.push(strings[i]);
        if (i < values.length) {
            results.push(fixEncoding(values[i], strings[i]));
        }
    }
    return results.join("");
}
//# sourceMappingURL=odata.js.map