// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
export function handleTableAlreadyExists(error, options = {}) {
    var _a, _b;
    const responseError = getErrorResponse(error);
    if (responseError &&
        responseError.status === 409 &&
        ((_a = responseError.parsedBody.odataError) === null || _a === void 0 ? void 0 : _a.code) === "TableAlreadyExists") {
        (_b = options.logger) === null || _b === void 0 ? void 0 : _b.info(`Table ${options.tableName} already Exists`);
        if (options.onResponse) {
            options.onResponse(responseError, {});
        }
    }
    else {
        throw error;
    }
}
function getErrorResponse(error) {
    if (!isRestError(error)) {
        return undefined;
    }
    const errorResponse = error.response;
    if (!errorResponse || !isTableServiceErrorResponse(errorResponse.parsedBody)) {
        return undefined;
    }
    return errorResponse;
}
function isRestError(error) {
    return error.name === "RestError";
}
function isTableServiceErrorResponse(errorResponseBody) {
    return Boolean(errorResponseBody === null || errorResponseBody === void 0 ? void 0 : errorResponseBody.odataError);
}
//# sourceMappingURL=errorHelpers.js.map