// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
export function isCosmosEndpoint(url) {
    var _a, _b;
    const parsedURL = new URL(url);
    if (parsedURL.hostname.indexOf(".table.cosmosdb.") !== -1) {
        return true;
    }
    if (parsedURL.hostname.indexOf(".table.cosmos.") !== -1) {
        return true;
    }
    // Azurite emulator IP-style URL for table?
    if ((parsedURL.hostname === "localhost" || parsedURL.hostname === "127.0.0.1") &&
        parsedURL.pathname.startsWith("/devstoreaccount1")) {
        return false;
    }
    const azuriteAccounts = (_b = (_a = process === null || process === void 0 ? void 0 : process.env) === null || _a === void 0 ? void 0 : _a.AZURITE_ACCOUNTS) === null || _b === void 0 ? void 0 : _b.split(":");
    if ((azuriteAccounts === null || azuriteAccounts === void 0 ? void 0 : azuriteAccounts[0]) && parsedURL.hostname.includes(azuriteAccounts[0])) {
        return false;
    }
    if (parsedURL.hostname === "localhost") {
        return true;
    }
    return false;
}
//# sourceMappingURL=isCosmosEndpoint.js.map