"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceGetStatisticsExceptionHeaders = exports.ServiceGetStatisticsHeaders = exports.ServiceGetPropertiesExceptionHeaders = exports.ServiceGetPropertiesHeaders = exports.ServiceSetPropertiesExceptionHeaders = exports.ServiceSetPropertiesHeaders = exports.TableSetAccessPolicyExceptionHeaders = exports.TableSetAccessPolicyHeaders = exports.TableGetAccessPolicyExceptionHeaders = exports.TableGetAccessPolicyHeaders = exports.TableInsertEntityExceptionHeaders = exports.TableInsertEntityHeaders = exports.TableDeleteEntityExceptionHeaders = exports.TableDeleteEntityHeaders = exports.TableMergeEntityExceptionHeaders = exports.TableMergeEntityHeaders = exports.TableUpdateEntityExceptionHeaders = exports.TableUpdateEntityHeaders = exports.TableQueryEntitiesWithPartitionAndRowKeyExceptionHeaders = exports.TableQueryEntitiesWithPartitionAndRowKeyHeaders = exports.TableQueryEntitiesExceptionHeaders = exports.TableQueryEntitiesHeaders = exports.TableDeleteExceptionHeaders = exports.TableDeleteHeaders = exports.TableCreateExceptionHeaders = exports.TableCreateHeaders = exports.TableQueryExceptionHeaders = exports.TableQueryHeaders = exports.TableResponse = exports.GeoReplication = exports.TableServiceStats = exports.CorsRule = exports.Metrics = exports.RetentionPolicy = exports.Logging = exports.TableServiceProperties = exports.AccessPolicy = exports.SignedIdentifier = exports.TableEntityQueryResponse = exports.TableProperties = exports.TableServiceErrorOdataErrorMessage = exports.TableServiceErrorOdataError = exports.TableServiceError = exports.TableResponseProperties = exports.TableQueryResponse = void 0;
exports.TableQueryResponse = {
    serializedName: "TableQueryResponse",
    type: {
        name: "Composite",
        className: "TableQueryResponse",
        modelProperties: {
            odataMetadata: {
                serializedName: "odata\\.metadata",
                xmlName: "odata\\.metadata",
                type: {
                    name: "String"
                }
            },
            value: {
                serializedName: "value",
                xmlName: "value",
                xmlElementName: "TableResponseProperties",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "TableResponseProperties"
                        }
                    }
                }
            }
        }
    }
};
exports.TableResponseProperties = {
    serializedName: "TableResponseProperties",
    type: {
        name: "Composite",
        className: "TableResponseProperties",
        modelProperties: {
            name: {
                serializedName: "TableName",
                xmlName: "TableName",
                type: {
                    name: "String"
                }
            },
            odataType: {
                serializedName: "odata\\.type",
                xmlName: "odata\\.type",
                type: {
                    name: "String"
                }
            },
            odataId: {
                serializedName: "odata\\.id",
                xmlName: "odata\\.id",
                type: {
                    name: "String"
                }
            },
            odataEditLink: {
                serializedName: "odata\\.editLink",
                xmlName: "odata\\.editLink",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableServiceError = {
    serializedName: "TableServiceError",
    type: {
        name: "Composite",
        className: "TableServiceError",
        modelProperties: {
            odataError: {
                serializedName: "odata\\.error",
                xmlName: "odata\\.error",
                type: {
                    name: "Composite",
                    className: "TableServiceErrorOdataError"
                }
            }
        }
    }
};
exports.TableServiceErrorOdataError = {
    serializedName: "TableServiceErrorOdataError",
    type: {
        name: "Composite",
        className: "TableServiceErrorOdataError",
        modelProperties: {
            code: {
                serializedName: "code",
                xmlName: "code",
                type: {
                    name: "String"
                }
            },
            message: {
                serializedName: "message",
                xmlName: "message",
                type: {
                    name: "Composite",
                    className: "TableServiceErrorOdataErrorMessage"
                }
            }
        }
    }
};
exports.TableServiceErrorOdataErrorMessage = {
    serializedName: "TableServiceErrorOdataErrorMessage",
    type: {
        name: "Composite",
        className: "TableServiceErrorOdataErrorMessage",
        modelProperties: {
            lang: {
                serializedName: "lang",
                xmlName: "lang",
                type: {
                    name: "String"
                }
            },
            value: {
                serializedName: "value",
                xmlName: "value",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableProperties = {
    serializedName: "TableProperties",
    type: {
        name: "Composite",
        className: "TableProperties",
        modelProperties: {
            name: {
                serializedName: "TableName",
                xmlName: "TableName",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableEntityQueryResponse = {
    serializedName: "TableEntityQueryResponse",
    type: {
        name: "Composite",
        className: "TableEntityQueryResponse",
        modelProperties: {
            odataMetadata: {
                serializedName: "odata\\.metadata",
                xmlName: "odata\\.metadata",
                type: {
                    name: "String"
                }
            },
            value: {
                serializedName: "value",
                xmlName: "value",
                xmlElementName: "TableEntityProperties",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Dictionary",
                            value: { type: { name: "any" } }
                        }
                    }
                }
            }
        }
    }
};
exports.SignedIdentifier = {
    serializedName: "SignedIdentifier",
    xmlName: "SignedIdentifier",
    type: {
        name: "Composite",
        className: "SignedIdentifier",
        modelProperties: {
            id: {
                serializedName: "Id",
                required: true,
                xmlName: "Id",
                type: {
                    name: "String"
                }
            },
            accessPolicy: {
                serializedName: "AccessPolicy",
                xmlName: "AccessPolicy",
                type: {
                    name: "Composite",
                    className: "AccessPolicy"
                }
            }
        }
    }
};
exports.AccessPolicy = {
    serializedName: "AccessPolicy",
    xmlName: "AccessPolicy",
    type: {
        name: "Composite",
        className: "AccessPolicy",
        modelProperties: {
            start: {
                serializedName: "Start",
                xmlName: "Start",
                type: {
                    name: "String"
                }
            },
            expiry: {
                serializedName: "Expiry",
                xmlName: "Expiry",
                type: {
                    name: "String"
                }
            },
            permission: {
                serializedName: "Permission",
                xmlName: "Permission",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableServiceProperties = {
    serializedName: "TableServiceProperties",
    xmlName: "StorageServiceProperties",
    type: {
        name: "Composite",
        className: "TableServiceProperties",
        modelProperties: {
            logging: {
                serializedName: "Logging",
                xmlName: "Logging",
                type: {
                    name: "Composite",
                    className: "Logging"
                }
            },
            hourMetrics: {
                serializedName: "HourMetrics",
                xmlName: "HourMetrics",
                type: {
                    name: "Composite",
                    className: "Metrics"
                }
            },
            minuteMetrics: {
                serializedName: "MinuteMetrics",
                xmlName: "MinuteMetrics",
                type: {
                    name: "Composite",
                    className: "Metrics"
                }
            },
            cors: {
                serializedName: "Cors",
                xmlName: "Cors",
                xmlIsWrapped: true,
                xmlElementName: "CorsRule",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "CorsRule"
                        }
                    }
                }
            }
        }
    }
};
exports.Logging = {
    serializedName: "Logging",
    xmlName: "Logging",
    type: {
        name: "Composite",
        className: "Logging",
        modelProperties: {
            version: {
                serializedName: "Version",
                required: true,
                xmlName: "Version",
                type: {
                    name: "String"
                }
            },
            delete: {
                serializedName: "Delete",
                required: true,
                xmlName: "Delete",
                type: {
                    name: "Boolean"
                }
            },
            read: {
                serializedName: "Read",
                required: true,
                xmlName: "Read",
                type: {
                    name: "Boolean"
                }
            },
            write: {
                serializedName: "Write",
                required: true,
                xmlName: "Write",
                type: {
                    name: "Boolean"
                }
            },
            retentionPolicy: {
                serializedName: "RetentionPolicy",
                xmlName: "RetentionPolicy",
                type: {
                    name: "Composite",
                    className: "RetentionPolicy"
                }
            }
        }
    }
};
exports.RetentionPolicy = {
    serializedName: "RetentionPolicy",
    xmlName: "RetentionPolicy",
    type: {
        name: "Composite",
        className: "RetentionPolicy",
        modelProperties: {
            enabled: {
                serializedName: "Enabled",
                required: true,
                xmlName: "Enabled",
                type: {
                    name: "Boolean"
                }
            },
            days: {
                constraints: {
                    InclusiveMinimum: 1
                },
                serializedName: "Days",
                xmlName: "Days",
                type: {
                    name: "Number"
                }
            }
        }
    }
};
exports.Metrics = {
    serializedName: "Metrics",
    type: {
        name: "Composite",
        className: "Metrics",
        modelProperties: {
            version: {
                serializedName: "Version",
                xmlName: "Version",
                type: {
                    name: "String"
                }
            },
            enabled: {
                serializedName: "Enabled",
                required: true,
                xmlName: "Enabled",
                type: {
                    name: "Boolean"
                }
            },
            includeAPIs: {
                serializedName: "IncludeAPIs",
                xmlName: "IncludeAPIs",
                type: {
                    name: "Boolean"
                }
            },
            retentionPolicy: {
                serializedName: "RetentionPolicy",
                xmlName: "RetentionPolicy",
                type: {
                    name: "Composite",
                    className: "RetentionPolicy"
                }
            }
        }
    }
};
exports.CorsRule = {
    serializedName: "CorsRule",
    xmlName: "CorsRule",
    type: {
        name: "Composite",
        className: "CorsRule",
        modelProperties: {
            allowedOrigins: {
                serializedName: "AllowedOrigins",
                required: true,
                xmlName: "AllowedOrigins",
                type: {
                    name: "String"
                }
            },
            allowedMethods: {
                serializedName: "AllowedMethods",
                required: true,
                xmlName: "AllowedMethods",
                type: {
                    name: "String"
                }
            },
            allowedHeaders: {
                serializedName: "AllowedHeaders",
                required: true,
                xmlName: "AllowedHeaders",
                type: {
                    name: "String"
                }
            },
            exposedHeaders: {
                serializedName: "ExposedHeaders",
                required: true,
                xmlName: "ExposedHeaders",
                type: {
                    name: "String"
                }
            },
            maxAgeInSeconds: {
                constraints: {
                    InclusiveMinimum: 0
                },
                serializedName: "MaxAgeInSeconds",
                required: true,
                xmlName: "MaxAgeInSeconds",
                type: {
                    name: "Number"
                }
            }
        }
    }
};
exports.TableServiceStats = {
    serializedName: "TableServiceStats",
    xmlName: "StorageServiceStats",
    type: {
        name: "Composite",
        className: "TableServiceStats",
        modelProperties: {
            geoReplication: {
                serializedName: "GeoReplication",
                xmlName: "GeoReplication",
                type: {
                    name: "Composite",
                    className: "GeoReplication"
                }
            }
        }
    }
};
exports.GeoReplication = {
    serializedName: "GeoReplication",
    xmlName: "GeoReplication",
    type: {
        name: "Composite",
        className: "GeoReplication",
        modelProperties: {
            status: {
                serializedName: "Status",
                required: true,
                xmlName: "Status",
                type: {
                    name: "String"
                }
            },
            lastSyncTime: {
                serializedName: "LastSyncTime",
                required: true,
                xmlName: "LastSyncTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
exports.TableResponse = {
    serializedName: "TableResponse",
    type: {
        name: "Composite",
        className: "TableResponse",
        modelProperties: Object.assign(Object.assign({}, exports.TableResponseProperties.type.modelProperties), { odataMetadata: {
                serializedName: "odata\\.metadata",
                xmlName: "odata\\.metadata",
                type: {
                    name: "String"
                }
            } })
    }
};
exports.TableQueryHeaders = {
    serializedName: "Table_queryHeaders",
    type: {
        name: "Composite",
        className: "TableQueryHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            xMsContinuationNextTableName: {
                serializedName: "x-ms-continuation-nexttablename",
                xmlName: "x-ms-continuation-nexttablename",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableQueryExceptionHeaders = {
    serializedName: "Table_queryExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableQueryExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableCreateHeaders = {
    serializedName: "Table_createHeaders",
    type: {
        name: "Composite",
        className: "TableCreateHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            preferenceApplied: {
                serializedName: "preference-applied",
                xmlName: "preference-applied",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableCreateExceptionHeaders = {
    serializedName: "Table_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableDeleteHeaders = {
    serializedName: "Table_deleteHeaders",
    type: {
        name: "Composite",
        className: "TableDeleteHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
exports.TableDeleteExceptionHeaders = {
    serializedName: "Table_deleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableDeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableQueryEntitiesHeaders = {
    serializedName: "Table_queryEntitiesHeaders",
    type: {
        name: "Composite",
        className: "TableQueryEntitiesHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            xMsContinuationNextPartitionKey: {
                serializedName: "x-ms-continuation-nextpartitionkey",
                xmlName: "x-ms-continuation-nextpartitionkey",
                type: {
                    name: "String"
                }
            },
            xMsContinuationNextRowKey: {
                serializedName: "x-ms-continuation-nextrowkey",
                xmlName: "x-ms-continuation-nextrowkey",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableQueryEntitiesExceptionHeaders = {
    serializedName: "Table_queryEntitiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableQueryEntitiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableQueryEntitiesWithPartitionAndRowKeyHeaders = {
    serializedName: "Table_queryEntitiesWithPartitionAndRowKeyHeaders",
    type: {
        name: "Composite",
        className: "TableQueryEntitiesWithPartitionAndRowKeyHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            xMsContinuationNextPartitionKey: {
                serializedName: "x-ms-continuation-nextpartitionkey",
                xmlName: "x-ms-continuation-nextpartitionkey",
                type: {
                    name: "String"
                }
            },
            xMsContinuationNextRowKey: {
                serializedName: "x-ms-continuation-nextrowkey",
                xmlName: "x-ms-continuation-nextrowkey",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableQueryEntitiesWithPartitionAndRowKeyExceptionHeaders = {
    serializedName: "Table_queryEntitiesWithPartitionAndRowKeyExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableQueryEntitiesWithPartitionAndRowKeyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableUpdateEntityHeaders = {
    serializedName: "Table_updateEntityHeaders",
    type: {
        name: "Composite",
        className: "TableUpdateEntityHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableUpdateEntityExceptionHeaders = {
    serializedName: "Table_updateEntityExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableUpdateEntityExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableMergeEntityHeaders = {
    serializedName: "Table_mergeEntityHeaders",
    type: {
        name: "Composite",
        className: "TableMergeEntityHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableMergeEntityExceptionHeaders = {
    serializedName: "Table_mergeEntityExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableMergeEntityExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableDeleteEntityHeaders = {
    serializedName: "Table_deleteEntityHeaders",
    type: {
        name: "Composite",
        className: "TableDeleteEntityHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
exports.TableDeleteEntityExceptionHeaders = {
    serializedName: "Table_deleteEntityExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableDeleteEntityExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableInsertEntityHeaders = {
    serializedName: "Table_insertEntityHeaders",
    type: {
        name: "Composite",
        className: "TableInsertEntityHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            preferenceApplied: {
                serializedName: "preference-applied",
                xmlName: "preference-applied",
                type: {
                    name: "String"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableInsertEntityExceptionHeaders = {
    serializedName: "Table_insertEntityExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableInsertEntityExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableGetAccessPolicyHeaders = {
    serializedName: "Table_getAccessPolicyHeaders",
    type: {
        name: "Composite",
        className: "TableGetAccessPolicyHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
exports.TableGetAccessPolicyExceptionHeaders = {
    serializedName: "Table_getAccessPolicyExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableGetAccessPolicyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.TableSetAccessPolicyHeaders = {
    serializedName: "Table_setAccessPolicyHeaders",
    type: {
        name: "Composite",
        className: "TableSetAccessPolicyHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
exports.TableSetAccessPolicyExceptionHeaders = {
    serializedName: "Table_setAccessPolicyExceptionHeaders",
    type: {
        name: "Composite",
        className: "TableSetAccessPolicyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.ServiceSetPropertiesHeaders = {
    serializedName: "Service_setPropertiesHeaders",
    type: {
        name: "Composite",
        className: "ServiceSetPropertiesHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.ServiceSetPropertiesExceptionHeaders = {
    serializedName: "Service_setPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceSetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.ServiceGetPropertiesHeaders = {
    serializedName: "Service_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetPropertiesHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.ServiceGetPropertiesExceptionHeaders = {
    serializedName: "Service_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
exports.ServiceGetStatisticsHeaders = {
    serializedName: "Service_getStatisticsHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetStatisticsHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
exports.ServiceGetStatisticsExceptionHeaders = {
    serializedName: "Service_getStatisticsExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetStatisticsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
//# sourceMappingURL=mappers.js.map