/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
import { TableProperties as TablePropertiesMapper, TableServiceProperties as TableServicePropertiesMapper } from "../models/mappers.js";
export const accept = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/json;odata=minimalmetadata",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const url = {
    parameterPath: "url",
    mapper: {
        serializedName: "url",
        required: true,
        xmlName: "url",
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
export const version = {
    parameterPath: "version",
    mapper: {
        defaultValue: "2019-02-02",
        isConstant: true,
        serializedName: "x-ms-version",
        type: {
            name: "String"
        }
    }
};
export const requestId = {
    parameterPath: ["options", "requestId"],
    mapper: {
        serializedName: "x-ms-client-request-id",
        xmlName: "x-ms-client-request-id",
        type: {
            name: "String"
        }
    }
};
export const dataServiceVersion = {
    parameterPath: "dataServiceVersion",
    mapper: {
        defaultValue: "3.0",
        isConstant: true,
        serializedName: "DataServiceVersion",
        type: {
            name: "String"
        }
    }
};
export const format = {
    parameterPath: ["options", "queryOptions", "format"],
    mapper: {
        serializedName: "$format",
        xmlName: "$format",
        type: {
            name: "String"
        }
    }
};
export const top = {
    parameterPath: ["options", "queryOptions", "top"],
    mapper: {
        constraints: {
            InclusiveMinimum: 0
        },
        serializedName: "$top",
        xmlName: "$top",
        type: {
            name: "Number"
        }
    }
};
export const select = {
    parameterPath: ["options", "queryOptions", "select"],
    mapper: {
        serializedName: "$select",
        xmlName: "$select",
        type: {
            name: "String"
        }
    }
};
export const filter = {
    parameterPath: ["options", "queryOptions", "filter"],
    mapper: {
        serializedName: "$filter",
        xmlName: "$filter",
        type: {
            name: "String"
        }
    }
};
export const nextTableName = {
    parameterPath: ["options", "nextTableName"],
    mapper: {
        serializedName: "NextTableName",
        xmlName: "NextTableName",
        type: {
            name: "String"
        }
    }
};
export const contentType = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/json;odata=nometadata",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
export const tableProperties = {
    parameterPath: "tableProperties",
    mapper: TablePropertiesMapper
};
export const responsePreference = {
    parameterPath: ["options", "responsePreference"],
    mapper: {
        serializedName: "Prefer",
        xmlName: "Prefer",
        type: {
            name: "String"
        }
    }
};
export const accept1 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const table = {
    parameterPath: "table",
    mapper: {
        serializedName: "table",
        required: true,
        xmlName: "table",
        type: {
            name: "String"
        }
    }
};
export const timeout = {
    parameterPath: ["options", "timeout"],
    mapper: {
        constraints: {
            InclusiveMinimum: 0
        },
        serializedName: "timeout",
        xmlName: "timeout",
        type: {
            name: "Number"
        }
    }
};
export const nextPartitionKey = {
    parameterPath: ["options", "nextPartitionKey"],
    mapper: {
        serializedName: "NextPartitionKey",
        xmlName: "NextPartitionKey",
        type: {
            name: "String"
        }
    }
};
export const nextRowKey = {
    parameterPath: ["options", "nextRowKey"],
    mapper: {
        serializedName: "NextRowKey",
        xmlName: "NextRowKey",
        type: {
            name: "String"
        }
    }
};
export const partitionKey = {
    parameterPath: "partitionKey",
    mapper: {
        serializedName: "partitionKey",
        required: true,
        xmlName: "partitionKey",
        type: {
            name: "String"
        }
    }
};
export const rowKey = {
    parameterPath: "rowKey",
    mapper: {
        serializedName: "rowKey",
        required: true,
        xmlName: "rowKey",
        type: {
            name: "String"
        }
    }
};
export const contentType1 = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
export const tableEntityProperties = {
    parameterPath: ["options", "tableEntityProperties"],
    mapper: {
        serializedName: "tableEntityProperties",
        xmlName: "tableEntityProperties",
        type: {
            name: "Dictionary",
            value: { type: { name: "any" } }
        }
    }
};
export const ifMatch = {
    parameterPath: ["options", "ifMatch"],
    mapper: {
        serializedName: "If-Match",
        xmlName: "If-Match",
        type: {
            name: "String"
        }
    }
};
export const ifMatch1 = {
    parameterPath: "ifMatch",
    mapper: {
        serializedName: "If-Match",
        required: true,
        xmlName: "If-Match",
        type: {
            name: "String"
        }
    }
};
export const accept2 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const comp = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "acl",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
export const contentType2 = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
export const tableAcl = {
    parameterPath: ["options", "tableAcl"],
    mapper: {
        serializedName: "tableAcl",
        xmlName: "SignedIdentifiers",
        xmlIsWrapped: true,
        xmlElementName: "SignedIdentifier",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Composite",
                    className: "SignedIdentifier"
                }
            }
        }
    }
};
export const accept3 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const tableServiceProperties = {
    parameterPath: "tableServiceProperties",
    mapper: TableServicePropertiesMapper
};
export const restype = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "service",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String"
        }
    }
};
export const comp1 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "properties",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
export const comp2 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "stats",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
//# sourceMappingURL=parameters.js.map