"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.transactionHeaderFilterPolicyName = exports.transactionRequestAssemblePolicyName = void 0;
exports.transactionRequestAssemblePolicy = transactionRequestAssemblePolicy;
exports.transactionHeaderFilterPolicy = transactionHeaderFilterPolicy;
const constants_js_1 = require("./utils/constants.js");
const core_rest_pipeline_1 = require("@azure/core-rest-pipeline");
const transactionHelpers_js_1 = require("./utils/transactionHelpers.js");
exports.transactionRequestAssemblePolicyName = "transactionRequestAssemblePolicy";
const dummyResponse = {
    request: (0, core_rest_pipeline_1.createPipelineRequest)({ url: "FAKE" }),
    status: 200,
    headers: (0, core_rest_pipeline_1.createHttpHeaders)(),
};
function transactionRequestAssemblePolicy(bodyParts, changesetId) {
    return {
        name: exports.transactionRequestAssemblePolicyName,
        async sendRequest(request) {
            const subRequest = getNextSubrequestBodyPart(request, changesetId);
            bodyParts.push(subRequest);
            // Intercept request from going to wire
            return dummyResponse;
        },
    };
}
exports.transactionHeaderFilterPolicyName = "transactionHeaderFilterPolicy";
function transactionHeaderFilterPolicy() {
    return {
        name: exports.transactionHeaderFilterPolicyName,
        async sendRequest(request, next) {
            // The subrequests should not have the x-ms-version header.
            request.headers.delete(constants_js_1.HeaderConstants.X_MS_VERSION);
            return next(request);
        },
    };
}
function getSubRequestUrl(url) {
    const sasTokenParts = ["sv", "ss", "srt", "sp", "se", "st", "spr", "sig"];
    const urlParsed = new URL(url);
    sasTokenParts.forEach((part) => urlParsed.searchParams.delete(part));
    return urlParsed.toString();
}
function getNextSubrequestBodyPart(request, changesetId) {
    const changesetBoundary = (0, transactionHelpers_js_1.getChangeSetBoundary)(changesetId);
    const subRequestPrefix = `--${changesetBoundary}${constants_js_1.TRANSACTION_HTTP_LINE_ENDING}${constants_js_1.HeaderConstants.CONTENT_TYPE}: application/http${constants_js_1.TRANSACTION_HTTP_LINE_ENDING}${constants_js_1.HeaderConstants.CONTENT_TRANSFER_ENCODING}: binary`;
    const subRequestUrl = getSubRequestUrl(request.url);
    // Start to assemble sub request
    const subRequest = [
        subRequestPrefix, // sub request constant prefix
        "", // empty line after sub request's content ID
        `${request.method.toString()} ${subRequestUrl} ${constants_js_1.TRANSACTION_HTTP_VERSION_1_1}`, // sub request start line with method,
    ];
    // Add required headers
    for (const [name, value] of request.headers) {
        subRequest.push(`${name}: ${value}`);
    }
    // Append sub-request body
    subRequest.push(`${constants_js_1.TRANSACTION_HTTP_LINE_ENDING}`); // sub request's headers need end with an empty line
    if (request.body) {
        subRequest.push(String(request.body));
    }
    // Add subrequest to transaction body
    return subRequest.join(constants_js_1.TRANSACTION_HTTP_LINE_ENDING);
}
//# sourceMappingURL=TablePolicies.js.map