"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.setTokenChallengeAuthenticationPolicy = setTokenChallengeAuthenticationPolicy;
const core_rest_pipeline_1 = require("@azure/core-rest-pipeline");
const core_client_1 = require("@azure/core-client");
/**
 * @internal
 * Setups the challenge authentication policy for the provided token credential.
 */
function setTokenChallengeAuthenticationPolicy(pipeline, credential, scopes) {
    // Make sure no bearerTokenPolicy is set.
    pipeline.removePolicy({ name: "bearerTokenPolicy" });
    pipeline.addPolicy((0, core_rest_pipeline_1.bearerTokenAuthenticationPolicy)({
        credential,
        scopes,
        challengeCallbacks: { authorizeRequestOnChallenge: core_client_1.authorizeRequestOnTenantChallenge },
    }), {
        phase: "Sign",
    });
}
//# sourceMappingURL=challengeAuthenticationUtils.js.map