"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTransactionHeaders = getTransactionHeaders;
const baseTransactionHeaders_js_1 = require("./baseTransactionHeaders.js");
/**
 * @internal
 * Builds an object with the required headers for a Transaction request. For Node
 */
function getTransactionHeaders(transactionGuid) {
    const baseHeaders = (0, baseTransactionHeaders_js_1.getBaseTransactionHeaders)(transactionGuid);
    return {
        ...baseHeaders,
        // The below headers are not supported in the browser as they are flagged as "unsafe headers"
        "Accept-Charset": "UTF-8",
        Connection: "Keep-Alive",
    };
}
//# sourceMappingURL=transactionHeaders.js.map