// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { bearerTokenAuthenticationPolicy } from "@azure/core-rest-pipeline";
import { authorizeRequestOnTenantChallenge } from "@azure/core-client";
/**
 * @internal
 * Setups the challenge authentication policy for the provided token credential.
 */
export function setTokenChallengeAuthenticationPolicy(pipeline, credential, scopes) {
    // Make sure no bearerTokenPolicy is set.
    pipeline.removePolicy({ name: "bearerTokenPolicy" });
    pipeline.addPolicy(bearerTokenAuthenticationPolicy({
        credential,
        scopes,
        challengeCallbacks: { authorizeRequestOnChallenge: authorizeRequestOnTenantChallenge },
    }), {
        phase: "Sign",
    });
}
//# sourceMappingURL=challengeAuthenticationUtils.js.map