"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.rangeToString = rangeToString;
/**
 * Generate a range string. For example:
 *
 * "bytes=255-" or "bytes=0-511"
 *
 * @param range - A range of byte positions.
 * @returns The string representation for the byte range.
 */
function rangeToString(range) {
    if (range.offset < 0) {
        throw new RangeError(`Range.offset cannot be smaller than 0.`);
    }
    if (range.count && range.count <= 0) {
        throw new RangeError(`Range.count must be larger than 0. Leave it undefined if you want a range from offset to the end.`);
    }
    return range.count
        ? `bytes=${range.offset}-${range.offset + range.count - 1}`
        : `bytes=${range.offset}-`;
}
//# sourceMappingURL=Range.js.map