import type { CopyStatusType, FileDownloadHeaders, FileDownloadResponseModel, LeaseDurationType, LeaseStateType, LeaseStatusType } from "./generatedModels.js";
import type { FilePosixProperties, Metadata } from "./models.js";
import type { ReadableStreamGetter, RetriableReadableStreamOptions } from "./utils/RetriableReadableStream.js";
import type { HttpResponse } from "./utils/utils.common.js";
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * FileDownloadResponse implements the `FileDownloadResponseModel` interface, and in a Node.js runtime it will
 * automatically retry when its internal read stream unexpectedly ends. (This kind of unexpected end cannot
 * trigger retries defined in the pipeline retry policy.)
 *
 * The {@link readableStreamBody} stream will retry beneath the `ReadableStream` layer, so you can just use it as
 * a normal Node.js Readable stream.
 */
export declare class FileDownloadResponse implements FileDownloadResponseModel {
    /**
     * Indicates that the service supports
     * requests for partial file content.
     *
     * @readonly
     */
    get acceptRanges(): string | undefined;
    /**
     * Returnes if it was previously specified
     * for the file.
     *
     * @readonly
     */
    get cacheControl(): string | undefined;
    /**
     * Returns the value that was specified
     * for the 'x-ms-content-disposition' header and specifies how to process the
     * response.
     *
     * @readonly
     */
    get contentDisposition(): string | undefined;
    /**
     * Returns the value that was specified
     * for the Content-Encoding request header.
     *
     * @readonly
     */
    get contentEncoding(): string | undefined;
    /**
     * Returns the value that was specified
     * for the Content-Language request header.
     *
     * @readonly
     */
    get contentLanguage(): string | undefined;
    /**
     * The number of bytes present in the
     * response body.
     *
     * @readonly
     */
    get contentLength(): number | undefined;
    /**
     * If the file has an MD5 hash and the
     * request is to read the full file, this response header is returned so that
     * the client can check for message content integrity. If the request is to
     * read a specified range and the 'x-ms-range-get-content-md5' is set to
     * true, then the request returns an MD5 hash for the range, as long as the
     * range size is less than or equal to 4 MB. If neither of these sets of
     * conditions is true, then no value is returned for the 'Content-MD5'
     * header.
     *
     * @readonly
     */
    get contentMD5(): Uint8Array | undefined;
    /**
     * Indicates the range of bytes returned if
     * the client requested a subset of the file by setting the Range request
     * header.
     *
     * @readonly
     */
    get contentRange(): string | undefined;
    /**
     * The content type specified for the file.
     * The default content type is 'application/octet-stream'
     *
     * @readonly
     */
    get contentType(): string | undefined;
    /**
     * Conclusion time of the last attempted
     * Copy File operation where this file was the destination file. This value
     * can specify the time of a completed, aborted, or failed copy attempt.
     *
     * @readonly
     */
    get copyCompletedOn(): Date | undefined;
    /**
     * String identifier for the last attempted Copy
     * File operation where this file was the destination file.
     *
     * @readonly
     */
    get copyId(): string | undefined;
    /**
     * Contains the number of bytes copied and
     * the total bytes in the source in the last attempted Copy File operation
     * where this file was the destination file. Can show between 0 and
     * Content-Length bytes copied.
     *
     * @readonly
     */
    get copyProgress(): string | undefined;
    /**
     * URL up to 2KB in length that specifies the
     * source file used in the last attempted Copy File operation where this file
     * was the destination file.
     *
     * @readonly
     */
    get copySource(): string | undefined;
    /**
     * State of the copy operation
     * identified by 'x-ms-copy-id'. Possible values include: 'pending',
     * 'success', 'aborted', 'failed'
     *
     * @readonly
     */
    get copyStatus(): CopyStatusType | undefined;
    /**
     * Only appears when
     * x-ms-copy-status is failed or pending. Describes cause of fatal or
     * non-fatal copy operation failure.
     *
     * @readonly
     */
    get copyStatusDescription(): string | undefined;
    /**
     * A UTC date/time value generated by the service that
     * indicates the time at which the response was initiated.
     *
     * @readonly
     */
    get date(): Date | undefined;
    /**
     * The ETag contains a value that you can use to
     * perform operations conditionally, in quotes.
     *
     * @readonly
     */
    get etag(): string | undefined;
    get errorCode(): string | undefined;
    /**
     * If the file has a MD5 hash, and if
     * request contains range header (Range or x-ms-range), this response header
     * is returned with the value of the whole file's MD5 value. This value may
     * or may not be equal to the value returned in Content-MD5 header, with the
     * latter calculated from the requested range.
     *
     * @readonly
     */
    get fileContentMD5(): Uint8Array | undefined;
    /**
     * The value of this header is set to
     * true if the file data and application metadata are completely encrypted
     * using the specified algorithm. Otherwise, the value is set to false (when
     * the file is unencrypted, or if only parts of the file/application metadata
     * are encrypted).
     *
     * @readonly
     */
    get isServerEncrypted(): boolean | undefined;
    /**
     * Returns the date and time the file was last
     * modified. Any operation that modifies the file or its properties updates
     * the last modified time.
     *
     * @readonly
     */
    get lastModified(): Date | undefined;
    /**
     * A name-value pair
     * to associate with a file storage object.
     *
     * @readonly
     */
    get metadata(): Metadata | undefined;
    /**
     * This header uniquely identifies the request
     * that was made and can be used for troubleshooting the request.
     *
     * @readonly
     */
    get requestId(): string | undefined;
    /**
     * Indicates the version of the File service used
     * to execute the request.
     *
     * @readonly
     */
    get version(): string | undefined;
    /**
     * Attributes set for the file.
     *
     * @readonly
     */
    get fileAttributes(): string | undefined;
    /**
     * Creation time for the file.
     *
     * @readonly
     */
    get fileCreatedOn(): Date | undefined;
    /**
     * Last write time for the file.
     *
     * @readonly
     */
    get fileLastWriteOn(): Date | undefined;
    /**
     * Change time for the file.
     *
     * @readonly
     */
    get fileChangeOn(): Date | undefined;
    /**
     * Key of the permission set for the file.
     *
     * @readonly
     */
    get filePermissionKey(): string | undefined;
    /**
     * The fileId of the file.
     *
     * @readonly
     */
    get fileId(): string | undefined;
    /**
     * The parent fileId of the file.
     *
     * @readonly
     */
    get fileParentId(): string | undefined;
    /**
     * The response body as a browser Blob.
     * Always undefined in node.js.
     *
     * @readonly
     */
    get contentAsBlob(): Promise<Blob> | undefined;
    /**
     * When a file is leased, specifies whether the lease is of infinite or fixed duration. Possible
     * values include: 'infinite', 'fixed'
     */
    get leaseDuration(): LeaseDurationType | undefined;
    /**
     * Lease state of the file. Possible values include: 'available', 'leased', 'expired',
     * 'breaking', 'broken'
     */
    get leaseState(): LeaseStateType | undefined;
    /**
     * The current lease status of the file. Possible values include: 'locked', 'unlocked'
     */
    get leaseStatus(): LeaseStatusType | undefined;
    /**
     * Properties of NFS files
     */
    get posixProperties(): FilePosixProperties | undefined;
    /**
     * The response body as a node.js Readable stream.
     * Always undefined in the browser.
     *
     * It will automatically retry when internal read stream unexpected ends.
     *
     * @readonly
     */
    get readableStreamBody(): NodeJS.ReadableStream | undefined;
    get _response(): HttpResponse & {
        parsedHeaders: FileDownloadHeaders;
    };
    private originalResponse;
    private fileDownloadStream?;
    /**
     * Creates an instance of FileDownloadResponse.
     *
     * @param originalResponse -
     * @param getter -
     * @param offset -
     * @param count -
     * @param options -
     */
    constructor(originalResponse: FileDownloadResponseModel, getter: ReadableStreamGetter, offset: number, count: number, options?: RetriableReadableStreamOptions);
}
//# sourceMappingURL=FileDownloadResponse.d.ts.map