// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { StorageContextClient } from "./StorageContextClient.js";
import { getCoreClientOptions, getCredentialFromPipeline } from "./Pipeline.js";
import { escapeURLPath, getAccountNameFromUrl } from "./utils/utils.common.js";
/**
 * A StorageClient represents a base client class for ServiceClient, ContainerClient and etc.
 */
export class StorageClient {
    /**
     * URL string value.
     */
    url;
    accountName;
    /**
     * Request policy pipeline.
     *
     * @internal
     */
    pipeline;
    /**
     * Credential in the pipeline to authenticate requests to the service, such as AnonymousCredential, StorageSharedKeyCredential.
     * Initialized to an AnonymousCredential if not able to retrieve it from the pipeline.
     *
     * @internal
     */
    credential;
    /**
     * StorageClient is a reference to protocol layer operations entry, which is
     * generated by AutoRest generator.
     */
    storageClientContext;
    /**
     * Creates an instance of StorageClient.
     * @param url -
     * @param pipeline -
     */
    constructor(url, pipeline) {
        // URL should be encoded and only once, protocol layer shouldn't encode URL again
        this.url = escapeURLPath(url);
        this.accountName = getAccountNameFromUrl(url);
        this.pipeline = pipeline;
        this.storageClientContext = new StorageContextClient(this.url, getCoreClientOptions(pipeline));
        // Remove the default content-type in generated code of StorageClientContext
        const storageClientContext = this.storageClientContext;
        if (storageClientContext.requestContentType) {
            storageClientContext.requestContentType = undefined;
        }
        const credential = getCredentialFromPipeline(pipeline);
        this.credential = credential;
    }
}
//# sourceMappingURL=StorageClient.js.map