// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { StorageClient } from "./generated/src/index.js";
/**
 * @internal
 */
export class StorageContextClient extends StorageClient {
    async sendOperationRequest(operationArguments, operationSpec) {
        const operationSpecToSend = { ...operationSpec };
        if (operationSpecToSend.path === "/{shareName}" ||
            operationSpecToSend.path === "/{shareName}/{directory}" ||
            operationSpecToSend.path === "/{shareName}/{directory}/{fileName}") {
            operationSpecToSend.path = "";
        }
        return super.sendOperationRequest(operationArguments, operationSpecToSend);
    }
}
//# sourceMappingURL=StorageContextClient.js.map