/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
export const FileServiceProperties = {
    serializedName: "FileServiceProperties",
    xmlName: "StorageServiceProperties",
    type: {
        name: "Composite",
        className: "FileServiceProperties",
        modelProperties: {
            hourMetrics: {
                serializedName: "HourMetrics",
                xmlName: "HourMetrics",
                type: {
                    name: "Composite",
                    className: "Metrics",
                },
            },
            minuteMetrics: {
                serializedName: "MinuteMetrics",
                xmlName: "MinuteMetrics",
                type: {
                    name: "Composite",
                    className: "Metrics",
                },
            },
            cors: {
                serializedName: "Cors",
                xmlName: "Cors",
                xmlIsWrapped: true,
                xmlElementName: "CorsRule",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "CorsRule",
                        },
                    },
                },
            },
            protocol: {
                serializedName: "Protocol",
                xmlName: "ProtocolSettings",
                type: {
                    name: "Composite",
                    className: "ShareProtocolSettings",
                },
            },
        },
    },
};
export const Metrics = {
    serializedName: "Metrics",
    type: {
        name: "Composite",
        className: "Metrics",
        modelProperties: {
            version: {
                serializedName: "Version",
                required: true,
                xmlName: "Version",
                type: {
                    name: "String",
                },
            },
            enabled: {
                serializedName: "Enabled",
                required: true,
                xmlName: "Enabled",
                type: {
                    name: "Boolean",
                },
            },
            includeAPIs: {
                serializedName: "IncludeAPIs",
                xmlName: "IncludeAPIs",
                type: {
                    name: "Boolean",
                },
            },
            retentionPolicy: {
                serializedName: "RetentionPolicy",
                xmlName: "RetentionPolicy",
                type: {
                    name: "Composite",
                    className: "RetentionPolicy",
                },
            },
        },
    },
};
export const RetentionPolicy = {
    serializedName: "RetentionPolicy",
    type: {
        name: "Composite",
        className: "RetentionPolicy",
        modelProperties: {
            enabled: {
                serializedName: "Enabled",
                required: true,
                xmlName: "Enabled",
                type: {
                    name: "Boolean",
                },
            },
            days: {
                constraints: {
                    InclusiveMaximum: 365,
                    InclusiveMinimum: 1,
                },
                serializedName: "Days",
                xmlName: "Days",
                type: {
                    name: "Number",
                },
            },
        },
    },
};
export const CorsRule = {
    serializedName: "CorsRule",
    type: {
        name: "Composite",
        className: "CorsRule",
        modelProperties: {
            allowedOrigins: {
                serializedName: "AllowedOrigins",
                required: true,
                xmlName: "AllowedOrigins",
                type: {
                    name: "String",
                },
            },
            allowedMethods: {
                serializedName: "AllowedMethods",
                required: true,
                xmlName: "AllowedMethods",
                type: {
                    name: "String",
                },
            },
            allowedHeaders: {
                serializedName: "AllowedHeaders",
                required: true,
                xmlName: "AllowedHeaders",
                type: {
                    name: "String",
                },
            },
            exposedHeaders: {
                serializedName: "ExposedHeaders",
                required: true,
                xmlName: "ExposedHeaders",
                type: {
                    name: "String",
                },
            },
            maxAgeInSeconds: {
                constraints: {
                    InclusiveMinimum: 0,
                },
                serializedName: "MaxAgeInSeconds",
                required: true,
                xmlName: "MaxAgeInSeconds",
                type: {
                    name: "Number",
                },
            },
        },
    },
};
export const ShareProtocolSettings = {
    serializedName: "ShareProtocolSettings",
    xmlName: "ProtocolSettings",
    type: {
        name: "Composite",
        className: "ShareProtocolSettings",
        modelProperties: {
            smb: {
                serializedName: "Smb",
                xmlName: "SMB",
                type: {
                    name: "Composite",
                    className: "ShareSmbSettings",
                },
            },
        },
    },
};
export const ShareSmbSettings = {
    serializedName: "ShareSmbSettings",
    xmlName: "SMB",
    type: {
        name: "Composite",
        className: "ShareSmbSettings",
        modelProperties: {
            multichannel: {
                serializedName: "Multichannel",
                xmlName: "Multichannel",
                type: {
                    name: "Composite",
                    className: "SmbMultichannel",
                },
            },
        },
    },
};
export const SmbMultichannel = {
    serializedName: "SmbMultichannel",
    xmlName: "Multichannel",
    type: {
        name: "Composite",
        className: "SmbMultichannel",
        modelProperties: {
            enabled: {
                serializedName: "Enabled",
                xmlName: "Enabled",
                type: {
                    name: "Boolean",
                },
            },
        },
    },
};
export const StorageError = {
    serializedName: "StorageError",
    type: {
        name: "Composite",
        className: "StorageError",
        modelProperties: {
            message: {
                serializedName: "Message",
                xmlName: "Message",
                type: {
                    name: "String",
                },
            },
            copySourceStatusCode: {
                serializedName: "CopySourceStatusCode",
                xmlName: "CopySourceStatusCode",
                type: {
                    name: "Number",
                },
            },
            copySourceErrorCode: {
                serializedName: "CopySourceErrorCode",
                xmlName: "CopySourceErrorCode",
                type: {
                    name: "String",
                },
            },
            copySourceErrorMessage: {
                serializedName: "CopySourceErrorMessage",
                xmlName: "CopySourceErrorMessage",
                type: {
                    name: "String",
                },
            },
            authenticationErrorDetail: {
                serializedName: "AuthenticationErrorDetail",
                xmlName: "AuthenticationErrorDetail",
                type: {
                    name: "String",
                },
            },
            code: {
                serializedName: "Code",
                xmlName: "Code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ListSharesResponse = {
    serializedName: "ListSharesResponse",
    xmlName: "EnumerationResults",
    type: {
        name: "Composite",
        className: "ListSharesResponse",
        modelProperties: {
            serviceEndpoint: {
                serializedName: "ServiceEndpoint",
                required: true,
                xmlName: "ServiceEndpoint",
                xmlIsAttribute: true,
                type: {
                    name: "String",
                },
            },
            prefix: {
                serializedName: "Prefix",
                xmlName: "Prefix",
                type: {
                    name: "String",
                },
            },
            marker: {
                serializedName: "Marker",
                xmlName: "Marker",
                type: {
                    name: "String",
                },
            },
            maxResults: {
                serializedName: "MaxResults",
                xmlName: "MaxResults",
                type: {
                    name: "Number",
                },
            },
            shareItems: {
                serializedName: "ShareItems",
                xmlName: "Shares",
                xmlIsWrapped: true,
                xmlElementName: "Share",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "ShareItemInternal",
                        },
                    },
                },
            },
            continuationToken: {
                serializedName: "NextMarker",
                required: true,
                xmlName: "NextMarker",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareItemInternal = {
    serializedName: "ShareItemInternal",
    xmlName: "Share",
    type: {
        name: "Composite",
        className: "ShareItemInternal",
        modelProperties: {
            name: {
                serializedName: "Name",
                required: true,
                xmlName: "Name",
                type: {
                    name: "String",
                },
            },
            snapshot: {
                serializedName: "Snapshot",
                xmlName: "Snapshot",
                type: {
                    name: "String",
                },
            },
            deleted: {
                serializedName: "Deleted",
                xmlName: "Deleted",
                type: {
                    name: "Boolean",
                },
            },
            version: {
                serializedName: "Version",
                xmlName: "Version",
                type: {
                    name: "String",
                },
            },
            properties: {
                serializedName: "Properties",
                xmlName: "Properties",
                type: {
                    name: "Composite",
                    className: "SharePropertiesInternal",
                },
            },
            metadata: {
                serializedName: "Metadata",
                xmlName: "Metadata",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } },
                },
            },
        },
    },
};
export const SharePropertiesInternal = {
    serializedName: "SharePropertiesInternal",
    type: {
        name: "Composite",
        className: "SharePropertiesInternal",
        modelProperties: {
            lastModified: {
                serializedName: "Last-Modified",
                required: true,
                xmlName: "Last-Modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            etag: {
                serializedName: "Etag",
                required: true,
                xmlName: "Etag",
                type: {
                    name: "String",
                },
            },
            quota: {
                serializedName: "Quota",
                required: true,
                xmlName: "Quota",
                type: {
                    name: "Number",
                },
            },
            provisionedIops: {
                serializedName: "ProvisionedIops",
                xmlName: "ProvisionedIops",
                type: {
                    name: "Number",
                },
            },
            provisionedIngressMBps: {
                serializedName: "ProvisionedIngressMBps",
                xmlName: "ProvisionedIngressMBps",
                type: {
                    name: "Number",
                },
            },
            provisionedEgressMBps: {
                serializedName: "ProvisionedEgressMBps",
                xmlName: "ProvisionedEgressMBps",
                type: {
                    name: "Number",
                },
            },
            provisionedBandwidthMiBps: {
                serializedName: "ProvisionedBandwidthMiBps",
                xmlName: "ProvisionedBandwidthMiBps",
                type: {
                    name: "Number",
                },
            },
            nextAllowedQuotaDowngradeTime: {
                serializedName: "NextAllowedQuotaDowngradeTime",
                xmlName: "NextAllowedQuotaDowngradeTime",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            deletedTime: {
                serializedName: "DeletedTime",
                xmlName: "DeletedTime",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            remainingRetentionDays: {
                serializedName: "RemainingRetentionDays",
                xmlName: "RemainingRetentionDays",
                type: {
                    name: "Number",
                },
            },
            accessTier: {
                serializedName: "AccessTier",
                xmlName: "AccessTier",
                type: {
                    name: "String",
                },
            },
            accessTierChangeTime: {
                serializedName: "AccessTierChangeTime",
                xmlName: "AccessTierChangeTime",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            accessTierTransitionState: {
                serializedName: "AccessTierTransitionState",
                xmlName: "AccessTierTransitionState",
                type: {
                    name: "String",
                },
            },
            leaseStatus: {
                serializedName: "LeaseStatus",
                xmlName: "LeaseStatus",
                type: {
                    name: "Enum",
                    allowedValues: ["locked", "unlocked"],
                },
            },
            leaseState: {
                serializedName: "LeaseState",
                xmlName: "LeaseState",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "available",
                        "leased",
                        "expired",
                        "breaking",
                        "broken",
                    ],
                },
            },
            leaseDuration: {
                serializedName: "LeaseDuration",
                xmlName: "LeaseDuration",
                type: {
                    name: "Enum",
                    allowedValues: ["infinite", "fixed"],
                },
            },
            enabledProtocols: {
                serializedName: "EnabledProtocols",
                xmlName: "EnabledProtocols",
                type: {
                    name: "String",
                },
            },
            rootSquash: {
                serializedName: "RootSquash",
                xmlName: "RootSquash",
                type: {
                    name: "Enum",
                    allowedValues: ["NoRootSquash", "RootSquash", "AllSquash"],
                },
            },
            enableSnapshotVirtualDirectoryAccess: {
                serializedName: "EnableSnapshotVirtualDirectoryAccess",
                xmlName: "EnableSnapshotVirtualDirectoryAccess",
                type: {
                    name: "Boolean",
                },
            },
            paidBurstingEnabled: {
                serializedName: "PaidBurstingEnabled",
                xmlName: "PaidBurstingEnabled",
                type: {
                    name: "Boolean",
                },
            },
            paidBurstingMaxIops: {
                serializedName: "PaidBurstingMaxIops",
                xmlName: "PaidBurstingMaxIops",
                type: {
                    name: "Number",
                },
            },
            paidBurstingMaxBandwidthMibps: {
                serializedName: "PaidBurstingMaxBandwidthMibps",
                xmlName: "PaidBurstingMaxBandwidthMibps",
                type: {
                    name: "Number",
                },
            },
            includedBurstIops: {
                serializedName: "IncludedBurstIops",
                xmlName: "IncludedBurstIops",
                type: {
                    name: "Number",
                },
            },
            maxBurstCreditsForIops: {
                serializedName: "MaxBurstCreditsForIops",
                xmlName: "MaxBurstCreditsForIops",
                type: {
                    name: "Number",
                },
            },
            nextAllowedProvisionedIopsDowngradeTime: {
                serializedName: "NextAllowedProvisionedIopsDowngradeTime",
                xmlName: "NextAllowedProvisionedIopsDowngradeTime",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            nextAllowedProvisionedBandwidthDowngradeTime: {
                serializedName: "NextAllowedProvisionedBandwidthDowngradeTime",
                xmlName: "NextAllowedProvisionedBandwidthDowngradeTime",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
        },
    },
};
export const SharePermission = {
    serializedName: "SharePermission",
    type: {
        name: "Composite",
        className: "SharePermission",
        modelProperties: {
            permission: {
                serializedName: "permission",
                required: true,
                xmlName: "permission",
                type: {
                    name: "String",
                },
            },
            format: {
                serializedName: "format",
                xmlName: "format",
                type: {
                    name: "Enum",
                    allowedValues: ["Sddl", "Binary"],
                },
            },
        },
    },
};
export const SignedIdentifier = {
    serializedName: "SignedIdentifier",
    type: {
        name: "Composite",
        className: "SignedIdentifier",
        modelProperties: {
            id: {
                serializedName: "Id",
                required: true,
                xmlName: "Id",
                type: {
                    name: "String",
                },
            },
            accessPolicy: {
                serializedName: "AccessPolicy",
                xmlName: "AccessPolicy",
                type: {
                    name: "Composite",
                    className: "AccessPolicy",
                },
            },
        },
    },
};
export const AccessPolicy = {
    serializedName: "AccessPolicy",
    type: {
        name: "Composite",
        className: "AccessPolicy",
        modelProperties: {
            startsOn: {
                serializedName: "Start",
                xmlName: "Start",
                type: {
                    name: "String",
                },
            },
            expiresOn: {
                serializedName: "Expiry",
                xmlName: "Expiry",
                type: {
                    name: "String",
                },
            },
            permissions: {
                serializedName: "Permission",
                xmlName: "Permission",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareStats = {
    serializedName: "ShareStats",
    type: {
        name: "Composite",
        className: "ShareStats",
        modelProperties: {
            shareUsageBytes: {
                serializedName: "ShareUsageBytes",
                required: true,
                xmlName: "ShareUsageBytes",
                type: {
                    name: "Number",
                },
            },
        },
    },
};
export const ListFilesAndDirectoriesSegmentResponse = {
    serializedName: "ListFilesAndDirectoriesSegmentResponse",
    xmlName: "EnumerationResults",
    type: {
        name: "Composite",
        className: "ListFilesAndDirectoriesSegmentResponse",
        modelProperties: {
            serviceEndpoint: {
                serializedName: "ServiceEndpoint",
                required: true,
                xmlName: "ServiceEndpoint",
                xmlIsAttribute: true,
                type: {
                    name: "String",
                },
            },
            shareName: {
                serializedName: "ShareName",
                required: true,
                xmlName: "ShareName",
                xmlIsAttribute: true,
                type: {
                    name: "String",
                },
            },
            shareSnapshot: {
                serializedName: "ShareSnapshot",
                xmlName: "ShareSnapshot",
                xmlIsAttribute: true,
                type: {
                    name: "String",
                },
            },
            encoded: {
                serializedName: "Encoded",
                xmlName: "Encoded",
                xmlIsAttribute: true,
                type: {
                    name: "Boolean",
                },
            },
            directoryPath: {
                serializedName: "DirectoryPath",
                required: true,
                xmlName: "DirectoryPath",
                xmlIsAttribute: true,
                type: {
                    name: "String",
                },
            },
            prefix: {
                serializedName: "Prefix",
                xmlName: "Prefix",
                type: {
                    name: "Composite",
                    className: "StringEncoded",
                },
            },
            marker: {
                serializedName: "Marker",
                xmlName: "Marker",
                type: {
                    name: "String",
                },
            },
            maxResults: {
                serializedName: "MaxResults",
                xmlName: "MaxResults",
                type: {
                    name: "Number",
                },
            },
            segment: {
                serializedName: "Segment",
                xmlName: "Entries",
                type: {
                    name: "Composite",
                    className: "FilesAndDirectoriesListSegment",
                },
            },
            continuationToken: {
                serializedName: "NextMarker",
                required: true,
                xmlName: "NextMarker",
                type: {
                    name: "String",
                },
            },
            directoryId: {
                serializedName: "DirectoryId",
                xmlName: "DirectoryId",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const StringEncoded = {
    serializedName: "StringEncoded",
    type: {
        name: "Composite",
        className: "StringEncoded",
        modelProperties: {
            encoded: {
                serializedName: "Encoded",
                xmlName: "Encoded",
                xmlIsAttribute: true,
                type: {
                    name: "Boolean",
                },
            },
            content: {
                serializedName: "content",
                xmlName: "content",
                xmlIsMsText: true,
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FilesAndDirectoriesListSegment = {
    serializedName: "FilesAndDirectoriesListSegment",
    xmlName: "Entries",
    type: {
        name: "Composite",
        className: "FilesAndDirectoriesListSegment",
        modelProperties: {
            directoryItems: {
                serializedName: "DirectoryItems",
                required: true,
                xmlName: "DirectoryItems",
                xmlElementName: "Directory",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "DirectoryItem",
                        },
                    },
                },
            },
            fileItems: {
                serializedName: "FileItems",
                required: true,
                xmlName: "FileItems",
                xmlElementName: "File",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "FileItem",
                        },
                    },
                },
            },
        },
    },
};
export const DirectoryItem = {
    serializedName: "DirectoryItem",
    xmlName: "Directory",
    type: {
        name: "Composite",
        className: "DirectoryItem",
        modelProperties: {
            name: {
                serializedName: "Name",
                xmlName: "Name",
                type: {
                    name: "Composite",
                    className: "StringEncoded",
                },
            },
            fileId: {
                serializedName: "FileId",
                xmlName: "FileId",
                type: {
                    name: "String",
                },
            },
            properties: {
                serializedName: "Properties",
                xmlName: "Properties",
                type: {
                    name: "Composite",
                    className: "FileProperty",
                },
            },
            attributes: {
                serializedName: "Attributes",
                xmlName: "Attributes",
                type: {
                    name: "String",
                },
            },
            permissionKey: {
                serializedName: "PermissionKey",
                xmlName: "PermissionKey",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileProperty = {
    serializedName: "FileProperty",
    type: {
        name: "Composite",
        className: "FileProperty",
        modelProperties: {
            contentLength: {
                serializedName: "Content-Length",
                required: true,
                xmlName: "Content-Length",
                type: {
                    name: "Number",
                },
            },
            creationTime: {
                serializedName: "CreationTime",
                xmlName: "CreationTime",
                type: {
                    name: "DateTime",
                },
            },
            lastAccessTime: {
                serializedName: "LastAccessTime",
                xmlName: "LastAccessTime",
                type: {
                    name: "DateTime",
                },
            },
            lastWriteTime: {
                serializedName: "LastWriteTime",
                xmlName: "LastWriteTime",
                type: {
                    name: "DateTime",
                },
            },
            changeTime: {
                serializedName: "ChangeTime",
                xmlName: "ChangeTime",
                type: {
                    name: "DateTime",
                },
            },
            lastModified: {
                serializedName: "Last-Modified",
                xmlName: "Last-Modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            etag: {
                serializedName: "Etag",
                xmlName: "Etag",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileItem = {
    serializedName: "FileItem",
    xmlName: "File",
    type: {
        name: "Composite",
        className: "FileItem",
        modelProperties: {
            name: {
                serializedName: "Name",
                xmlName: "Name",
                type: {
                    name: "Composite",
                    className: "StringEncoded",
                },
            },
            fileId: {
                serializedName: "FileId",
                xmlName: "FileId",
                type: {
                    name: "String",
                },
            },
            properties: {
                serializedName: "Properties",
                xmlName: "Properties",
                type: {
                    name: "Composite",
                    className: "FileProperty",
                },
            },
            attributes: {
                serializedName: "Attributes",
                xmlName: "Attributes",
                type: {
                    name: "String",
                },
            },
            permissionKey: {
                serializedName: "PermissionKey",
                xmlName: "PermissionKey",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ListHandlesResponse = {
    serializedName: "ListHandlesResponse",
    xmlName: "EnumerationResults",
    type: {
        name: "Composite",
        className: "ListHandlesResponse",
        modelProperties: {
            handleList: {
                serializedName: "HandleList",
                xmlName: "Entries",
                xmlIsWrapped: true,
                xmlElementName: "Handle",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "HandleItem",
                        },
                    },
                },
            },
            continuationToken: {
                serializedName: "NextMarker",
                required: true,
                xmlName: "NextMarker",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const HandleItem = {
    serializedName: "HandleItem",
    xmlName: "Handle",
    type: {
        name: "Composite",
        className: "HandleItem",
        modelProperties: {
            handleId: {
                serializedName: "HandleId",
                required: true,
                xmlName: "HandleId",
                type: {
                    name: "String",
                },
            },
            path: {
                serializedName: "Path",
                xmlName: "Path",
                type: {
                    name: "Composite",
                    className: "StringEncoded",
                },
            },
            fileId: {
                serializedName: "FileId",
                required: true,
                xmlName: "FileId",
                type: {
                    name: "String",
                },
            },
            parentId: {
                serializedName: "ParentId",
                xmlName: "ParentId",
                type: {
                    name: "String",
                },
            },
            sessionId: {
                serializedName: "SessionId",
                required: true,
                xmlName: "SessionId",
                type: {
                    name: "String",
                },
            },
            clientIp: {
                serializedName: "ClientIp",
                required: true,
                xmlName: "ClientIp",
                type: {
                    name: "String",
                },
            },
            clientName: {
                serializedName: "ClientName",
                required: true,
                xmlName: "ClientName",
                type: {
                    name: "String",
                },
            },
            openTime: {
                serializedName: "OpenTime",
                required: true,
                xmlName: "OpenTime",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            lastReconnectTime: {
                serializedName: "LastReconnectTime",
                xmlName: "LastReconnectTime",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            accessRightList: {
                serializedName: "AccessRightList",
                xmlName: "AccessRightList",
                xmlIsWrapped: true,
                xmlElementName: "AccessRight",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Enum",
                            allowedValues: ["Read", "Write", "Delete"],
                        },
                    },
                },
            },
        },
    },
};
export const ShareFileRangeList = {
    serializedName: "ShareFileRangeList",
    type: {
        name: "Composite",
        className: "ShareFileRangeList",
        modelProperties: {
            ranges: {
                serializedName: "Ranges",
                xmlName: "Ranges",
                xmlElementName: "Range",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "FileRange",
                        },
                    },
                },
            },
            clearRanges: {
                serializedName: "ClearRanges",
                xmlName: "ClearRanges",
                xmlElementName: "ClearRange",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "ClearRange",
                        },
                    },
                },
            },
        },
    },
};
export const FileRange = {
    serializedName: "FileRange",
    xmlName: "Range",
    type: {
        name: "Composite",
        className: "FileRange",
        modelProperties: {
            start: {
                serializedName: "Start",
                required: true,
                xmlName: "Start",
                type: {
                    name: "Number",
                },
            },
            end: {
                serializedName: "End",
                required: true,
                xmlName: "End",
                type: {
                    name: "Number",
                },
            },
        },
    },
};
export const ClearRange = {
    serializedName: "ClearRange",
    xmlName: "ClearRange",
    type: {
        name: "Composite",
        className: "ClearRange",
        modelProperties: {
            start: {
                serializedName: "Start",
                required: true,
                xmlName: "Start",
                type: {
                    name: "Number",
                },
            },
            end: {
                serializedName: "End",
                required: true,
                xmlName: "End",
                type: {
                    name: "Number",
                },
            },
        },
    },
};
export const ServiceSetPropertiesHeaders = {
    serializedName: "Service_setPropertiesHeaders",
    type: {
        name: "Composite",
        className: "ServiceSetPropertiesHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ServiceSetPropertiesExceptionHeaders = {
    serializedName: "Service_setPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceSetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ServiceGetPropertiesHeaders = {
    serializedName: "Service_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetPropertiesHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ServiceGetPropertiesExceptionHeaders = {
    serializedName: "Service_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ServiceListSharesSegmentHeaders = {
    serializedName: "Service_listSharesSegmentHeaders",
    type: {
        name: "Composite",
        className: "ServiceListSharesSegmentHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ServiceListSharesSegmentExceptionHeaders = {
    serializedName: "Service_listSharesSegmentExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceListSharesSegmentExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareCreateHeaders = {
    serializedName: "Share_createHeaders",
    type: {
        name: "Composite",
        className: "ShareCreateHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            quota: {
                serializedName: "x-ms-share-quota",
                xmlName: "x-ms-share-quota",
                type: {
                    name: "Number",
                },
            },
            shareProvisionedIops: {
                serializedName: "x-ms-share-provisioned-iops",
                xmlName: "x-ms-share-provisioned-iops",
                type: {
                    name: "Number",
                },
            },
            shareProvisionedBandwidthMibps: {
                serializedName: "x-ms-share-provisioned-bandwidth-mibps",
                xmlName: "x-ms-share-provisioned-bandwidth-mibps",
                type: {
                    name: "Number",
                },
            },
            shareIncludedBurstIops: {
                serializedName: "x-ms-share-included-burst-iops",
                xmlName: "x-ms-share-included-burst-iops",
                type: {
                    name: "Number",
                },
            },
            maxBurstCreditsForIops: {
                serializedName: "x-ms-share-max-burst-credits-for-iops",
                xmlName: "x-ms-share-max-burst-credits-for-iops",
                type: {
                    name: "Number",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareCreateExceptionHeaders = {
    serializedName: "Share_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareGetPropertiesHeaders = {
    serializedName: "Share_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "ShareGetPropertiesHeaders",
        modelProperties: {
            metadata: {
                serializedName: "x-ms-meta",
                headerCollectionPrefix: "x-ms-meta-",
                xmlName: "x-ms-meta",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } },
                },
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            quota: {
                serializedName: "x-ms-share-quota",
                xmlName: "x-ms-share-quota",
                type: {
                    name: "Number",
                },
            },
            provisionedIops: {
                serializedName: "x-ms-share-provisioned-iops",
                xmlName: "x-ms-share-provisioned-iops",
                type: {
                    name: "Number",
                },
            },
            provisionedIngressMBps: {
                serializedName: "x-ms-share-provisioned-ingress-mbps",
                xmlName: "x-ms-share-provisioned-ingress-mbps",
                type: {
                    name: "Number",
                },
            },
            provisionedEgressMBps: {
                serializedName: "x-ms-share-provisioned-egress-mbps",
                xmlName: "x-ms-share-provisioned-egress-mbps",
                type: {
                    name: "Number",
                },
            },
            nextAllowedQuotaDowngradeTime: {
                serializedName: "x-ms-share-next-allowed-quota-downgrade-time",
                xmlName: "x-ms-share-next-allowed-quota-downgrade-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            provisionedBandwidthMibps: {
                serializedName: "x-ms-share-provisioned-bandwidth-mibps",
                xmlName: "x-ms-share-provisioned-bandwidth-mibps",
                type: {
                    name: "Number",
                },
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "Enum",
                    allowedValues: ["infinite", "fixed"],
                },
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "available",
                        "leased",
                        "expired",
                        "breaking",
                        "broken",
                    ],
                },
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "Enum",
                    allowedValues: ["locked", "unlocked"],
                },
            },
            accessTier: {
                serializedName: "x-ms-access-tier",
                xmlName: "x-ms-access-tier",
                type: {
                    name: "String",
                },
            },
            accessTierChangeTime: {
                serializedName: "x-ms-access-tier-change-time",
                xmlName: "x-ms-access-tier-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            accessTierTransitionState: {
                serializedName: "x-ms-access-tier-transition-state",
                xmlName: "x-ms-access-tier-transition-state",
                type: {
                    name: "String",
                },
            },
            enabledProtocols: {
                serializedName: "x-ms-enabled-protocols",
                xmlName: "x-ms-enabled-protocols",
                type: {
                    name: "String",
                },
            },
            rootSquash: {
                serializedName: "x-ms-root-squash",
                xmlName: "x-ms-root-squash",
                type: {
                    name: "Enum",
                    allowedValues: ["NoRootSquash", "RootSquash", "AllSquash"],
                },
            },
            enableSnapshotVirtualDirectoryAccess: {
                serializedName: "x-ms-enable-snapshot-virtual-directory-access",
                xmlName: "x-ms-enable-snapshot-virtual-directory-access",
                type: {
                    name: "Boolean",
                },
            },
            paidBurstingEnabled: {
                serializedName: "x-ms-share-paid-bursting-enabled",
                xmlName: "x-ms-share-paid-bursting-enabled",
                type: {
                    name: "Boolean",
                },
            },
            paidBurstingMaxIops: {
                serializedName: "x-ms-share-paid-bursting-max-iops",
                xmlName: "x-ms-share-paid-bursting-max-iops",
                type: {
                    name: "Number",
                },
            },
            paidBurstingMaxBandwidthMibps: {
                serializedName: "x-ms-share-paid-bursting-max-bandwidth-mibps",
                xmlName: "x-ms-share-paid-bursting-max-bandwidth-mibps",
                type: {
                    name: "Number",
                },
            },
            includedBurstIops: {
                serializedName: "x-ms-share-included-burst-iops",
                xmlName: "x-ms-share-included-burst-iops",
                type: {
                    name: "Number",
                },
            },
            maxBurstCreditsForIops: {
                serializedName: "x-ms-share-max-burst-credits-for-iops",
                xmlName: "x-ms-share-max-burst-credits-for-iops",
                type: {
                    name: "Number",
                },
            },
            nextAllowedProvisionedIopsDowngradeTime: {
                serializedName: "x-ms-share-next-allowed-provisioned-iops-downgrade-time",
                xmlName: "x-ms-share-next-allowed-provisioned-iops-downgrade-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            nextAllowedProvisionedBandwidthDowngradeTime: {
                serializedName: "x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time",
                xmlName: "x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareGetPropertiesExceptionHeaders = {
    serializedName: "Share_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareDeleteHeaders = {
    serializedName: "Share_deleteHeaders",
    type: {
        name: "Composite",
        className: "ShareDeleteHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            usageBytes: {
                serializedName: "x-ms-file-share-usage-bytes",
                xmlName: "x-ms-file-share-usage-bytes",
                type: {
                    name: "Number",
                },
            },
            snapshotUsageBytes: {
                serializedName: "x-ms-file-share-snapshot-usage-bytes",
                xmlName: "x-ms-file-share-snapshot-usage-bytes",
                type: {
                    name: "Number",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareDeleteExceptionHeaders = {
    serializedName: "Share_deleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareDeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareAcquireLeaseHeaders = {
    serializedName: "Share_acquireLeaseHeaders",
    type: {
        name: "Composite",
        className: "ShareAcquireLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
        },
    },
};
export const ShareAcquireLeaseExceptionHeaders = {
    serializedName: "Share_acquireLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareAcquireLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareReleaseLeaseHeaders = {
    serializedName: "Share_releaseLeaseHeaders",
    type: {
        name: "Composite",
        className: "ShareReleaseLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
        },
    },
};
export const ShareReleaseLeaseExceptionHeaders = {
    serializedName: "Share_releaseLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareReleaseLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareChangeLeaseHeaders = {
    serializedName: "Share_changeLeaseHeaders",
    type: {
        name: "Composite",
        className: "ShareChangeLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
        },
    },
};
export const ShareChangeLeaseExceptionHeaders = {
    serializedName: "Share_changeLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareChangeLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareRenewLeaseHeaders = {
    serializedName: "Share_renewLeaseHeaders",
    type: {
        name: "Composite",
        className: "ShareRenewLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
        },
    },
};
export const ShareRenewLeaseExceptionHeaders = {
    serializedName: "Share_renewLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareRenewLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareBreakLeaseHeaders = {
    serializedName: "Share_breakLeaseHeaders",
    type: {
        name: "Composite",
        className: "ShareBreakLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            leaseTimeInSeconds: {
                serializedName: "x-ms-lease-time",
                xmlName: "x-ms-lease-time",
                type: {
                    name: "Number",
                },
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
        },
    },
};
export const ShareBreakLeaseExceptionHeaders = {
    serializedName: "Share_breakLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareBreakLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareCreateSnapshotHeaders = {
    serializedName: "Share_createSnapshotHeaders",
    type: {
        name: "Composite",
        className: "ShareCreateSnapshotHeaders",
        modelProperties: {
            snapshot: {
                serializedName: "x-ms-snapshot",
                xmlName: "x-ms-snapshot",
                type: {
                    name: "String",
                },
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareCreateSnapshotExceptionHeaders = {
    serializedName: "Share_createSnapshotExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareCreateSnapshotExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareCreatePermissionHeaders = {
    serializedName: "Share_createPermissionHeaders",
    type: {
        name: "Composite",
        className: "ShareCreatePermissionHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            filePermissionKey: {
                serializedName: "x-ms-file-permission-key",
                xmlName: "x-ms-file-permission-key",
                type: {
                    name: "String",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareCreatePermissionExceptionHeaders = {
    serializedName: "Share_createPermissionExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareCreatePermissionExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareGetPermissionHeaders = {
    serializedName: "Share_getPermissionHeaders",
    type: {
        name: "Composite",
        className: "ShareGetPermissionHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareGetPermissionExceptionHeaders = {
    serializedName: "Share_getPermissionExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareGetPermissionExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareSetPropertiesHeaders = {
    serializedName: "Share_setPropertiesHeaders",
    type: {
        name: "Composite",
        className: "ShareSetPropertiesHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            quota: {
                serializedName: "x-ms-share-quota",
                xmlName: "x-ms-share-quota",
                type: {
                    name: "Number",
                },
            },
            provisionedIops: {
                serializedName: "x-ms-share-provisioned-iops",
                xmlName: "x-ms-share-provisioned-iops",
                type: {
                    name: "Number",
                },
            },
            provisionedBandwidthMibps: {
                serializedName: "x-ms-share-provisioned-bandwidth-mibps",
                xmlName: "x-ms-share-provisioned-bandwidth-mibps",
                type: {
                    name: "Number",
                },
            },
            includedBurstIops: {
                serializedName: "x-ms-share-included-burst-iops",
                xmlName: "x-ms-share-included-burst-iops",
                type: {
                    name: "Number",
                },
            },
            maxBurstCreditsForIops: {
                serializedName: "x-ms-share-max-burst-credits-for-iops",
                xmlName: "x-ms-share-max-burst-credits-for-iops",
                type: {
                    name: "Number",
                },
            },
            nextAllowedQuotaDowngradeTime: {
                serializedName: "x-ms-share-next-allowed-quota-downgrade-time",
                xmlName: "x-ms-share-next-allowed-quota-downgrade-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            nextAllowedProvisionedIopsDowngradeTime: {
                serializedName: "x-ms-share-next-allowed-provisioned-iops-downgrade-time",
                xmlName: "x-ms-share-next-allowed-provisioned-iops-downgrade-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            nextAllowedProvisionedBandwidthDowngradeTime: {
                serializedName: "x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time",
                xmlName: "x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareSetPropertiesExceptionHeaders = {
    serializedName: "Share_setPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareSetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareSetMetadataHeaders = {
    serializedName: "Share_setMetadataHeaders",
    type: {
        name: "Composite",
        className: "ShareSetMetadataHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareSetMetadataExceptionHeaders = {
    serializedName: "Share_setMetadataExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareSetMetadataExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareGetAccessPolicyHeaders = {
    serializedName: "Share_getAccessPolicyHeaders",
    type: {
        name: "Composite",
        className: "ShareGetAccessPolicyHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareGetAccessPolicyExceptionHeaders = {
    serializedName: "Share_getAccessPolicyExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareGetAccessPolicyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareSetAccessPolicyHeaders = {
    serializedName: "Share_setAccessPolicyHeaders",
    type: {
        name: "Composite",
        className: "ShareSetAccessPolicyHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareSetAccessPolicyExceptionHeaders = {
    serializedName: "Share_setAccessPolicyExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareSetAccessPolicyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareGetStatisticsHeaders = {
    serializedName: "Share_getStatisticsHeaders",
    type: {
        name: "Composite",
        className: "ShareGetStatisticsHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareGetStatisticsExceptionHeaders = {
    serializedName: "Share_getStatisticsExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareGetStatisticsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const ShareRestoreHeaders = {
    serializedName: "Share_restoreHeaders",
    type: {
        name: "Composite",
        className: "ShareRestoreHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            quota: {
                serializedName: "x-ms-share-quota",
                xmlName: "x-ms-share-quota",
                type: {
                    name: "Number",
                },
            },
            provisionedIops: {
                serializedName: "x-ms-share-provisioned-iops",
                xmlName: "x-ms-share-provisioned-iops",
                type: {
                    name: "Number",
                },
            },
            provisionedBandwidthMibps: {
                serializedName: "x-ms-share-provisioned-bandwidth-mibps",
                xmlName: "x-ms-share-provisioned-bandwidth-mibps",
                type: {
                    name: "Number",
                },
            },
            includedBurstIops: {
                serializedName: "x-ms-share-included-burst-iops",
                xmlName: "x-ms-share-included-burst-iops",
                type: {
                    name: "Number",
                },
            },
            maxBurstCreditsForIops: {
                serializedName: "x-ms-share-max-burst-credits-for-iops",
                xmlName: "x-ms-share-max-burst-credits-for-iops",
                type: {
                    name: "Number",
                },
            },
        },
    },
};
export const ShareRestoreExceptionHeaders = {
    serializedName: "Share_restoreExceptionHeaders",
    type: {
        name: "Composite",
        className: "ShareRestoreExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryCreateHeaders = {
    serializedName: "Directory_createHeaders",
    type: {
        name: "Composite",
        className: "DirectoryCreateHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            filePermissionKey: {
                serializedName: "x-ms-file-permission-key",
                xmlName: "x-ms-file-permission-key",
                type: {
                    name: "String",
                },
            },
            fileAttributes: {
                serializedName: "x-ms-file-attributes",
                xmlName: "x-ms-file-attributes",
                type: {
                    name: "String",
                },
            },
            fileCreatedOn: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteOn: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeOn: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
            fileMode: {
                serializedName: "x-ms-mode",
                xmlName: "x-ms-mode",
                type: {
                    name: "String",
                },
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String",
                },
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String",
                },
            },
            nfsFileType: {
                serializedName: "x-ms-file-file-type",
                xmlName: "x-ms-file-file-type",
                type: {
                    name: "String",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryCreateExceptionHeaders = {
    serializedName: "Directory_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "DirectoryCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryGetPropertiesHeaders = {
    serializedName: "Directory_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "DirectoryGetPropertiesHeaders",
        modelProperties: {
            metadata: {
                serializedName: "x-ms-meta",
                headerCollectionPrefix: "x-ms-meta-",
                xmlName: "x-ms-meta",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } },
                },
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-server-encrypted",
                xmlName: "x-ms-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            fileAttributes: {
                serializedName: "x-ms-file-attributes",
                xmlName: "x-ms-file-attributes",
                type: {
                    name: "String",
                },
            },
            fileCreatedOn: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteOn: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeOn: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            filePermissionKey: {
                serializedName: "x-ms-file-permission-key",
                xmlName: "x-ms-file-permission-key",
                type: {
                    name: "String",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
            fileMode: {
                serializedName: "x-ms-mode",
                xmlName: "x-ms-mode",
                type: {
                    name: "String",
                },
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String",
                },
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String",
                },
            },
            nfsFileType: {
                serializedName: "x-ms-file-file-type",
                xmlName: "x-ms-file-file-type",
                type: {
                    name: "String",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryGetPropertiesExceptionHeaders = {
    serializedName: "Directory_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "DirectoryGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryDeleteHeaders = {
    serializedName: "Directory_deleteHeaders",
    type: {
        name: "Composite",
        className: "DirectoryDeleteHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryDeleteExceptionHeaders = {
    serializedName: "Directory_deleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "DirectoryDeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectorySetPropertiesHeaders = {
    serializedName: "Directory_setPropertiesHeaders",
    type: {
        name: "Composite",
        className: "DirectorySetPropertiesHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            filePermissionKey: {
                serializedName: "x-ms-file-permission-key",
                xmlName: "x-ms-file-permission-key",
                type: {
                    name: "String",
                },
            },
            fileAttributes: {
                serializedName: "x-ms-file-attributes",
                xmlName: "x-ms-file-attributes",
                type: {
                    name: "String",
                },
            },
            fileCreatedOn: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteOn: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeOn: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
            fileMode: {
                serializedName: "x-ms-mode",
                xmlName: "x-ms-mode",
                type: {
                    name: "String",
                },
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String",
                },
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectorySetPropertiesExceptionHeaders = {
    serializedName: "Directory_setPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "DirectorySetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectorySetMetadataHeaders = {
    serializedName: "Directory_setMetadataHeaders",
    type: {
        name: "Composite",
        className: "DirectorySetMetadataHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectorySetMetadataExceptionHeaders = {
    serializedName: "Directory_setMetadataExceptionHeaders",
    type: {
        name: "Composite",
        className: "DirectorySetMetadataExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryListFilesAndDirectoriesSegmentHeaders = {
    serializedName: "Directory_listFilesAndDirectoriesSegmentHeaders",
    type: {
        name: "Composite",
        className: "DirectoryListFilesAndDirectoriesSegmentHeaders",
        modelProperties: {
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryListFilesAndDirectoriesSegmentExceptionHeaders = {
    serializedName: "Directory_listFilesAndDirectoriesSegmentExceptionHeaders",
    type: {
        name: "Composite",
        className: "DirectoryListFilesAndDirectoriesSegmentExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryListHandlesHeaders = {
    serializedName: "Directory_listHandlesHeaders",
    type: {
        name: "Composite",
        className: "DirectoryListHandlesHeaders",
        modelProperties: {
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryListHandlesExceptionHeaders = {
    serializedName: "Directory_listHandlesExceptionHeaders",
    type: {
        name: "Composite",
        className: "DirectoryListHandlesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryForceCloseHandlesHeaders = {
    serializedName: "Directory_forceCloseHandlesHeaders",
    type: {
        name: "Composite",
        className: "DirectoryForceCloseHandlesHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            marker: {
                serializedName: "x-ms-marker",
                xmlName: "x-ms-marker",
                type: {
                    name: "String",
                },
            },
            numberOfHandlesClosed: {
                serializedName: "x-ms-number-of-handles-closed",
                xmlName: "x-ms-number-of-handles-closed",
                type: {
                    name: "Number",
                },
            },
            numberOfHandlesFailedToClose: {
                serializedName: "x-ms-number-of-handles-failed",
                xmlName: "x-ms-number-of-handles-failed",
                type: {
                    name: "Number",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryForceCloseHandlesExceptionHeaders = {
    serializedName: "Directory_forceCloseHandlesExceptionHeaders",
    type: {
        name: "Composite",
        className: "DirectoryForceCloseHandlesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryRenameHeaders = {
    serializedName: "Directory_renameHeaders",
    type: {
        name: "Composite",
        className: "DirectoryRenameHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            filePermissionKey: {
                serializedName: "x-ms-file-permission-key",
                xmlName: "x-ms-file-permission-key",
                type: {
                    name: "String",
                },
            },
            fileAttributes: {
                serializedName: "x-ms-file-attributes",
                xmlName: "x-ms-file-attributes",
                type: {
                    name: "String",
                },
            },
            fileCreationTime: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteTime: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeTime: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const DirectoryRenameExceptionHeaders = {
    serializedName: "Directory_renameExceptionHeaders",
    type: {
        name: "Composite",
        className: "DirectoryRenameExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileCreateHeaders = {
    serializedName: "File_createHeaders",
    type: {
        name: "Composite",
        className: "FileCreateHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            filePermissionKey: {
                serializedName: "x-ms-file-permission-key",
                xmlName: "x-ms-file-permission-key",
                type: {
                    name: "String",
                },
            },
            fileAttributes: {
                serializedName: "x-ms-file-attributes",
                xmlName: "x-ms-file-attributes",
                type: {
                    name: "String",
                },
            },
            fileCreatedOn: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteOn: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeOn: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
            fileMode: {
                serializedName: "x-ms-mode",
                xmlName: "x-ms-mode",
                type: {
                    name: "String",
                },
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String",
                },
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String",
                },
            },
            nfsFileType: {
                serializedName: "x-ms-file-file-type",
                xmlName: "x-ms-file-file-type",
                type: {
                    name: "String",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileCreateExceptionHeaders = {
    serializedName: "File_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileDownloadHeaders = {
    serializedName: "File_downloadHeaders",
    type: {
        name: "Composite",
        className: "FileDownloadHeaders",
        modelProperties: {
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            metadata: {
                serializedName: "x-ms-meta",
                headerCollectionPrefix: "x-ms-meta-",
                xmlName: "x-ms-meta",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } },
                },
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number",
                },
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String",
                },
            },
            contentRange: {
                serializedName: "content-range",
                xmlName: "content-range",
                type: {
                    name: "String",
                },
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray",
                },
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String",
                },
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String",
                },
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String",
                },
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            acceptRanges: {
                serializedName: "accept-ranges",
                xmlName: "accept-ranges",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            copyCompletedOn: {
                serializedName: "x-ms-copy-completion-time",
                xmlName: "x-ms-copy-completion-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            copyStatusDescription: {
                serializedName: "x-ms-copy-status-description",
                xmlName: "x-ms-copy-status-description",
                type: {
                    name: "String",
                },
            },
            copyId: {
                serializedName: "x-ms-copy-id",
                xmlName: "x-ms-copy-id",
                type: {
                    name: "String",
                },
            },
            copyProgress: {
                serializedName: "x-ms-copy-progress",
                xmlName: "x-ms-copy-progress",
                type: {
                    name: "String",
                },
            },
            copySource: {
                serializedName: "x-ms-copy-source",
                xmlName: "x-ms-copy-source",
                type: {
                    name: "String",
                },
            },
            copyStatus: {
                serializedName: "x-ms-copy-status",
                xmlName: "x-ms-copy-status",
                type: {
                    name: "Enum",
                    allowedValues: ["pending", "success", "aborted", "failed"],
                },
            },
            fileContentMD5: {
                serializedName: "x-ms-content-md5",
                xmlName: "x-ms-content-md5",
                type: {
                    name: "ByteArray",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-server-encrypted",
                xmlName: "x-ms-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            fileAttributes: {
                serializedName: "x-ms-file-attributes",
                xmlName: "x-ms-file-attributes",
                type: {
                    name: "String",
                },
            },
            fileCreatedOn: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteOn: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeOn: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            filePermissionKey: {
                serializedName: "x-ms-file-permission-key",
                xmlName: "x-ms-file-permission-key",
                type: {
                    name: "String",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "Enum",
                    allowedValues: ["infinite", "fixed"],
                },
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "available",
                        "leased",
                        "expired",
                        "breaking",
                        "broken",
                    ],
                },
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "Enum",
                    allowedValues: ["locked", "unlocked"],
                },
            },
            fileMode: {
                serializedName: "x-ms-mode",
                xmlName: "x-ms-mode",
                type: {
                    name: "String",
                },
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String",
                },
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String",
                },
            },
            linkCount: {
                serializedName: "x-ms-link-count",
                xmlName: "x-ms-link-count",
                type: {
                    name: "Number",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileDownloadExceptionHeaders = {
    serializedName: "File_downloadExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileDownloadExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileGetPropertiesHeaders = {
    serializedName: "File_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "FileGetPropertiesHeaders",
        modelProperties: {
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            metadata: {
                serializedName: "x-ms-meta",
                headerCollectionPrefix: "x-ms-meta-",
                xmlName: "x-ms-meta",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } },
                },
            },
            fileType: {
                serializedName: "x-ms-type",
                xmlName: "x-ms-type",
                type: {
                    name: "String",
                },
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number",
                },
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String",
                },
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray",
                },
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String",
                },
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String",
                },
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String",
                },
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            copyCompletedOn: {
                serializedName: "x-ms-copy-completion-time",
                xmlName: "x-ms-copy-completion-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            copyStatusDescription: {
                serializedName: "x-ms-copy-status-description",
                xmlName: "x-ms-copy-status-description",
                type: {
                    name: "String",
                },
            },
            copyId: {
                serializedName: "x-ms-copy-id",
                xmlName: "x-ms-copy-id",
                type: {
                    name: "String",
                },
            },
            copyProgress: {
                serializedName: "x-ms-copy-progress",
                xmlName: "x-ms-copy-progress",
                type: {
                    name: "String",
                },
            },
            copySource: {
                serializedName: "x-ms-copy-source",
                xmlName: "x-ms-copy-source",
                type: {
                    name: "String",
                },
            },
            copyStatus: {
                serializedName: "x-ms-copy-status",
                xmlName: "x-ms-copy-status",
                type: {
                    name: "Enum",
                    allowedValues: ["pending", "success", "aborted", "failed"],
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-server-encrypted",
                xmlName: "x-ms-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            fileAttributes: {
                serializedName: "x-ms-file-attributes",
                xmlName: "x-ms-file-attributes",
                type: {
                    name: "String",
                },
            },
            fileCreatedOn: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteOn: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeOn: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            filePermissionKey: {
                serializedName: "x-ms-file-permission-key",
                xmlName: "x-ms-file-permission-key",
                type: {
                    name: "String",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "Enum",
                    allowedValues: ["infinite", "fixed"],
                },
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "available",
                        "leased",
                        "expired",
                        "breaking",
                        "broken",
                    ],
                },
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "Enum",
                    allowedValues: ["locked", "unlocked"],
                },
            },
            fileMode: {
                serializedName: "x-ms-mode",
                xmlName: "x-ms-mode",
                type: {
                    name: "String",
                },
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String",
                },
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String",
                },
            },
            linkCount: {
                serializedName: "x-ms-link-count",
                xmlName: "x-ms-link-count",
                type: {
                    name: "Number",
                },
            },
            nfsFileType: {
                serializedName: "x-ms-file-file-type",
                xmlName: "x-ms-file-file-type",
                type: {
                    name: "String",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileGetPropertiesExceptionHeaders = {
    serializedName: "File_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileDeleteHeaders = {
    serializedName: "File_deleteHeaders",
    type: {
        name: "Composite",
        className: "FileDeleteHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            linkCount: {
                serializedName: "x-ms-link-count",
                xmlName: "x-ms-link-count",
                type: {
                    name: "Number",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileDeleteExceptionHeaders = {
    serializedName: "File_deleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileDeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileSetHttpHeadersHeaders = {
    serializedName: "File_setHttpHeadersHeaders",
    type: {
        name: "Composite",
        className: "FileSetHttpHeadersHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            filePermissionKey: {
                serializedName: "x-ms-file-permission-key",
                xmlName: "x-ms-file-permission-key",
                type: {
                    name: "String",
                },
            },
            fileAttributes: {
                serializedName: "x-ms-file-attributes",
                xmlName: "x-ms-file-attributes",
                type: {
                    name: "String",
                },
            },
            fileCreatedOn: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteOn: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeOn: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
            fileMode: {
                serializedName: "x-ms-mode",
                xmlName: "x-ms-mode",
                type: {
                    name: "String",
                },
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String",
                },
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String",
                },
            },
            linkCount: {
                serializedName: "x-ms-link-count",
                xmlName: "x-ms-link-count",
                type: {
                    name: "Number",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileSetHttpHeadersExceptionHeaders = {
    serializedName: "File_setHttpHeadersExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSetHttpHeadersExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileSetMetadataHeaders = {
    serializedName: "File_setMetadataHeaders",
    type: {
        name: "Composite",
        className: "FileSetMetadataHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileSetMetadataExceptionHeaders = {
    serializedName: "File_setMetadataExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSetMetadataExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileAcquireLeaseHeaders = {
    serializedName: "File_acquireLeaseHeaders",
    type: {
        name: "Composite",
        className: "FileAcquireLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
        },
    },
};
export const FileAcquireLeaseExceptionHeaders = {
    serializedName: "File_acquireLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileAcquireLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileReleaseLeaseHeaders = {
    serializedName: "File_releaseLeaseHeaders",
    type: {
        name: "Composite",
        className: "FileReleaseLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
        },
    },
};
export const FileReleaseLeaseExceptionHeaders = {
    serializedName: "File_releaseLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileReleaseLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileChangeLeaseHeaders = {
    serializedName: "File_changeLeaseHeaders",
    type: {
        name: "Composite",
        className: "FileChangeLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
        },
    },
};
export const FileChangeLeaseExceptionHeaders = {
    serializedName: "File_changeLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileChangeLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileBreakLeaseHeaders = {
    serializedName: "File_breakLeaseHeaders",
    type: {
        name: "Composite",
        className: "FileBreakLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
        },
    },
};
export const FileBreakLeaseExceptionHeaders = {
    serializedName: "File_breakLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileBreakLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileUploadRangeHeaders = {
    serializedName: "File_uploadRangeHeaders",
    type: {
        name: "Composite",
        className: "FileUploadRangeHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            fileLastWriteTime: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileUploadRangeExceptionHeaders = {
    serializedName: "File_uploadRangeExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileUploadRangeExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileUploadRangeFromURLHeaders = {
    serializedName: "File_uploadRangeFromURLHeaders",
    type: {
        name: "Composite",
        className: "FileUploadRangeFromURLHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            fileLastWriteTime: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileUploadRangeFromURLExceptionHeaders = {
    serializedName: "File_uploadRangeFromURLExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileUploadRangeFromURLExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
            copySourceErrorCode: {
                serializedName: "x-ms-copy-source-error-code",
                xmlName: "x-ms-copy-source-error-code",
                type: {
                    name: "String",
                },
            },
            copySourceStatusCode: {
                serializedName: "x-ms-copy-source-status-code",
                xmlName: "x-ms-copy-source-status-code",
                type: {
                    name: "Number",
                },
            },
        },
    },
};
export const FileGetRangeListHeaders = {
    serializedName: "File_getRangeListHeaders",
    type: {
        name: "Composite",
        className: "FileGetRangeListHeaders",
        modelProperties: {
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            fileContentLength: {
                serializedName: "x-ms-content-length",
                xmlName: "x-ms-content-length",
                type: {
                    name: "Number",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileGetRangeListExceptionHeaders = {
    serializedName: "File_getRangeListExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileGetRangeListExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileStartCopyHeaders = {
    serializedName: "File_startCopyHeaders",
    type: {
        name: "Composite",
        className: "FileStartCopyHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            copyId: {
                serializedName: "x-ms-copy-id",
                xmlName: "x-ms-copy-id",
                type: {
                    name: "String",
                },
            },
            copyStatus: {
                serializedName: "x-ms-copy-status",
                xmlName: "x-ms-copy-status",
                type: {
                    name: "Enum",
                    allowedValues: ["pending", "success", "aborted", "failed"],
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileStartCopyExceptionHeaders = {
    serializedName: "File_startCopyExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileStartCopyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
            copySourceErrorCode: {
                serializedName: "x-ms-copy-source-error-code",
                xmlName: "x-ms-copy-source-error-code",
                type: {
                    name: "String",
                },
            },
            copySourceStatusCode: {
                serializedName: "x-ms-copy-source-status-code",
                xmlName: "x-ms-copy-source-status-code",
                type: {
                    name: "Number",
                },
            },
        },
    },
};
export const FileAbortCopyHeaders = {
    serializedName: "File_abortCopyHeaders",
    type: {
        name: "Composite",
        className: "FileAbortCopyHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileAbortCopyExceptionHeaders = {
    serializedName: "File_abortCopyExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileAbortCopyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileListHandlesHeaders = {
    serializedName: "File_listHandlesHeaders",
    type: {
        name: "Composite",
        className: "FileListHandlesHeaders",
        modelProperties: {
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileListHandlesExceptionHeaders = {
    serializedName: "File_listHandlesExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileListHandlesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileForceCloseHandlesHeaders = {
    serializedName: "File_forceCloseHandlesHeaders",
    type: {
        name: "Composite",
        className: "FileForceCloseHandlesHeaders",
        modelProperties: {
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            marker: {
                serializedName: "x-ms-marker",
                xmlName: "x-ms-marker",
                type: {
                    name: "String",
                },
            },
            numberOfHandlesClosed: {
                serializedName: "x-ms-number-of-handles-closed",
                xmlName: "x-ms-number-of-handles-closed",
                type: {
                    name: "Number",
                },
            },
            numberOfHandlesFailedToClose: {
                serializedName: "x-ms-number-of-handles-failed",
                xmlName: "x-ms-number-of-handles-failed",
                type: {
                    name: "Number",
                },
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileForceCloseHandlesExceptionHeaders = {
    serializedName: "File_forceCloseHandlesExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileForceCloseHandlesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileRenameHeaders = {
    serializedName: "File_renameHeaders",
    type: {
        name: "Composite",
        className: "FileRenameHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean",
                },
            },
            filePermissionKey: {
                serializedName: "x-ms-file-permission-key",
                xmlName: "x-ms-file-permission-key",
                type: {
                    name: "String",
                },
            },
            fileAttributes: {
                serializedName: "x-ms-file-attributes",
                xmlName: "x-ms-file-attributes",
                type: {
                    name: "String",
                },
            },
            fileCreationTime: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteTime: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeTime: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileRenameExceptionHeaders = {
    serializedName: "File_renameExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileRenameExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileCreateSymbolicLinkHeaders = {
    serializedName: "File_createSymbolicLinkHeaders",
    type: {
        name: "Composite",
        className: "FileCreateSymbolicLinkHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileCreationTime: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteTime: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeTime: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            fileMode: {
                serializedName: "x-ms-mode",
                xmlName: "x-ms-mode",
                type: {
                    name: "String",
                },
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String",
                },
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String",
                },
            },
            nfsFileType: {
                serializedName: "x-ms-file-file-type",
                xmlName: "x-ms-file-file-type",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileCreateSymbolicLinkExceptionHeaders = {
    serializedName: "File_createSymbolicLinkExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileCreateSymbolicLinkExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileGetSymbolicLinkHeaders = {
    serializedName: "File_getSymbolicLinkHeaders",
    type: {
        name: "Composite",
        className: "FileGetSymbolicLinkHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            linkText: {
                serializedName: "x-ms-link-text",
                xmlName: "x-ms-link-text",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileGetSymbolicLinkExceptionHeaders = {
    serializedName: "File_getSymbolicLinkExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileGetSymbolicLinkExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileCreateHardLinkHeaders = {
    serializedName: "File_createHardLinkHeaders",
    type: {
        name: "Composite",
        className: "FileCreateHardLinkHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String",
                },
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String",
                },
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String",
                },
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileCreationTime: {
                serializedName: "x-ms-file-creation-time",
                xmlName: "x-ms-file-creation-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileLastWriteTime: {
                serializedName: "x-ms-file-last-write-time",
                xmlName: "x-ms-file-last-write-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileChangeTime: {
                serializedName: "x-ms-file-change-time",
                xmlName: "x-ms-file-change-time",
                type: {
                    name: "DateTimeRfc1123",
                },
            },
            fileId: {
                serializedName: "x-ms-file-id",
                xmlName: "x-ms-file-id",
                type: {
                    name: "String",
                },
            },
            fileParentId: {
                serializedName: "x-ms-file-parent-id",
                xmlName: "x-ms-file-parent-id",
                type: {
                    name: "String",
                },
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String",
                },
            },
            linkCount: {
                serializedName: "x-ms-link-count",
                xmlName: "x-ms-link-count",
                type: {
                    name: "Number",
                },
            },
            fileMode: {
                serializedName: "x-ms-mode",
                xmlName: "x-ms-mode",
                type: {
                    name: "String",
                },
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String",
                },
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String",
                },
            },
            nfsFileType: {
                serializedName: "x-ms-file-file-type",
                xmlName: "x-ms-file-file-type",
                type: {
                    name: "String",
                },
            },
        },
    },
};
export const FileCreateHardLinkExceptionHeaders = {
    serializedName: "File_createHardLinkExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileCreateHardLinkExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String",
                },
            },
        },
    },
};
//# sourceMappingURL=mappers.js.map