import type { StorageClient as StorageClientContext } from "./generated/src/index.js";
import type { Pipeline } from "./Pipeline.js";
import type { OperationTracingOptions } from "@azure/core-tracing";
import type { AnonymousCredential } from "@azure/storage-common";
import type { StorageSharedKeyCredential } from "@azure/storage-common";
import type { TokenCredential } from "@azure/core-auth";
/**
 * An interface for options common to every remote operation.
 */
export interface CommonOptions {
    /**
     * Options to configure spans created when tracing is enabled.
     */
    tracingOptions?: OperationTracingOptions;
}
/**
 * A StorageClient represents a based client class for {@link QueueServiceClient}, {@link QueueClient} and etc.
 */
export declare abstract class StorageClient {
    /**
     * URL string value.
     */
    readonly url: string;
    readonly accountName: string;
    /**
     * Request policy pipeline.
     *
     * @internal
     */
    protected readonly pipeline: Pipeline;
    /**
     * Credential factory in the pipeline to authenticate requests to the service, such as AnonymousCredential, StorageSharedKeyCredential.
     * Initialized to an AnonymousCredential if not able to retrieve it from the pipeline.
     *
     * @internal
     */
    protected readonly credential: StorageSharedKeyCredential | AnonymousCredential | TokenCredential;
    /**
     * StorageClientContext is a reference to protocol layer operations entry, which is
     * generated by AutoRest generator.
     */
    protected readonly storageClientContext: StorageClientContext;
    /**
     * Creates an instance of StorageClient.
     * @param url -
     * @param pipeline -
     */
    protected constructor(url: string, pipeline: Pipeline);
}
/**
 * Defines values for ListQueuesIncludeType.
 * Possible values include: 'metadata'
 * @readonly
 */
export type ListQueuesIncludeType = "metadata";
/**
 * @internal
 */
export declare function getStorageClientContext(url: string, pipeline: Pipeline): StorageClientContext;
//# sourceMappingURL=StorageClient.d.ts.map