/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import { BaseResource } from '../../../index';
import { CloudError } from '../../../index';


/**
 * @class
 * Initializes a new instance of the Location class.
 * @constructor
 * Location information.
 *
 * @member {string} [id] The fully qualified ID of the location. For example,
 * /subscriptions/00000000-0000-0000-0000-000000000000/locations/westus.
 *
 * @member {string} [subscriptionId] The subscription ID.
 *
 * @member {string} [name] The location name.
 *
 * @member {string} [displayName] The display name of the location.
 *
 * @member {string} [latitude] The latitude of the location.
 *
 * @member {string} [longitude] The longitude of the location.
 *
 */
export interface Location {
  readonly id?: string;
  readonly subscriptionId?: string;
  readonly name?: string;
  readonly displayName?: string;
  readonly latitude?: string;
  readonly longitude?: string;
}

/**
 * @class
 * Initializes a new instance of the LocationListResult class.
 * @constructor
 * Location list operation response.
 *
 * @member {array} [value] An array of locations.
 *
 */
export interface LocationListResult {
  value?: Location[];
}

/**
 * @class
 * Initializes a new instance of the SubscriptionPolicies class.
 * @constructor
 * Subscription policies.
 *
 * @member {string} [locationPlacementId] The subscription location placement
 * ID. The ID indicates which regions are visible for a subscription. For
 * example, a subscription with a location placement Id of Public_2014-09-01
 * has access to Azure public regions.
 *
 * @member {string} [quotaId] The subscription quota ID.
 *
 * @member {string} [spendingLimit] The subscription spending limit. Possible
 * values include: 'On', 'Off', 'CurrentPeriodOff'
 *
 */
export interface SubscriptionPolicies {
  readonly locationPlacementId?: string;
  readonly quotaId?: string;
  readonly spendingLimit?: string;
}

/**
 * @class
 * Initializes a new instance of the Subscription class.
 * @constructor
 * Subscription information.
 *
 * @member {string} [id] The fully qualified ID for the subscription. For
 * example, /subscriptions/00000000-0000-0000-0000-000000000000.
 *
 * @member {string} [subscriptionId] The subscription ID.
 *
 * @member {string} [tenantId] The tenant ID.
 *
 * @member {string} [displayName] The subscription display name.
 *
 * @member {string} [state] The subscription state. Possible values are
 * Enabled, Warned, PastDue, Disabled, and Deleted. Possible values include:
 * 'Enabled', 'Warned', 'PastDue', 'Disabled', 'Deleted'
 *
 * @member {object} [subscriptionPolicies] The subscription policies.
 *
 * @member {string} [subscriptionPolicies.locationPlacementId] The subscription
 * location placement ID. The ID indicates which regions are visible for a
 * subscription. For example, a subscription with a location placement Id of
 * Public_2014-09-01 has access to Azure public regions.
 *
 * @member {string} [subscriptionPolicies.quotaId] The subscription quota ID.
 *
 * @member {string} [subscriptionPolicies.spendingLimit] The subscription
 * spending limit. Possible values include: 'On', 'Off', 'CurrentPeriodOff'
 *
 * @member {string} [authorizationSource] The authorization source of the
 * request. Valid values are one or more combinations of Legacy, RoleBased,
 * Bypassed, Direct and Management. For example, 'Legacy, RoleBased'.
 *
 */
export interface Subscription {
  readonly id?: string;
  readonly subscriptionId?: string;
  readonly tenantId?: string;
  readonly displayName?: string;
  readonly state?: string;
  subscriptionPolicies?: SubscriptionPolicies;
  authorizationSource?: string;
}

/**
 * @class
 * Initializes a new instance of the SubscriptionListResult class.
 * @constructor
 * Subscription list operation response.
 *
 * @member {array} [value] An array of subscriptions.
 *
 * @member {string} nextLink The URL to get the next set of results.
 *
 */
export interface SubscriptionListResult {
  value?: Subscription[];
  nextLink: string;
}

/**
 * @class
 * Initializes a new instance of the TenantIdDescription class.
 * @constructor
 * Tenant Id information.
 *
 * @member {string} [id] The fully qualified ID of the tenant. For example,
 * /tenants/00000000-0000-0000-0000-000000000000.
 *
 * @member {string} [tenantId] The tenant ID. For example,
 * 00000000-0000-0000-0000-000000000000.
 *
 */
export interface TenantIdDescription {
  readonly id?: string;
  readonly tenantId?: string;
}

/**
 * @class
 * Initializes a new instance of the TenantListResult class.
 * @constructor
 * Tenant Ids information.
 *
 * @member {array} [value] An array of tenants.
 *
 * @member {string} nextLink The URL to use for getting the next set of
 * results.
 *
 */
export interface TenantListResult {
  value?: TenantIdDescription[];
  nextLink: string;
}

/**
 * @class
 * Initializes a new instance of the LocationListResult class.
 * @constructor
 * Location list operation response.
 *
 * @member {array} [value] An array of locations.
 *
 */
export interface LocationListResult {
  value?: Location[];
}

/**
 * @class
 * Initializes a new instance of the SubscriptionListResult class.
 * @constructor
 * Subscription list operation response.
 *
 * @member {array} [value] An array of subscriptions.
 *
 * @member {string} nextLink The URL to get the next set of results.
 *
 */
export interface SubscriptionListResult {
  value?: Subscription[];
  nextLink: string;
}

/**
 * @class
 * Initializes a new instance of the TenantListResult class.
 * @constructor
 * Tenant Ids information.
 *
 * @member {array} [value] An array of tenants.
 *
 * @member {string} nextLink The URL to use for getting the next set of
 * results.
 *
 */
export interface TenantListResult {
  value?: TenantIdDescription[];
  nextLink: string;
}


/**
 * @class
 * Initializes a new instance of the LocationListResult class.
 * @constructor
 * Location list operation response.
 *
 */
export interface LocationListResult extends Array<Location> {
}

/**
 * @class
 * Initializes a new instance of the SubscriptionListResult class.
 * @constructor
 * Subscription list operation response.
 *
 * @member {string} nextLink The URL to get the next set of results.
 *
 */
export interface SubscriptionListResult extends Array<Subscription> {
  nextLink: string;
}

/**
 * @class
 * Initializes a new instance of the TenantListResult class.
 * @constructor
 * Tenant Ids information.
 *
 * @member {string} nextLink The URL to use for getting the next set of
 * results.
 *
 */
export interface TenantListResult extends Array<TenantIdDescription> {
  nextLink: string;
}
