/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

'use strict';

/**
 * @class
 * Initializes a new instance of the Location class.
 * @constructor
 * Location information.
 *
 * @member {string} [id] The fully qualified ID of the location. For example,
 * /subscriptions/00000000-0000-0000-0000-000000000000/locations/westus.
 *
 * @member {string} [subscriptionId] The subscription ID.
 *
 * @member {string} [name] The location name.
 *
 * @member {string} [displayName] The display name of the location.
 *
 * @member {string} [latitude] The latitude of the location.
 *
 * @member {string} [longitude] The longitude of the location.
 *
 */
class Location {
  constructor() {
  }

  /**
   * Defines the metadata of Location
   *
   * @returns {object} metadata of Location
   *
   */
  mapper() {
    return {
      required: false,
      serializedName: 'Location',
      type: {
        name: 'Composite',
        className: 'Location',
        modelProperties: {
          id: {
            required: false,
            readOnly: true,
            serializedName: 'id',
            type: {
              name: 'String'
            }
          },
          subscriptionId: {
            required: false,
            readOnly: true,
            serializedName: 'subscriptionId',
            type: {
              name: 'String'
            }
          },
          name: {
            required: false,
            readOnly: true,
            serializedName: 'name',
            type: {
              name: 'String'
            }
          },
          displayName: {
            required: false,
            readOnly: true,
            serializedName: 'displayName',
            type: {
              name: 'String'
            }
          },
          latitude: {
            required: false,
            readOnly: true,
            serializedName: 'latitude',
            type: {
              name: 'String'
            }
          },
          longitude: {
            required: false,
            readOnly: true,
            serializedName: 'longitude',
            type: {
              name: 'String'
            }
          }
        }
      }
    };
  }
}

module.exports = Location;
