/* Copyright (C)
* 2015 - John Melton, G0ORX/N6LYT
* 2024,2025 - Heiko Amft, DL1BZ (Project deskHPSDR)
*
*   This source code has been forked and was adapted from piHPSDR by DL1YCF to deskHPSDR in October 2024
*
*   This program is free software: you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation, either version 3 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
*/

#include <gtk/gtk.h>
#include <semaphore.h>
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "actions.h"
#include "gpio.h"
#include "toolbar.h"
#include "mode.h"
#include "filter.h"
#include "bandstack.h"
#include "band.h"
#include "discovered.h"
#include "new_protocol.h"
#include "old_protocol.h"
#include "vfo.h"
#include "agc.h"
#include "channel.h"
#include "radio.h"
#include "receiver.h"
#include "transmitter.h"
#include "property.h"
#include "new_menu.h"
#include "ext.h"
#include "message.h"
#include "main.h"

int function = 0;

static int width;
static int height;

// static GtkWidget *toolbar = NULL;
enum { TOOLBAR_BTN_COUNT = 10, FUNC_INDEX = 10, GRID_SPAN = 4, GRID_COLS = 11, LABEL_LEN = 16 };

static GtkWidget *sim_s[TOOLBAR_BTN_COUNT] = { NULL };

static GtkWidget *sim_sfunc;

SWITCH *toolbar_switches = switches_controller1[0];

void update_toolbar_labels() {
  if (sim_s[0]) {
    //
    // If the toolbar has not yet been on display,
    // sim_s0 and friends are NULL
    //
    for (int i = 0; i < TOOLBAR_BTN_COUNT; i++) {
      if (sim_s[i]) {
        gtk_button_set_label(GTK_BUTTON(sim_s[i]),
                             ActionTable[toolbar_switches[i].switch_function].button_str);
      }
    }

    if (sim_sfunc && toolbar_switches[FUNC_INDEX].switch_function == FUNCTION) {
      char lbl[LABEL_LEN];
      snprintf(lbl, sizeof(lbl), "FNC(%d)", function);
      gtk_button_set_label(GTK_BUTTON(sim_sfunc), lbl);
    } else {
      if (sim_sfunc)
        gtk_button_set_label(GTK_BUTTON(sim_sfunc),
                             ActionTable[toolbar_switches[FUNC_INDEX].switch_function].button_str);
    }
  }
}

// cppcheck-suppress constParameterCallback
static void toolbar_button_press_cb(GtkWidget *widget G_GNUC_UNUSED, GdkEventButton *event, gpointer data) {
  int i = GPOINTER_TO_INT(data);

  //
  // Filter out any special events generated by double or triple clicks
  //
  if (event->type != GDK_BUTTON_PRESS) { return; }

  //
  // This is our "easter egg" for the FUNC toolbar button. A secondary (right) click
  // cycles backwards
  //
  if (i == FUNC_INDEX && event->button == GDK_BUTTON_SECONDARY) {
    schedule_action(FUNCTIONREV, PRESSED, 0);
  } else {
    schedule_action(toolbar_switches[i].switch_function, PRESSED, 0);
  }
}

// cppcheck-suppress constParameterCallback
static void toolbar_button_released_cb(GtkWidget *widget G_GNUC_UNUSED, GdkEventButton *event G_GNUC_UNUSED,
                                       gpointer data) {
  int i = GPOINTER_TO_INT(data);
  //t_print("%s: %d action=%d\n",__FUNCTION__,i,toolbar_switches[i].switch_function);
  schedule_action(toolbar_switches[i].switch_function, RELEASED, 0);
}

GtkWidget *toolbar_init(int my_width, int my_height) {
  width = my_width;

  if (!full_screen) {
    height = my_height - 10;
  } else {
    height = my_height;
  }

  if (height < 1) { height = 1; }

  // height = 20;
  int button_width = MAX(1, width / GRID_COLS);
  const char *button_css;
  t_print("toolbar_init: width=%d height=%d button_width=%d\n", width, height, button_width);

  if (height < 40) {
    button_css = "small_button";
  } else if (height < 50) {
    button_css = "medium_button";
  } else {
    button_css = "large_button";
  }

  t_print("toolbar_init: button_css=%s\n", button_css);
  toolbar_switches = switches_controller1[function];

  // Sim-State immer beim Neuaufbau zurücksetzen
  for (int i = 0; i < TOOLBAR_BTN_COUNT; ++i) {
    sim_s[i] = NULL;
  }

  sim_sfunc = NULL;
  GtkWidget *toolbar = gtk_grid_new();
  gtk_widget_set_size_request (toolbar, width, height);
#ifdef __linux__
  gtk_widget_set_margin_top(toolbar, 10);
#endif
  gtk_grid_set_column_homogeneous(GTK_GRID(toolbar), TRUE);
  int btn_col = 0;
  int col_width = GRID_SPAN;

  for (int i = 0; i < TOOLBAR_BTN_COUNT; i++) {
    //----------------------------------------------------------------------------------------------------------------------
    sim_s[i] = gtk_button_new_with_label(ActionTable[toolbar_switches[i].switch_function].button_str);
    g_object_add_weak_pointer(G_OBJECT(sim_s[i]), (gpointer*)&sim_s[i]);
    gtk_widget_set_name(sim_s[i], button_css);
    gtk_widget_set_size_request (sim_s[i], button_width, height);
    g_signal_connect(G_OBJECT(sim_s[i]), "button-press-event", G_CALLBACK(toolbar_button_press_cb), GINT_TO_POINTER(i));
    g_signal_connect(G_OBJECT(sim_s[i]), "button-release-event", G_CALLBACK(toolbar_button_released_cb),
                     GINT_TO_POINTER(i));
    gtk_grid_attach(GTK_GRID(toolbar), sim_s[i], btn_col, 0, col_width, 1);
    btn_col += GRID_SPAN;
    //----------------------------------------------------------------------------------------------------------------------
  }

  //
  // For the FUNC button, include the layer in the description
  //
  if (toolbar_switches[FUNC_INDEX].switch_function == FUNCTION) {
    char lbl[LABEL_LEN];
    snprintf(lbl, sizeof(lbl), "FNC(%d)", function);
    sim_sfunc = gtk_button_new_with_label(lbl);
    g_object_add_weak_pointer(G_OBJECT(sim_sfunc), (gpointer*)&sim_sfunc);
  } else {
    sim_sfunc = gtk_button_new_with_label(ActionTable[toolbar_switches[FUNC_INDEX].switch_function].button_str);
    g_object_add_weak_pointer(G_OBJECT(sim_sfunc), (gpointer*)&sim_sfunc);
  }

  gtk_widget_set_name(sim_sfunc, button_css);
  gtk_widget_set_size_request (sim_sfunc, button_width, height);
  g_signal_connect(G_OBJECT(sim_sfunc), "button-press-event", G_CALLBACK(toolbar_button_press_cb),
                   GINT_TO_POINTER(FUNC_INDEX));
  g_signal_connect(G_OBJECT(sim_sfunc), "button-release-event", G_CALLBACK(toolbar_button_released_cb),
                   GINT_TO_POINTER(FUNC_INDEX));
  gtk_grid_attach(GTK_GRID(toolbar), sim_sfunc, btn_col, 0, col_width, 1);
  gtk_widget_show_all(toolbar);
  return toolbar;
}
