/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.data;

import ddb.dsz.core.data.ObjectValue;
import ddb.util.GeneralUtilities;
import java.util.Calendar;

public abstract class Data {
    protected long dataTimestamp;
    protected long lpTimestamp;

    public Data(ObjectValue objectValue) {
        this.setLpTimestamp(GeneralUtilities.stringToCalendar((String)objectValue.getString(DataConstants.Gui_LpTimestamp.text), null));
        this.setDataTimestamp(GeneralUtilities.stringToCalendar((String)objectValue.getString(DataConstants.Gui_DataTimestamp.text), null));
    }

    public final long getLpTimestamp() {
        return this.lpTimestamp;
    }

    public final Calendar getLpTimestampAsCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.lpTimestamp);
        return calendar;
    }

    public final void setLpTimestamp(long l) {
        this.lpTimestamp = l;
    }

    public final void setLpTimestamp(Calendar calendar) {
        if (calendar == null) {
            return;
        }
        this.lpTimestamp = calendar.getTimeInMillis();
    }

    public final long getDataTimestamp() {
        return this.dataTimestamp;
    }

    public final Calendar getDataTimestampAsCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.dataTimestamp);
        return calendar;
    }

    public final void setDataTimestamp(long l) {
        this.dataTimestamp = l;
    }

    public final void setDataTimestamp(Calendar calendar) {
        if (calendar == null) {
            return;
        }
        this.dataTimestamp = calendar.getTimeInMillis();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataConstants {
        Gui_LpTimestamp("gui_LpTimestamp"),
        Gui_DataTimestamp("gui_DataTimestamp");

        public final String text;

        private DataConstants() {
            this.text = this.name();
        }

        private DataConstants(String string2) {
            this.text = string2;
        }
    }
}

