/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.display;

import ddb.console.OptionPane;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.task.Task;
import ddb.dsz.library.console.ConsoleOutputPane;
import ddb.dsz.plugin.netmapviewer.data.User;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.collections.Closure;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDisplay
extends JPanel {
    private DefaultListModel userListModel;
    private ConsoleOutputPane outPane;
    private DataTransformer dataTransform;
    private int lastIndex = -1;
    private DefaultComboBoxModel comboModel;
    private TreeMap<String, String> userData = new TreeMap();
    private JComboBox fieldComboBox;
    private JLabel jLabel1;
    private JScrollPane listScroller;
    private JButton nextButton;
    private JPanel outputPanel;
    private JButton previousButton;
    private JTextField searchField;
    private JLabel searchLabel;
    private JList userList;

    public UserDisplay(CoreController coreController, List<User> list) {
        this.userListModel = new DefaultListModel(){

            public int indexOf(Object object) {
                int n = -1;
                Enumeration enumeration = this.elements();
                User user = null;
                while (enumeration.hasMoreElements()) {
                    user = (User)enumeration.nextElement();
                    if (!user.getUserName().equalsIgnoreCase((String)object)) continue;
                    n = this.indexOf(user, 0);
                    break;
                }
                return n;
            }
        };
        ArrayList<User> arrayList = new ArrayList<User>(list);
        Collections.sort(arrayList);
        for (User user : arrayList) {
            this.userListModel.addElement(user);
        }
        this.outPane = new ConsoleOutputPane(coreController);
        this.outPane.setTheme(OptionPane.getInstance().getSharedTheme());
        this.outPane.setWordWrap(false);
        this.outPane.setAutoScroll(false);
        this.comboModel = new DefaultComboBoxModel();
        this.comboModel.addElement("All");
        for (UserFields userFields : UserFields.values()) {
            this.comboModel.addElement(userFields);
        }
        this.initComponents();
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((JButton)actionEvent.getSource()).getText();
                UserDisplay.this.search(string);
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((JButton)actionEvent.getSource()).getText();
                UserDisplay.this.search(string);
            }
        });
        this.dataTransform = DataTransformer.newInstance();
        this.dataTransform.addClosure(ClosureFactory.newDisplayClosure((CoreController)coreController, (String)"users", (String)"Dsz", (Closure)new Closure(){

            public void execute(Object object) {
                UserDisplay.this.parseTaskOutput(object.toString());
            }
        }));
        Task task = coreController.getTaskById(list.get(0).getTaskId());
        this.dataTransform.addTask(task);
        this.outputPanel.add((Component)this.outPane);
        this.initializeOutput(list.get(0));
        this.userList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JList jList = (JList)listSelectionEvent.getSource();
                User user = (User)jList.getSelectedValue();
                UserDisplay.this.setOutputText(user);
                if (jList.getSelectedIndex() > 0 && !UserDisplay.this.searchField.getText().equals("")) {
                    UserDisplay.this.previousButton.setEnabled(true);
                } else {
                    UserDisplay.this.previousButton.setEnabled(false);
                }
            }
        });
    }

    private void initializeOutput(final User user) {
        String string = this.userData.get(user.getUserName().toLowerCase());
        if (string == null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    UserDisplay.this.initializeOutput(user);
                }
            });
        } else {
            this.outPane.appendDisplay(string);
        }
    }

    private void setOutputText(User user) {
        this.outPane.clearAndReplace(this.userData.get(user.getUserName().toLowerCase()));
    }

    private void parseTaskOutput(String string) {
        int n = string.indexOf("Name  :");
        int n2 = -1;
        int n3 = string.indexOf("----------", n);
        String string2 = null;
        while (n != -1) {
            n2 = string.substring(0, n).lastIndexOf("\n") + 1;
            int n4 = string.indexOf(" ", n + 8);
            string2 = string.substring(n + 7, n4).trim();
            String string3 = string.substring(n2, n3);
            this.userData.put(string2.toLowerCase(), string3);
            n = string.indexOf("Name  :", n3);
            n3 = string.indexOf("----------", n);
        }
    }

    private boolean isMatch(Object object, String string, UserFields userFields) {
        boolean bl = false;
        string = string.toLowerCase();
        if (object instanceof String) {
            if (((String)String.class.cast(object)).toLowerCase().contains(string)) {
                bl = true;
            }
        } else if (object instanceof User) {
            User user = (User)object;
            try {
                Method method = User.class.getMethod(userFields.getMethodName(), new Class[0]);
                String string2 = ((String)method.invoke((Object)user, new Object[0])).toLowerCase();
                if (string2.contains(string)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private void search(String string, UserFields userFields) {
        String string2 = this.searchField.getText().toLowerCase();
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        User user = null;
        boolean bl2 = true;
        int n = this.userList.getSelectedIndex();
        if (n == this.lastIndex) {
            n = string.equalsIgnoreCase("back") ? --n : ++n;
        }
        if (n > -1 && n <= this.userListModel.size() - 1) {
            user = (User)this.userListModel.get(n);
            string3 = user.getUserName().toLowerCase();
        }
        if (n != 0) {
            bl2 = false;
        }
        if (string3 != null) {
            if (userFields == null) {
                string4 = this.userData.get(string3);
                if (string4 != null) {
                    bl = this.isMatch(string4.toLowerCase(), string2, null);
                }
            } else {
                bl = this.isMatch(user, string2, userFields);
            }
            if (!bl) {
                while (string3 != null) {
                    n = string.equalsIgnoreCase("back") ? --n : ++n;
                    if (n > -1 && n <= this.userListModel.size() - 1) {
                        user = (User)this.userListModel.get(n);
                        string3 = user.getUserName().toLowerCase();
                    } else {
                        string3 = null;
                    }
                    if (string3 == null) continue;
                    if (userFields == null) {
                        string4 = this.userData.get(string3);
                        if (string4 != null) {
                            bl = this.isMatch(string4.toLowerCase(), string2, null);
                        }
                    } else {
                        bl = this.isMatch(user, string2, userFields);
                    }
                    if (!bl) continue;
                }
            }
        }
        if (bl) {
            this.lastIndex = n;
            this.userList.setSelectedValue(user, true);
        } else if (!bl2) {
            int n2 = JOptionPane.showConfirmDialog(this, "No entry was found containing " + string2 + "\nRetry search from the beginning?");
            if (n2 == 0) {
                this.lastIndex = -1;
                this.userList.setSelectedIndex(0);
                this.search(string, userFields);
            }
        } else {
            JOptionPane.showMessageDialog(this, "No entry was found containing " + string2);
        }
    }

    private void search(String string) {
        Object object = this.fieldComboBox.getSelectedItem();
        if (object instanceof String) {
            this.search(string, null);
        } else {
            UserFields userFields = (UserFields)((Object)object);
            this.search(string, userFields);
        }
    }

    private void initComponents() {
        this.listScroller = new JScrollPane();
        this.userList = new JList();
        this.outputPanel = new JPanel();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.searchField = new JTextField();
        this.searchLabel = new JLabel();
        this.fieldComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.userList.setBorder(BorderFactory.createTitledBorder("Users"));
        this.userList.setModel(this.userListModel);
        this.userList.setSelectionMode(1);
        this.userList.setSelectedIndex(0);
        this.listScroller.setViewportView(this.userList);
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("User Properties"));
        this.outputPanel.setLayout(new BorderLayout());
        this.previousButton.setText("Back");
        this.previousButton.setEnabled(false);
        this.nextButton.setText("Forward");
        this.nextButton.setEnabled(false);
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                UserDisplay.this.searchFieldKeyReleased(keyEvent);
            }
        });
        this.searchLabel.setText("Search:");
        this.fieldComboBox.setModel(this.comboModel);
        this.jLabel1.setText("Search Field:");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.listScroller, -2, 143, -2).addPreferredGap(0).add((Component)this.outputPanel, -1, 232, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.searchLabel).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.searchField, -2, 83, -2).addPreferredGap(0).add((Component)this.previousButton).addPreferredGap(0).add((Component)this.nextButton)).add((Component)this.fieldComboBox, -2, -1, -2)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(34, 34, 34).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.listScroller, -1, 183, Short.MAX_VALUE).add(2, (Component)this.outputPanel, -1, 183, Short.MAX_VALUE)).add(40, 40, 40).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.searchLabel).add((Component)this.searchField, -2, -1, -2).add((Component)this.previousButton).add((Component)this.nextButton)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.fieldComboBox, -2, -1, -2)).add(15, 15, 15)));
        this.outputPanel.add((Component)this.outPane);
    }

    private void searchFieldKeyReleased(KeyEvent keyEvent) {
        if (!this.searchField.getText().equals("")) {
            this.nextButton.setEnabled(true);
            if (this.userList.getSelectedIndex() > 0) {
                this.previousButton.setEnabled(true);
            }
        } else {
            this.nextButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UserFields {
        Name("Name", "getUserName"),
        Comment("Comment", "getComment"),
        Id("Id", "getUserId"),
        Group("Primary Group", "getGroupId"),
        HomeDir("Home Directory", "getHomeDir"),
        Shell("User Shell", "getUserShell"),
        NumLogons("# of Logons", "getNumLogins"),
        AcctExp("Account Expires", "getAccountExpiration"),
        PswdChange("Passwd Changed", "getPasswordChanged"),
        PswdExpired("Password Expired", "getPasswordExpiration"),
        Privileges("Privileges", "getUserPrivileges");

        private String fieldName;
        private String methodName;

        private UserFields(String string2, String string3) {
            this.fieldName = string2;
            this.methodName = string3;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String toString() {
            return this.fieldName;
        }
    }
}

