/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.insertion;

import ddb.dsz.plugin.netmapviewer.NetmapViewerHost;
import ddb.dsz.plugin.netmapviewer.Node;
import ddb.dsz.plugin.netmapviewer.insertion.UpdateNode;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeAddresses
extends UpdateNode {
    private final Collection<String> addresses = new HashSet<String>();

    public MergeAddresses(Collection<String> collection, NetmapViewerHost netmapViewerHost) {
        super(netmapViewerHost);
        for (String string : collection) {
            if (string == null || string.equals("0.0.0.0") || string.equals("::")) continue;
            this.addresses.add(string);
        }
    }

    @Override
    public void run() {
        Object object;
        if (this.addresses.size() <= 1) {
            return;
        }
        HashSet<DefaultMutableTreeNode> hashSet = new HashSet<DefaultMutableTreeNode>();
        DefaultMutableTreeNode object4 = null;
        for (final String object32 : this.addresses) {
            DefaultMutableTreeNode defaultMutableTreeNode = NetmapViewerHost.DepthFirstSearch(this.networkHost.rootNode, new Predicate(){

                public boolean evaluate(Object object) {
                    Node node;
                    return object instanceof Node && ((node = (Node)object).doesAddressMatch(object32) || node.doesNameMatch(object32));
                }
            });
            if (defaultMutableTreeNode == null) continue;
            hashSet.add(defaultMutableTreeNode);
            if (object4 != null || defaultMutableTreeNode.getParent() == this.networkHost.unknownNode) continue;
            object4 = defaultMutableTreeNode;
        }
        if (object4 != null) {
            object = (Node)object4.getUserObject();
            for (String string : this.addresses) {
                ((Node)object).addAddress(string);
            }
            hashSet.remove(object4);
            for (DefaultMutableTreeNode defaultMutableTreeNode : hashSet) {
                Node node = (Node)defaultMutableTreeNode.getUserObject();
                ((Node)object).CopyNode(node);
                this.removeNode(defaultMutableTreeNode);
            }
            return;
        }
        if (hashSet.size() == 0) {
            object = new Node();
            ((Node)object).setName(this.addresses.iterator().next());
            for (String string : this.addresses) {
                ((Node)object).addAddress(string);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
            this.insertNode(this.networkHost.unknownNode, defaultMutableTreeNode);
        } else {
            object = hashSet.iterator();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object.next();
            Node node = (Node)defaultMutableTreeNode.getUserObject();
            for (String string : this.addresses) {
                node.addAddress(string);
            }
            while (object.hasNext()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object.next();
                Node node2 = (Node)defaultMutableTreeNode2.getUserObject();
                node.CopyNode(node2);
                this.removeNode(defaultMutableTreeNode2);
            }
        }
    }
}

