/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class FileAndTextTransferHandler
extends TransferHandler {
    private DataFlavor fileFlavor = DataFlavor.javaFileListFlavor;
    private DataFlavor stringFlavor = DataFlavor.stringFlavor;
    private JTextComponent source;
    private boolean shouldRemove;
    Position p0 = null;
    Position p1 = null;

    public boolean importData(TransferHandler.TransferSupport transInfo) {
        if (!(transInfo.getComponent() instanceof JTextComponent)) {
            return false;
        }
        JTextComponent tc = (JTextComponent)JTextComponent.class.cast(transInfo.getComponent());
        if (!this.canImport(transInfo)) {
            return false;
        }
        try {
            String str;
            StringBuilder insert = new StringBuilder();
            if (this.hasFileFlavor(transInfo.getDataFlavors())) {
                str = null;
                List files = (List)transInfo.getTransferable().getTransferData(this.fileFlavor);
                for (File f : files) {
                    if (insert.length() > 0) {
                        insert.append(" ");
                    }
                    insert.append(f.getAbsolutePath());
                }
            }
            if (this.hasStringFlavor(transInfo.getDataFlavors())) {
                if (insert.length() > 0) {
                    insert.append(" ");
                }
                str = (String)String.class.cast(transInfo.getTransferable().getTransferData(this.stringFlavor));
                insert.append(str);
            }
            if (tc.equals(this.source) && tc.getCaretPosition() >= this.p0.getOffset() && tc.getCaretPosition() <= this.p1.getOffset()) {
                this.shouldRemove = false;
                return true;
            }
            String insertText = insert.toString();
            if (insertText.contains(" ") && transInfo.isDrop()) {
                int caretPos = tc.getCaretPosition();
                String quotePairsEx = "\".*\"";
                Pattern p = Pattern.compile(quotePairsEx);
                Matcher match = p.matcher(tc.getText());
                boolean isPreQuoted = false;
                while (match.find()) {
                    if (caretPos <= match.start() || caretPos >= match.end()) continue;
                    isPreQuoted = true;
                    break;
                }
                if (!isPreQuoted) {
                    insertText = String.format("\"%s\"", insertText);
                }
            }
            tc.replaceSelection(insertText);
            return true;
        }
        catch (IOException ufe) {
            return false;
        }
        catch (UnsupportedFlavorException ufe) {
            return false;
        }
    }

    protected Transferable createTransferable(JComponent c) {
        this.source = (JTextComponent)c;
        int start = this.source.getSelectionStart();
        int end = this.source.getSelectionEnd();
        Document doc = this.source.getDocument();
        if (start == end) {
            return null;
        }
        try {
            this.p0 = doc.createPosition(start);
            this.p1 = doc.createPosition(end);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.shouldRemove = true;
        String data = this.source.getSelectedText();
        return new StringSelection(data);
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
        if (this.shouldRemove && action == 2 && this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
            try {
                JTextComponent tc = (JTextComponent)c;
                tc.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        this.source = null;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        if (this.hasFileFlavor(flavors)) {
            return true;
        }
        return this.hasStringFlavor(flavors);
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        return this.hasFlavor(this.fileFlavor, flavors);
    }

    private boolean hasStringFlavor(DataFlavor[] flavors) {
        return this.hasFlavor(this.stringFlavor, flavors);
    }

    private boolean hasFlavor(DataFlavor flav, DataFlavor[] flavors) {
        for (DataFlavor df : flavors) {
            if (!flav.equals(df)) continue;
            return true;
        }
        return false;
    }
}

