/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralUtilities {
    public static TimeUnit GENERAL_WAIT_UNIT = TimeUnit.MINUTES;
    public static long GENERAL_WAIT_LENGTH = 10L;
    private static ExecutorService exec = Executors.newCachedThreadPool(GeneralUtilities.createThreadFactory("RunForATimeDelegates"));

    public static Calendar stringToCalendar(String textVersion, Calendar optionalCalendar) {
        if (textVersion == null) {
            return null;
        }
        if (textVersion.trim().length() == 0) {
            return null;
        }
        String[] bits = textVersion.split("[-T:.]");
        if (bits.length < 6 || bits.length > 7) {
            return null;
        }
        if (optionalCalendar == null) {
            optionalCalendar = Calendar.getInstance();
        }
        try {
            optionalCalendar.set(1, Integer.parseInt(bits[0]));
            optionalCalendar.set(2, Integer.parseInt(bits[1]) - 1);
            optionalCalendar.set(5, Integer.parseInt(bits[2]));
            optionalCalendar.set(11, Integer.parseInt(bits[3]));
            optionalCalendar.set(12, Integer.parseInt(bits[4]));
            optionalCalendar.set(13, Integer.parseInt(bits[5]));
            if (bits.length == 7) {
                optionalCalendar.set(14, Integer.parseInt(bits[6]) / 1000000);
            } else {
                optionalCalendar.set(14, 0);
            }
            return optionalCalendar;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String CalendarToStringXml(Calendar calendar) {
        return GeneralUtilities.formatCalendar("%04d-%02d-%02dT%02d:%02d:%02d.%06d", calendar);
    }

    public static String CalendarToStringFile(Calendar calendar) {
        return GeneralUtilities.formatCalendar("%04d_%02d_%02d_%02dh%02dm%02ds.%06d", calendar);
    }

    public static String CalendarToStringDisplay(Calendar calendar) {
        return GeneralUtilities.formatCalendar("%04d/%02d/%02d %02d:%02d:%02d.%06d", calendar);
    }

    private static String formatCalendar(String format, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(0L);
        }
        return String.format(format, calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000);
    }

    public static ThreadFactory createThreadFactory() {
        return GeneralUtilities.createThreadFactory("General Utilities");
    }

    public static ThreadFactory createThreadFactory(final String name) {
        return new ThreadFactory(){
            int count = 0;

            public Thread newThread(Runnable r) {
                Thread th = new Thread(r, String.format("%s %d", name, ++this.count));
                th.setPriority(1);
                th.setDaemon(true);
                return th;
            }
        };
    }

    public void shutdownRunForATime() {
        exec.shutdownNow();
    }

    public static <O> O runForATime(StoppableCallable<O> caller) {
        return GeneralUtilities.runForATime(caller, GENERAL_WAIT_UNIT, GENERAL_WAIT_LENGTH);
    }

    public static <O> O runForATime(final StoppableCallable<O> caller, TimeUnit unit, long delay) {
        FutureTask future = new FutureTask(new Callable<O>(){

            @Override
            public O call() {
                try {
                    return caller.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        exec.execute(future);
        try {
            return (O)future.get(delay, unit);
        }
        catch (TimeoutException e2) {
            TimeoutException e = e2;
        }
        catch (InterruptedException e2) {
            InterruptedException e = e2;
        }
        catch (ExecutionException e2) {
            ExecutionException e = e2;
        }
        caller.cancel();
        return null;
    }

    public static void main(String[] args) throws Throwable {
        Class<?> live = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> replay = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method m = live.getMethod("main", args.getClass());
        m.invoke(null, new Object[]{args});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class StoppableCallableImpl<O>
    implements StoppableCallable<O> {
        private boolean cancel = false;

        protected boolean shouldStop() {
            return this.cancel;
        }

        @Override
        public boolean isCancelled() {
            return this.cancel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface StoppableCallable<O>
    extends Callable<O> {
        public void cancel();

        public boolean isCancelled();
    }
}

