/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer;

import ddb.detach.TabbableOption;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.logviewer.LogViewer;
import ddb.util.checkedtablemodel.CheckableFilterList;
import ddb.util.checkedtablemodel.CheckedTableSelection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogViewerOptions
extends TabbableOption {
    int initialized = 0;
    int finalized = 0;
    CoreController core;
    JPanel panel;
    Collection<String> shown = new Vector<String>();
    Collection<String> hidden = new Vector<String>();
    private CheckableFilterList<String> commands;

    public JComponent getDisplay() {
        return this.panel;
    }

    public LogViewerOptions() {
        super(LogViewer.class);
        this.setName("LogViewer");
        this.panel = new JPanel(new BorderLayout());
        this.commands = new CheckableFilterList("By default,show these commands", (CheckedTableSelection)new CheckedTableSelection<String>(){

            public void selected(String item, boolean selected) {
                Collection<String> taking;
                Collection<String> giving;
                if (!selected) {
                    giving = LogViewerOptions.this.hidden;
                    taking = LogViewerOptions.this.shown;
                } else {
                    taking = LogViewerOptions.this.hidden;
                    giving = LogViewerOptions.this.shown;
                }
                taking.remove(item);
                if (!giving.contains(item)) {
                    giving.add(item.toString());
                }
            }
        }, String.CASE_INSENSITIVE_ORDER);
        this.panel.add((Component)this.commands, "Center");
        JButton temp = new JButton("Commit");
        temp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogViewerOptions.this.commit();
            }
        });
        this.panel.add((Component)temp, "South");
    }

    void commit() {
        this.core.setOption(LogViewer.class, "Shown", this.shown);
        this.core.setOption(LogViewer.class, "Hidden", this.hidden);
        this.core.commitSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fini() {
        LogViewerOptions logViewerOptions = this;
        synchronized (logViewerOptions) {
            ++this.finalized;
            if (this.finalized < this.initialized) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CoreController cc) {
        LogViewerOptions logViewerOptions = this;
        synchronized (logViewerOptions) {
            ++this.initialized;
            if (this.initialized > 1) {
                return;
            }
        }
        this.core = cc;
        Object obj1 = this.core.getOption(LogViewer.class, "Shown");
        Object obj2 = this.core.getOption(LogViewer.class, "Hidden");
        if (obj1 != null && obj1 instanceof Collection) {
            Collection shownCommand = (Collection)Collection.class.cast(obj1);
            for (Object o : shownCommand) {
                if (!this.commands.addElement((Object)o.toString().toLowerCase(), true)) continue;
                this.shown.add(o.toString().toLowerCase());
            }
        }
        if (obj2 != null && obj2 instanceof Collection) {
            Collection hiddenCommands = (Collection)Collection.class.cast(obj2);
            for (Object o : hiddenCommands) {
                String s = o.toString().toLowerCase();
                if (!this.commands.addElement((Object)s, false)) continue;
                this.hidden.add(s);
            }
            hiddenCommands.removeAll(this.shown);
        }
    }

    public void addCommand(String s) {
        if (s == null) {
            return;
        }
        if (this.shown.contains(s = s.toLowerCase()) || this.hidden.contains(s)) {
            return;
        }
        if (this.commands.addElement((Object)s, true)) {
            this.shown.add(s);
        }
    }

    public boolean allowNewInstance(Class<?> pluginClass) {
        return false;
    }

    public JComponent getDefaultElement() {
        return null;
    }
}

