/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer.gui.detail;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFilterTreeModel
implements TreeModel,
TreeModelListener {
    EventListenerList listenerList = new EventListenerList();
    TreeModel child;
    FilterTreeNode root;
    List<String> filter = new Vector<String>();

    public VariableFilterTreeModel(TreeModel child) {
        this.child = child;
        this.child.addTreeModelListener(this);
        this.update();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)TreeNode.class.cast(parent)).getChildAt(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)TreeNode.class.cast(parent)).getChildCount();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child2) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)TreeNode.class.cast(parent)).getIndex((TreeNode)TreeNode.class.cast(child2));
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof TreeNode) {
            return ((TreeNode)TreeNode.class.cast(node)).isLeaf();
        }
        return true;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.update();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.update();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.update();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.update();
    }

    public void update() {
        this.root = new FilterTreeNode((MutableTreeNode)MutableTreeNode.class.cast(this.child.getRoot()), null, this.filter);
        this.fireTreeStructureChanged();
    }

    protected void fireTreeStructureChanged() {
        TreeModelListener[] listeners = (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (TreeModelListener l : listeners) {
            if (e == null) {
                e = new TreeModelEvent((Object)this, new Object[]{this.root});
            }
            l.treeStructureChanged(e);
        }
    }

    public void applyFilter(String path) {
        if (path == null || path.length() == 0) {
            this.filter.clear();
            this.update();
        } else {
            this.applyFilter(path.split("::"));
        }
    }

    public void applyFilter(String[] path) {
        ArrayList<String> list = new ArrayList<String>(path.length);
        for (String s : path) {
            list.add(s);
        }
        this.applyFilter(list);
    }

    public void applyFilter(List<String> path) {
        this.filter.clear();
        this.filter.addAll(path);
        this.update();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FilterTreeNode
    implements MutableTreeNode {
        MutableTreeNode childNode;
        List<FilterTreeNode> children;
        FilterTreeNode parent;

        public FilterTreeNode(MutableTreeNode childNode, FilterTreeNode parent, List<String> filter) {
            this.childNode = childNode;
            this.parent = parent;
            this.children = new Vector<FilterTreeNode>();
            Enumeration<? extends TreeNode> c = childNode.children();
            String phrase = null;
            int index = -2;
            if (filter.size() > 0) {
                String filterPhrase = filter.get(0);
                int start = filterPhrase.indexOf(91);
                int stop = filterPhrase.indexOf(93);
                if (start > 0) {
                    phrase = filterPhrase.substring(0, start);
                    if (stop > start) {
                        try {
                            index = Integer.parseInt(filterPhrase.substring(start + 1, stop));
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(null, String.format("The filter '%s' has an incorrect or illegible index", filterPhrase), "Invalid filter", 2);
                            filter.clear();
                            phrase = null;
                            index = -2;
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, String.format("The filter '%s' has an incorrect or illegible index", filterPhrase), "Invalid filter", 2);
                        filter.clear();
                        phrase = null;
                        index = -2;
                    }
                } else {
                    phrase = filterPhrase;
                }
            }
            while (c.hasMoreElements()) {
                MutableTreeNode newNode = (MutableTreeNode)MutableTreeNode.class.cast(c.nextElement());
                if (phrase != null) {
                    if (!phrase.equalsIgnoreCase(newNode.toString()) || index == -1) continue;
                    if (index > 0) {
                        --index;
                        continue;
                    }
                    if (index == 0) {
                        --index;
                    }
                }
                if (filter.size() == 0) {
                    this.children.add(new FilterTreeNode(newNode, this, filter));
                    continue;
                }
                this.children.add(new FilterTreeNode(newNode, this, filter.subList(1, filter.size())));
            }
        }

        public Enumeration<?> children() {
            return new Enumeration<Object>(){
                Iterator<FilterTreeNode> iter;
                {
                    this.iter = FilterTreeNode.this.children.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.iter.hasNext();
                }

                @Override
                public Object nextElement() {
                    return this.iter.next();
                }
            };
        }

        @Override
        public boolean getAllowsChildren() {
            return this.childNode.getAllowsChildren();
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.children.indexOf(node);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public TreeNode getRawNode() {
            return this.childNode;
        }

        @Override
        public void insert(MutableTreeNode childNode2, int index) {
            this.childNode.insert(childNode2, index);
            VariableFilterTreeModel.this.update();
        }

        @Override
        public void remove(int index) {
            this.childNode.remove(index);
            VariableFilterTreeModel.this.update();
        }

        @Override
        public void remove(MutableTreeNode childNode2) {
            this.childNode.remove(childNode2);
            VariableFilterTreeModel.this.update();
        }

        @Override
        public void removeFromParent() {
            this.childNode.removeFromParent();
            VariableFilterTreeModel.this.update();
        }

        @Override
        public void setParent(MutableTreeNode newParent) {
            this.childNode.setParent(newParent);
            VariableFilterTreeModel.this.update();
        }

        @Override
        public void setUserObject(Object object) {
            this.childNode.setUserObject(object);
        }

        public String toString() {
            return this.childNode.toString();
        }
    }
}

