/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer.gui.renderer;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.task.TaskState;
import ddb.dsz.plugin.logviewer.gui.renderer.CustomTableCellRenderer;
import ddb.imagemanager.ImageManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class StatusRenderer
extends CustomTableCellRenderer {
    private final ImageIcon RUN;
    private final ImageIcon PAUSE;
    private final ImageIcon SUCCESS;
    private final ImageIcon FAILURE;
    private final ImageIcon TASKED;
    private final ImageIcon KILLED;

    public StatusRenderer(CoreController core) {
        this.RUN = ImageManager.getIcon((String)"images/player_play.png", (Dimension)core.getLabelImageSize());
        this.PAUSE = ImageManager.getIcon((String)"images/player_pause.png", (Dimension)core.getLabelImageSize());
        this.SUCCESS = ImageManager.getIcon((String)"images/button_ok.png", (Dimension)core.getLabelImageSize());
        this.FAILURE = ImageManager.getIcon((String)"images/error.png", (Dimension)core.getLabelImageSize());
        this.TASKED = ImageManager.getIcon((String)"images/player_end.png", (Dimension)core.getLabelImageSize());
        this.KILLED = ImageManager.getIcon((String)"images/yellowled.png", (Dimension)core.getLabelImageSize());
    }

    protected Component modifyComponent(JLabel label, Object value) {
        if (value instanceof TaskState) {
            label.setText("");
            switch ((TaskState)TaskState.class.cast(value)) {
                case FAILED: {
                    label.setIcon(this.FAILURE);
                    break;
                }
                case KILLED: {
                    label.setIcon(this.KILLED);
                    break;
                }
                case PAUSED: {
                    label.setIcon(this.PAUSE);
                    break;
                }
                case RUNNING: {
                    label.setIcon(this.RUN);
                    break;
                }
                case SUCCEEDED: {
                    label.setIcon(this.SUCCESS);
                    break;
                }
                case TASKED: {
                    label.setIcon(this.TASKED);
                    break;
                }
                default: {
                    label.setIcon(null);
                }
            }
        }
        return label;
    }
}

