/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer.gui.screenlog;

import ddb.detach.Alignment;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.logviewer.gui.LogViewerDetachable;
import ddb.imagemanager.ImageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class LogViewPane
extends LogViewerDetachable {
    float size = 14.0f;
    File logFile;
    JTextArea pane = new JTextArea();
    JScrollPane scroller = new JScrollPane(this.pane);
    JTextField title = new JTextField();
    JToolBar menu = new JToolBar(0);
    CoreController core;

    public LogViewPane(CoreController core, File logFile) {
        this.logFile = logFile;
        this.core = core;
        super.setName(logFile.getName());
        super.setAlignment(Alignment.RIGHT);
        super.setShowButtons(true);
        super.setVerifyClose(false);
        this.title.setBorder(null);
        this.title.setEditable(false);
        this.title.setText(logFile.getAbsolutePath());
        this.pane.setEditable(false);
        this.update();
        this.display.setLayout(new BorderLayout());
        this.display.add((Component)this.scroller, "Center");
        this.display.add((Component)this.menu, "North");
        this.menu.add(new JLabel("Font Size:"));
        JButton increaseFont = new JButton("");
        increaseFont.addActionListener(new IncreaseAction());
        increaseFont.setToolTipText("Increase font size");
        increaseFont.setIcon(ImageManager.getIcon((String)"images/blue-plus.png", (Dimension)core.getLabelImageSize()));
        this.menu.add(increaseFont);
        JButton decreaseFont = new JButton("");
        decreaseFont.addActionListener(new DecreaseAction());
        decreaseFont.setToolTipText("Decrease font size");
        decreaseFont.setIcon(ImageManager.getIcon((String)"images/blue-minus.png", (Dimension)core.getLabelImageSize()));
        this.menu.add(decreaseFont);
    }

    void update() {
        long desiredLength;
        if (this.logFile == null) {
            return;
        }
        long currentLength = this.pane.getText().length();
        if (currentLength == (desiredLength = this.logFile.length())) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(this.logFile);
            fis.skip(currentLength);
            int read = 0;
            byte[] buffer = new byte[8096];
            while (read != -1) {
                this.pane.append(new String(buffer, 0, read));
                read = fis.read(buffer);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public boolean isClosable() {
        return true;
    }

    public JComponent getHeader() {
        return this.title;
    }

    private final class DecreaseAction
    implements ActionListener {
        private DecreaseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Font f = LogViewPane.this.pane.getFont().deriveFont(0, LogViewPane.this.size -= 1.0f);
            LogViewPane.this.pane.setFont(f);
        }
    }

    private final class IncreaseAction
    implements ActionListener {
        private IncreaseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Font f = LogViewPane.this.pane.getFont().deriveFont(0, LogViewPane.this.size += 1.0f);
            LogViewPane.this.pane.setFont(f);
        }
    }
}

