/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer.gui.target;

import ddb.detach.TabbableStatus;
import ddb.detach.Workbench;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.logviewer.LogViewer;
import ddb.dsz.plugin.logviewer.gui.LogViewerDetachable;
import ddb.dsz.plugin.logviewer.gui.detail.TaskDetail2;
import ddb.dsz.plugin.logviewer.gui.list.CommandListPane;
import ddb.dsz.plugin.logviewer.gui.target.TargetWorkspace;
import ddb.dsz.plugin.logviewer.models.CommandModel;
import ddb.dsz.plugin.multitarget.MultipleTargetPlugin;
import ddb.dsz.plugin.multitarget.SingleTargetImpl;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetLogspace
extends SingleTargetImpl {
    public static final String ALL = "All";
    private final Map<Task, TaskDetail2> taskToPane = new HashMap<Task, TaskDetail2>();
    final CommandListPane commandList;
    final TargetWorkspace workspace;
    final MultipleTargetPlugin parent;
    boolean ignoreHost = false;

    public TargetLogspace(HostInfo host, CoreController cc, MultipleTargetPlugin parent) {
        this(host, cc, parent, false);
    }

    public TargetLogspace(HostInfo host, CoreController cc, MultipleTargetPlugin parent, boolean invalid) {
        super(host, cc);
        this.parent = parent;
        this.workspace = new TargetWorkspace(cc.getSystemLogger(), this, 1);
        super.setDisplay((JComponent)((Object)this.workspace));
        String hostName = "all connections";
        if (host != null) {
            hostName = host.isLocal() ? "Localhost" : String.format("host %s", host.getId());
        }
        this.commandList = new CommandListPane(hostName, new CommandModel(), this, cc, host != null ? host.isLocal() : false, invalid);
        this.workspace.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{this.commandList});
    }

    public void parseTask(Task task) {
        this.commandList.parseTask(task);
    }

    public void addCommandName(String name, Boolean selected) {
        this.commandList.addCommandName(name, selected);
    }

    public void setOperation(Operation operation) {
        this.commandList.setOperation(operation);
    }

    public JComponent getHeader() {
        return null;
    }

    public TabbableStatus getStatus() {
        return this.workspace.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTask(final Task t, final String display, final String storage) {
        TaskDetail2 td;
        if (t == null) {
            return;
        }
        if (t.getDataCount() == 0 && t.getTaskingAccess() == null && t.getTaskLogAccess() == null) {
            return;
        }
        if (t.getResourceDirectory() == null) {
            this.core.schedule(new Runnable(){

                public void run() {
                    if (t.getResourceDirectory() == null) {
                        TargetLogspace.this.core.schedule((Runnable)this, 1L, TimeUnit.SECONDS);
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                TargetLogspace.this.loadTask(t, display, storage);
                            }
                        });
                    }
                }
            }, 1L, TimeUnit.SECONDS);
            return;
        }
        boolean add = false;
        Object object = this.taskToPane;
        synchronized (object) {
            td = this.taskToPane.get(t);
            if (td == null) {
                add = true;
                try {
                    boolean isDev = false;
                    int maxChar = 1000000;
                    if (this.parent instanceof LogViewer) {
                        isDev = ((LogViewer)((Object)LogViewer.class.cast(this.parent))).isDeveloperMode();
                        maxChar = ((LogViewer)((Object)LogViewer.class.cast(this.parent))).getMaxCharacters();
                    }
                    td = new TaskDetail2(t, this.core, this, isDev, display, storage);
                    td.setMaxCharacters(maxChar);
                }
                catch (Throwable e) {
                    this.core.logEvent(Level.SEVERE, "Unable to load " + t.getId() + " in detail", e);
                    return;
                }
                this.taskToPane.put(t, td);
            }
        }
        if (add) {
            this.workspace.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{td});
            this.core.logEvent(Level.FINER, "Loading task " + t.getId() + " in a detail pane");
        } else {
            object = this.workspace;
            synchronized (object) {
                boolean found = false;
                for (Component c : this.workspace.getComponents()) {
                    if (!c.equals(td.getDisplay())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    if (td.getFrame() != null && td.getFrame().isVisible()) {
                        td.getFrame().toFront();
                        return;
                    }
                    this.workspace.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{td});
                }
            }
        }
        this.workspace.enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDTAB, new Object[]{td});
    }

    public void release(LogViewerDetachable lvd) {
        this.workspace.enqueAction((Enum)Workbench.WorkbenchAction.REMOVETAB, new Object[]{lvd});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(LogViewerDetachable lvd) {
        Map<Task, TaskDetail2> map = this.taskToPane;
        synchronized (map) {
            for (Task t : this.taskToPane.keySet()) {
                if (lvd != this.taskToPane.get(t)) continue;
                this.taskToPane.remove(t);
                lvd.close();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fini2() {
        Map<Task, TaskDetail2> map = this.taskToPane;
        synchronized (map) {
            for (TaskDetail2 td2 : this.taskToPane.values()) {
                td2.close();
            }
            this.taskToPane.clear();
        }
        this.commandList.fini();
    }

    public void showInvalidOnly(boolean showInvalid) {
        this.commandList.showInvalidOnly(showInvalid);
    }

    public void commandEventReceived(CommandEvent event) {
        HostInfo hi;
        Task t = this.core.getTaskById(event.getId());
        if (t == null) {
            return;
        }
        if (!this.ignoreHost && (hi = t.getHost()) == null) {
            return;
        }
        this.commandList.parseTask(t);
        super.commandEventReceived(event);
    }

    public void addTasks(Collection<Task> tasks) {
        for (Task t : tasks) {
            this.commandList.parseTask(t);
        }
    }

    public String toString() {
        return String.format("Logs: %s", this.target != null ? this.target.getId() : this.getName());
    }

    public void setIgnoreHost(boolean val) {
        this.ignoreHost = val;
    }
}

