/*
 * Decompiled with CFR 0.152.
 */
package ddb.web.util;

import ddb.web.util.HTMLColor;
import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class HTMLUtils {
    public static final String classVersion = "5.5";
    public static final String BREAK = "<br>";
    public static final String SEPARATOR = System.getProperty("line.separator");
    public static final String WRAP_DELIMITERS = "\t\n\r ";
    public static final String EOLN_DELIMITERS = "\n\r";
    protected static final String[] names = new String[256];
    protected static final Map<Object, Object> rgbColorStrings;

    private HTMLUtils() {
    }

    public static String decodeURL(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String encodeURL(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String escapeText(String text) {
        char[] buffer = text.toCharArray();
        StringBuffer result = new StringBuffer();
        boolean space = false;
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == ' ') {
                if (space) {
                    result.append("&nbsp;");
                    continue;
                }
                space = true;
                result.append(buffer[i]);
                continue;
            }
            space = false;
            String name = names[buffer[i]];
            if (name == null) {
                result.append(buffer[i]);
                continue;
            }
            result.append(name);
        }
        return result.toString();
    }

    public static String toHTML(Color color) {
        return HTMLColor.toHTML(color);
    }

    public static StringBuffer toPreHTMLText(String text, int maxLineLength) {
        char[] buffer = text.toCharArray();
        StringBuffer result = new StringBuffer();
        StringBuffer line = new StringBuffer();
        StringBuffer link = null;
        int offset = 0;
        int lastSpace = -1;
        int count = 0;
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == ' ') {
                lastSpace = count;
            } else if (buffer[i] == 'h' && i + 6 < buffer.length && buffer[i + 1] == 't' && buffer[i + 2] == 't' && buffer[i + 3] == 'p' && buffer[i + 4] == ':' && buffer[i + 5] == '/' && buffer[i + 6] == '/') {
                link = new StringBuffer();
                line.append("<A HREF=\"");
            }
            if (link != null && (buffer[i] == ' ' || buffer[i] == '\r' || buffer[i] == '\n')) {
                line.append("\">");
                line.append(link);
                line.append("</A>");
                link = null;
            }
            line.append(buffer[i]);
            ++count;
            if (link != null) {
                link.append(buffer[i]);
            }
            if (buffer[i] == '\r' || buffer[i] == '\n') {
                lastSpace = -1;
                count = 0;
                result.append(line);
                line = new StringBuffer();
                offset = 0;
                continue;
            }
            if (count + offset != maxLineLength) continue;
            if (lastSpace >= 0) {
                line.insert(lastSpace + 1, SEPARATOR);
                offset = maxLineLength - (lastSpace + offset);
                lastSpace = -1;
                count = 0;
                result.append(line);
                line = new StringBuffer();
                continue;
            }
            if (link != null) continue;
            line.append(SEPARATOR);
            offset = 0;
            lastSpace = -1;
            count = 0;
            result.append(line);
            line = new StringBuffer();
        }
        if (line != null) {
            result.append(line);
            if (link != null) {
                result.append("\">");
                result.append(link);
                result.append("</A>");
            }
        }
        return result;
    }

    public static String unescapeText(String text) {
        char[] buffer = text.toCharArray();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < buffer.length; ++i) {
            char ch;
            block7: {
                ch = buffer[i];
                if (buffer[i] == '&') {
                    try {
                        int end = text.indexOf(59, i);
                        if (end == -1) break block7;
                        String name = text.substring(i, end + 1);
                        if (name.charAt(1) == '#') {
                            name = text.substring(i + 2, end);
                            ch = (char)Integer.parseInt(name);
                            i = end;
                            break block7;
                        }
                        for (int j = 0; j < names.length; ++j) {
                            if (!name.equals(names[j])) continue;
                            ch = (char)j;
                            i = end;
                            break;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String wrapText(String text, int column) {
        int minLineWidth = column / 2;
        String token = null;
        boolean firstLine = true;
        boolean continuation = false;
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(text, EOLN_DELIMITERS);
        while (st.hasMoreTokens() || continuation) {
            int numChars;
            if (!continuation) {
                token = st.nextToken();
            }
            if ((numChars = token.length()) > 0) {
                int maxNumChars = column;
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append(BREAK);
                }
                if (numChars > maxNumChars) {
                    for (numChars = maxNumChars; WRAP_DELIMITERS.indexOf(token.charAt(numChars)) == -1 && numChars > minLineWidth; --numChars) {
                    }
                    if (numChars == minLineWidth && WRAP_DELIMITERS.indexOf(token.charAt(numChars)) == -1) {
                        numChars = maxNumChars;
                    }
                    String partialLine = token.substring(numChars);
                    token = token.substring(0, numChars).trim();
                    sb.append(token);
                    token = partialLine.trim();
                    continuation = token.length() > 0;
                    continue;
                }
                sb.append(token);
                continuation = false;
                continue;
            }
            continuation = false;
        }
        return sb.toString();
    }

    static {
        HTMLUtils.names[34] = "&quot;";
        HTMLUtils.names[38] = "&amp;";
        HTMLUtils.names[60] = "&lt;";
        HTMLUtils.names[62] = "&gt;";
        HTMLUtils.names[160] = "&nbsp;";
        HTMLUtils.names[161] = "&iexcl;";
        HTMLUtils.names[162] = "&cent;";
        HTMLUtils.names[163] = "&pound;";
        HTMLUtils.names[164] = "&curren;";
        HTMLUtils.names[165] = "&yen;";
        HTMLUtils.names[166] = "&brvbar;";
        HTMLUtils.names[167] = "&sect;";
        HTMLUtils.names[168] = "&uml;";
        HTMLUtils.names[169] = "&copy;";
        HTMLUtils.names[170] = "&ordf;";
        HTMLUtils.names[171] = "&laquo;";
        HTMLUtils.names[172] = "&not;";
        HTMLUtils.names[173] = "&shy;";
        HTMLUtils.names[174] = "&reg;";
        HTMLUtils.names[175] = "&macr;";
        HTMLUtils.names[176] = "&deg;";
        HTMLUtils.names[177] = "&plusmn;";
        HTMLUtils.names[178] = "&sup2;";
        HTMLUtils.names[179] = "&sup3;";
        HTMLUtils.names[180] = "&acute;";
        HTMLUtils.names[181] = "&micro;";
        HTMLUtils.names[182] = "&para;";
        HTMLUtils.names[183] = "&middot;";
        HTMLUtils.names[184] = "&cedil;";
        HTMLUtils.names[185] = "&sup1;";
        HTMLUtils.names[186] = "&ordm;";
        HTMLUtils.names[187] = "&raquo;";
        HTMLUtils.names[188] = "&frac14;";
        HTMLUtils.names[189] = "&frac12;";
        HTMLUtils.names[190] = "&frac34;";
        HTMLUtils.names[191] = "&iquest;";
        HTMLUtils.names[192] = "&Agrave;";
        HTMLUtils.names[193] = "&Aacute;";
        HTMLUtils.names[194] = "&Acirc;";
        HTMLUtils.names[195] = "&Atilde;";
        HTMLUtils.names[196] = "&Auml;";
        HTMLUtils.names[197] = "&Aring;";
        HTMLUtils.names[198] = "&AElig;";
        HTMLUtils.names[199] = "&Ccedil;";
        HTMLUtils.names[200] = "&Egrave;";
        HTMLUtils.names[201] = "&Eacute;";
        HTMLUtils.names[202] = "&Ecirc;";
        HTMLUtils.names[203] = "&Euml;";
        HTMLUtils.names[204] = "&Igrave;";
        HTMLUtils.names[205] = "&Iacute;";
        HTMLUtils.names[206] = "&Icirc;";
        HTMLUtils.names[207] = "&Iuml;";
        HTMLUtils.names[208] = "&ETH;";
        HTMLUtils.names[209] = "&Ntilde;";
        HTMLUtils.names[210] = "&Ograve;";
        HTMLUtils.names[211] = "&Oacute;";
        HTMLUtils.names[212] = "&Ocirc;";
        HTMLUtils.names[213] = "&Otilde;";
        HTMLUtils.names[214] = "&Ouml;";
        HTMLUtils.names[215] = "&times;";
        HTMLUtils.names[216] = "&Oslash;";
        HTMLUtils.names[217] = "&Ugrave;";
        HTMLUtils.names[218] = "&Uacute;";
        HTMLUtils.names[219] = "&Ucirc;";
        HTMLUtils.names[220] = "&Uuml;";
        HTMLUtils.names[221] = "&Yacute;";
        HTMLUtils.names[222] = "&THORN;";
        HTMLUtils.names[223] = "&szlig;";
        HTMLUtils.names[224] = "&agrave;";
        HTMLUtils.names[225] = "&aacute;";
        HTMLUtils.names[226] = "&acirc;";
        HTMLUtils.names[227] = "&atilde;";
        HTMLUtils.names[228] = "&auml;";
        HTMLUtils.names[229] = "&aring;";
        HTMLUtils.names[230] = "&aelig;";
        HTMLUtils.names[231] = "&ccedil;";
        HTMLUtils.names[232] = "&egrave;";
        HTMLUtils.names[233] = "&eacute;";
        HTMLUtils.names[234] = "&ecirc;";
        HTMLUtils.names[235] = "&euml;";
        HTMLUtils.names[236] = "&igrave;";
        HTMLUtils.names[237] = "&iacute;";
        HTMLUtils.names[238] = "&icirc;";
        HTMLUtils.names[239] = "&iuml;";
        HTMLUtils.names[240] = "&eth;";
        HTMLUtils.names[241] = "&ntilde;";
        HTMLUtils.names[242] = "&ograve;";
        HTMLUtils.names[243] = "&oacute;";
        HTMLUtils.names[244] = "&ocirc;";
        HTMLUtils.names[245] = "&otilde;";
        HTMLUtils.names[246] = "&ouml;";
        HTMLUtils.names[247] = "&divide;";
        HTMLUtils.names[248] = "&oslash;";
        HTMLUtils.names[249] = "&ugrave;";
        HTMLUtils.names[250] = "&uacute;";
        HTMLUtils.names[251] = "&ucirc;";
        HTMLUtils.names[252] = "&uuml;";
        HTMLUtils.names[253] = "&yacute;";
        HTMLUtils.names[254] = "&thorn;";
        HTMLUtils.names[255] = "&yuml;";
        rgbColorStrings = new HashMap<Object, Object>();
    }
}

