/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import ddb.dsz.core.controller.CoreController;
import ddb.util.JaxbCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientSocketHandler {
    private boolean stop = false;
    Socket socket;
    CoreController core;
    Unmarshaller unmarsh;
    Marshaller marsh;
    Long received = 0L;
    Long sent = 0L;
    Logger transactionLogger;
    protected BlockingQueue<JAXBElement<?>> pendingWrites = new LinkedBlockingQueue(10);
    protected BlockingQueue<Object> pendingReads = new LinkedBlockingQueue<Object>();
    Closure handleNewMessage;
    static final Charset utf8 = Charset.forName("Utf-8");
    final Runnable forwarder = new Runnable(){

        public void run() {
            while (!ClientSocketHandler.this.stop) {
                Object object = null;
                try {
                    object = ClientSocketHandler.this.pendingReads.poll(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    ClientSocketHandler.this.core.logEvent(Level.INFO, interruptedException.getMessage(), (Throwable)interruptedException);
                }
                if (object == null) continue;
                ClientSocketHandler.this.handleNewMessage.execute(object);
            }
        }
    };
    final Runnable writer = new Runnable(){
        BufferedOutputStream bos;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.bos = new BufferedOutputStream(ClientSocketHandler.this.socket.getOutputStream());
            }
            catch (IOException iOException) {
                ClientSocketHandler.this.core.logEvent(Level.SEVERE, iOException.getMessage(), (Throwable)iOException);
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                JAXBElement<?> jAXBElement;
                while (!ClientSocketHandler.this.stop) {
                    jAXBElement = null;
                    try {
                        jAXBElement = ClientSocketHandler.this.pendingWrites.poll(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        ClientSocketHandler.this.core.logEvent(Level.INFO, interruptedException.getMessage(), (Throwable)interruptedException);
                    }
                    if (jAXBElement == null) continue;
                    ClientSocketHandler.this.outgoingItem(jAXBElement);
                    byteArrayOutputStream.reset();
                    ClientSocketHandler.this.marsh.marshal(jAXBElement, (OutputStream)byteArrayOutputStream);
                    ClientSocketHandler.this.sent = ClientSocketHandler.this.sent + (long)byteArrayOutputStream.size();
                    this.bos.write(byteArrayOutputStream.toByteArray());
                    this.bos.write(1);
                    this.bos.flush();
                }
                jAXBElement = this;
                synchronized (jAXBElement) {
                    this.notifyAll();
                }
            }
            catch (SocketException socketException) {
            }
            catch (Exception exception) {
                ClientSocketHandler.this.core.logEvent(Level.SEVERE, exception.getMessage(), (Throwable)exception);
            }
            ClientSocketHandler.this.stop();
        }
    };
    final Runnable reader = new Runnable(){
        BufferedInputStream bufInStream;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object;
                this.bufInStream = new BufferedInputStream(ClientSocketHandler.this.socket.getInputStream());
                StringBuilder stringBuilder = new StringBuilder();
                while (!ClientSocketHandler.this.stop) {
                    object = new byte[8096];
                    int n = this.bufInStream.read((byte[])object);
                    if (n == -1) {
                        this.bufInStream.close();
                        ClientSocketHandler.this.stop();
                        return;
                    }
                    ClientSocketHandler.this.received = ClientSocketHandler.this.received + (long)n;
                    for (int i = 0; i < n; ++i) {
                        if (object[i] != 1) continue;
                        stringBuilder.append(new String((byte[])object, 0, i, utf8));
                        try {
                            ClientSocketHandler.this.incomingItem(ClientSocketHandler.this.unmarsh.unmarshal((Reader)new StringReader(stringBuilder.toString())));
                        }
                        catch (JAXBException jAXBException) {
                            ClientSocketHandler.this.core.logEvent(Level.WARNING, jAXBException.getMessage(), (Throwable)jAXBException);
                        }
                        n -= i + 1;
                        object = Arrays.copyOfRange(object, i + 1, ((byte[])object).length);
                        i = 0;
                        stringBuilder.setLength(0);
                    }
                    stringBuilder.append(new String((byte[])object, 0, n));
                }
                3 v0 = this;
                object = v0;
                synchronized (v0) {
                    this.notifyAll();
                    // ** MonitorExit[var2_4 /* !! */ ] (shouldn't be in output)
                }
            }
            catch (SocketException socketException) {
            }
            catch (Exception exception) {
                ClientSocketHandler.this.core.logEvent(Level.SEVERE, exception.getMessage(), (Throwable)exception);
            }
            {
                ClientSocketHandler.this.stop();
                return;
            }
        }
    };

    public Marshaller getMarshaller() {
        return this.marsh;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarsh;
    }

    protected void incomingItem(Object object) {
        this.pendingReads.offer(object);
    }

    protected void outgoingItem(Object object) {
    }

    public ClientSocketHandler(CoreController coreController, Socket socket, Class<?> clazz, Closure closure) throws JAXBException {
        this.core = coreController;
        this.socket = socket;
        this.handleNewMessage = closure;
        JAXBContext jAXBContext = JaxbCache.getContext(clazz);
        this.unmarsh = jAXBContext.createUnmarshaller();
        this.marsh = jAXBContext.createMarshaller();
        try {
            this.marsh.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.marsh.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
    }

    public void start() {
        Thread[] threadArray = new Thread[]{this.core.newThread(this.writer), this.core.newThread(this.reader), this.core.newThread(this.forwarder)};
        threadArray[0].setName(String.format("%s: Writer", this.getName()));
        threadArray[1].setName(String.format("%s: Reader", this.getName()));
        threadArray[2].setName(String.format("%s: Forwarder", this.getName()));
        for (Thread thread : threadArray) {
            thread.start();
        }
    }

    public abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.stop = true;
            Runnable runnable = this.writer;
            synchronized (runnable) {
                this.writer.wait(10000L);
            }
            runnable = this.reader;
            synchronized (runnable) {
                this.reader.wait(10000L);
            }
            runnable = this.forwarder;
            synchronized (runnable) {
                this.forwarder.wait(10000L);
            }
            this.socket.close();
        }
        catch (Exception exception) {
            this.core.logEvent(Level.WARNING, exception.getMessage(), (Throwable)exception);
        }
    }

    public void publish(JAXBElement<?> jAXBElement) {
        try {
            this.pendingWrites.put(jAXBElement);
        }
        catch (InterruptedException interruptedException) {
            this.core.logEvent(Level.WARNING, null, (Throwable)interruptedException);
        }
    }

    public boolean isConnected() {
        return !this.stop;
    }

    public Long getSent() {
        return this.sent;
    }

    public Long getReceived() {
        return this.received;
    }

    public Socket getSocket() {
        return this.socket;
    }

    protected void setClosure(Closure closure) {
        this.handleNewMessage = closure;
    }
}

