/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher.live;

import ddb.dsz.core.operation.Operation;
import ddb.util.Guid;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.core.commanddispatcher.live.MessageClosure;
import ds.core.impl.OperationImpl;
import ds.jaxb.ipc.ConnectionInfoType;
import ds.jaxb.ipc.Message;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;

public class ConnectionInfoClosure
extends MessageClosure {
    public ConnectionInfoClosure(LiveCommandDispatcher liveCommandDispatcher) {
        super(liveCommandDispatcher);
    }

    protected boolean evaluateMessage(Message message) {
        if (message.getInfo() == null) {
            return false;
        }
        return message.getInfo().getConnectionInfo() != null;
    }

    protected void handleMessage(Message message) {
        ConnectionInfoType connectionInfoType = message.getInfo().getConnectionInfo();
        if (this.live.getMainSystem().isDebugMode()) {
            this.live.getMainSystem().logEvent(Level.FINEST, "Recieved connection info message");
        }
        if (Operation.NULL.equals(this.live.getOperation()) && connectionInfoType.getHost().size() > 0) {
            try {
                Guid guid = Guid.GenerateGuid((String)connectionInfoType.getHost().get(0).getGUID());
                OperationImpl operationImpl = OperationImpl.GenerateOperation(guid, Calendar.getInstance(TimeZone.getTimeZone("GMT")));
                this.live.setOperation(operationImpl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.live.getMainSystem().updateConnectionInfo(message);
    }
}

