/*
 * Decompiled with CFR 0.152.
 */
package ds.gui;

import ddb.detach.Alignment;
import ddb.detach.Tabbable;
import ddb.detach.TabbableFrame;
import ddb.detach.TabbablePopupListener;
import ddb.detach.Workbench;
import ddb.dsz.core.command.CommandEventListener;
import ddb.dsz.core.connection.ConnectionChangeListener;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.internalcommand.InternalCommandHandler;
import ddb.dsz.plugin.Plugin;
import ddb.imagemanager.ImageManager;
import ddb.util.JaxbCache;
import ddb.util.proxy.DszProxyHandler;
import ds.core.DSConstants;
import ds.gui.PluginFrame;
import ds.gui.PluginPopupListener;
import ds.gui.PluginWorkbenchPopupMenu;
import ds.jaxb.module.Module;
import ds.jaxb.module.ObjectFactory;
import ds.plugin.PluginContainer;
import ds.plugin.options.DszOptions;
import ds.plugin.pluginmanagement.PluginManager;
import ds.proxy.PluginProxyHandler;
import ds.proxy.QueuedInvocationHandler;
import ds.util.DszWorkbench;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginWorkbench
extends DszWorkbench
implements ChangeListener {
    protected final Object lock = new Object();
    private PluginPopupListener pluginListener;
    private PluginManager manager;
    private List<Plugin> runningPlugins;
    private DefaultListModel localModel;
    private List<JMenuItem> menus;
    private List<ModuleMetaData> plugins;
    private CoreController core;
    private PluginWorkbench parent = null;
    private Map<String, Integer> pluginNameCount = new Hashtable<String, Integer>();

    public List<JMenuItem> getNewInstance() {
        return this.menus;
    }

    public PluginWorkbench(CoreController coreController, PluginWorkbench pluginWorkbench) {
        super(coreController.getSystemLogger(), DSConstants.MAIN_TAB_ALIGNMENT);
        this.initialize(coreController, pluginWorkbench);
    }

    public PluginWorkbench(CoreController coreController, PluginWorkbench pluginWorkbench, int n) {
        super(coreController.getSystemLogger(), n);
        this.initialize(coreController, pluginWorkbench);
    }

    public PluginWorkbench(CoreController coreController, PluginWorkbench pluginWorkbench, int n, int n2) {
        super(coreController.getSystemLogger(), n, n2);
        this.initialize(coreController, pluginWorkbench);
    }

    protected TabbableFrame generateTabFrame(Tabbable tabbable, Dimension dimension, Point point) {
        return new PluginFrame(tabbable, this, dimension, point, this.core);
    }

    private void initialize(CoreController coreController, PluginWorkbench pluginWorkbench) {
        this.actionHandler.put(Workbench.WorkbenchAction.HIDETAB, HideTab.class);
        this.actionHandler.put(Workbench.WorkbenchAction.CLOSETAB, CloseTab.class);
        this.actionHandler.put(Workbench.WorkbenchAction.UNHIDETAB, UnhideTab.class);
        this.actionHandler.put(Workbench.WorkbenchAction.DETACHTAB, DetachTab.class);
        this.actionHandler.put(Workbench.WorkbenchAction.PREDETACHTAB, PredetachTab.class);
        this.actionHandler.put(Workbench.WorkbenchAction.TABBIFYTAB, TabbifyTab.class);
        this.actionHandler.put(Workbench.WorkbenchAction.RENAMETAB, RenameTab.class);
        this.actionHandler.put(Workbench.WorkbenchAction.SETSELECTEDTAB, SetSelectedTab.class);
        this.actionHandler.put(Workbench.WorkbenchAction.STEALFOCUS, StealFocus.class);
        this.actionHandler.put(Workbench.WorkbenchAction.SETSTATE, SetState.class);
        this.actionHandler.put(PluginWorkbenchAction.STOPPLUGIN, StopPlugin.class);
        this.actionHandler.put(PluginWorkbenchAction.DETACHPLUGIN, DetachPlugin.class);
        this.actionHandler.put(PluginWorkbenchAction.PREDETACHPLUGIN, PredetachPlugin.class);
        if (this.pluginListener == null) {
            this.pluginListener = new PluginPopupListener(this);
        }
        this.pluginListener.setCoreController(coreController);
        this.core = coreController;
        this.parent = pluginWorkbench;
        this.localModel = new DefaultListModel();
        this.runningPlugins = new Vector<Plugin>();
        this.menus = new Vector<JMenuItem>();
        this.plugins = new Vector<ModuleMetaData>();
        this.setupMenu();
        this.addChangeListener(this);
    }

    private List<ModuleMetaData> getPluginsViaXml(String string) {
        Unmarshaller unmarshaller;
        Object object;
        Vector<ModuleMetaData> vector = new Vector<ModuleMetaData>();
        try {
            object = JaxbCache.getContext(ObjectFactory.class);
            unmarshaller = object.createUnmarshaller();
        }
        catch (Exception exception) {
            this.core.logEvent(Level.SEVERE, "Unable to find plugins!", (Throwable)exception);
            return vector;
        }
        object = new Vector();
        object.add(new File(this.core.getResourceDirectory()));
        object.addAll(Arrays.asList(new File(this.core.getResourceDirectory()).listFiles()));
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            File file;
            File file2 = (File)iterator.next();
            if (!file2.isDirectory() || !(file = new File(file2, string)).exists() || !file.isDirectory()) continue;
            for (File file3 : file.listFiles()) {
                if (file3.isDirectory()) continue;
                try {
                    Object object2 = unmarshaller.unmarshal(file3);
                    if (object2 instanceof Module) {
                        vector.add(new ModuleMetaData((Module)object2, file2.getName()));
                        continue;
                    }
                    if (object2 instanceof JAXBElement) {
                        JAXBElement jAXBElement = (JAXBElement)object2;
                        if (!(jAXBElement.getValue() instanceof Module)) continue;
                        vector.add(new ModuleMetaData((Module)jAXBElement.getValue(), file2.getName()));
                        continue;
                    }
                    System.err.println("Invalid: " + file3.getName());
                }
                catch (Exception exception) {
                    System.err.println("Error: " + file3.getName());
                    this.core.logEvent(Level.INFO, "Invalid plugin description: " + file3.getName(), (Throwable)exception);
                }
            }
        }
        return vector;
    }

    private void setupMenu() {
        this.plugins.addAll(this.getPluginsViaXml("/Gui/Config/Modules"));
        this.plugins.addAll(this.getPluginsViaXml("/Gui/Config/Macros"));
        Collections.sort(this.plugins, new Comparator<ModuleMetaData>(){

            @Override
            public int compare(ModuleMetaData moduleMetaData, ModuleMetaData moduleMetaData2) {
                return moduleMetaData.module.getName().compareTo(moduleMetaData2.module.getName());
            }
        });
        JMenu jMenu = new JMenu("Plugins");
        this.iterateAndAdd(this.plugins.iterator(), jMenu);
        jMenu.setIcon(ImageManager.getIcon((String)"images/new window.png", (Dimension)this.core.getLabelImageSize()));
        this.menus.add(jMenu);
    }

    private void iterateAndAdd(Iterator<ModuleMetaData> iterator, JMenu jMenu) {
        while (iterator.hasNext()) {
            String string;
            final ModuleMetaData moduleMetaData = iterator.next();
            final Module module = moduleMetaData.module;
            if (!module.isUserStartable() || (!this.core.isLiveOperation() ? !module.isReplay() : !module.isLive())) continue;
            final JMenuItem jMenuItem = moduleMetaData.project.equals("Dsz") || moduleMetaData.project.equals("Resources") || moduleMetaData.project.equals(".") ? new JMenuItem(module.getName()) : new JMenuItem(String.format("%s (%s)", module.getName(), moduleMetaData.project));
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PluginWorkbench.this.core.submit(new Runnable(){

                        public void run() {
                            try {
                                Plugin plugin = PluginWorkbench.this.startPlugin(Class.forName(module.getClazz(), false, DSConstants.getClassLoader()), module.getName(), module.getInitArgs(), Alignment.CENTER, null);
                                plugin.setLogo(module.getLogo());
                                PluginWorkbench.this.enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDTAB, new Object[]{plugin});
                                PluginWorkbench.this.setIconAt(PluginWorkbench.this.indexOfComponent(plugin.getDisplay()), ImageManager.getIcon((String)module.getLogo(), (Dimension)PluginWorkbench.this.core.getTabImageSize()));
                            }
                            catch (Exception exception) {
                                PluginWorkbench.this.core.logEvent(Level.WARNING, "Unable to create new plugin", (Throwable)exception);
                            }
                        }
                    });
                }
            };
            jMenuItem.addActionListener(abstractAction);
            jMenu.addMenuListener(new MenuListener(){
                final Class<?> clazz;
                {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(moduleMetaData.module.getClazz());
                    }
                    catch (Throwable throwable) {
                        System.err.println("Failed to load " + moduleMetaData.module.getClazz());
                        throwable.printStackTrace();
                    }
                    this.clazz = clazz;
                }

                public void menuSelected(MenuEvent menuEvent) {
                    jMenuItem.setVisible(PluginWorkbench.this.core.allowNewInstance(this.clazz));
                }

                public void menuDeselected(MenuEvent menuEvent) {
                }

                public void menuCanceled(MenuEvent menuEvent) {
                }
            });
            String string2 = module.getLogo();
            if (string2 != null) {
                jMenuItem.setIcon(ImageManager.getIcon((String)string2, (Dimension)this.core.getLabelImageSize()));
            }
            if ((string = module.getDescription()) != null) {
                jMenuItem.setToolTipText(string);
            }
            jMenu.add(jMenuItem);
        }
    }

    protected final void configuredStartedPlugin(Class<?> clazz, Plugin plugin) {
        Module module = null;
        for (ModuleMetaData moduleMetaData : this.plugins) {
            if (!moduleMetaData.module.getClazz().equals(plugin.getClazz()) || moduleMetaData.module.isMacro()) continue;
            module = moduleMetaData.module;
        }
        if (module == null) {
            return;
        }
        plugin.setName(module.getName());
        plugin.setShortDescription(module.getDescription());
        plugin.setLogo(module.getLogo(), this.getTabImageSize());
        plugin.setHideable(module.isHide());
        plugin.setUnhideable(module.isUnhide());
        plugin.setDetachable(module.isDetach());
        plugin.setUserClosable(module.isUserClose());
        plugin.setCanClose(module.isCanClose());
        plugin.setVerifyClose(module.isVerifyClose());
    }

    public Plugin startPlugin(Class<?> clazz, String string, List<String> list, Alignment alignment, String string2) throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException {
        return this.startPlugin(clazz, string, list, alignment, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin startPlugin(Class<?> clazz, String string, List<String> list, Alignment alignment, String string2, boolean bl) throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException {
        if (!this.core.allowNewInstance(clazz)) {
            this.core.logEvent(Level.WARNING, "Request for multiple plugins of type " + clazz.getName());
            throw new InstantiationException("Existing plugin of class " + clazz.getName() + " forbids multiple instantiations");
        }
        this.core.logEvent(Level.FINEST, "Starting New Plugin - " + clazz.getName());
        Plugin plugin = QueuedInvocationHandler.newInstance(PluginProxyHandler.newInstance((Plugin)clazz.newInstance(), this.core));
        this.configuredStartedPlugin(clazz, plugin);
        plugin.setAlignment(alignment);
        plugin.setWorkbench((Workbench)this);
        Integer n = this.pluginNameCount.get(string);
        if (n == null) {
            n = 0;
        }
        n = n + 1;
        this.pluginNameCount.put(string, n);
        if (bl && n > 1) {
            string = String.format("%s %d", string, n);
        }
        if (string != null) {
            plugin.setName(string);
        }
        if (string2 != null) {
            plugin.setLogo(string2);
        }
        int n2 = -1;
        try {
            n2 = plugin.init(this.core, (JComponent)((Object)this), list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.core.logEvent(Level.WARNING, "Could not init plugin", (Throwable)exception);
            throw new InstantiationException("Exception during " + clazz.getName() + " plugin init");
        }
        if (n2 != 0) {
            this.core.logEvent(Level.WARNING, "Plugin " + clazz.getName() + " indicated failure during init.  Discontinuing plugin load.");
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            this.runningPlugins.add(plugin);
            this.localModel.addElement(plugin);
            this.invokeAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{plugin});
            this.core.addCommandEventListener((CommandEventListener)plugin);
            this.core.addConnectionChangeListener((ConnectionChangeListener)plugin);
            this.core.addInternalCommandHandler((InternalCommandHandler)plugin);
        }
        this.core.pluginStarted(plugin);
        return plugin;
    }

    public Plugin startPlugin(Class<?> clazz, String string, List<String> list, String string2, String string3) throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException {
        return this.startPlugin(clazz, string, list, Alignment.getAlignment((String)string2), string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllPlugins() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PluginWorkbench.this.stopAllPlugins();
                        try {
                            cyclicBarrier.await();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                cyclicBarrier.await();
                while (this.runningPlugins.size() > 0) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        this.core.logEvent(Level.FINEST, "Stopping all plugins");
        Object object = this.lock;
        synchronized (object) {
            for (int i = this.runningPlugins.size() - 1; i >= 0; --i) {
                this.invokeAction(PluginWorkbenchAction.STOPPLUGIN, new Object[]{this.runningPlugins.get(i)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewInstance(Class<?> clazz) {
        Object object = this.lock;
        synchronized (object) {
            for (Plugin plugin : this.runningPlugins) {
                if (plugin.allowNewInstance(clazz)) continue;
                return false;
            }
        }
        return true;
    }

    public JPopupMenu getMenu() {
        return new PluginWorkbenchPopupMenu(this);
    }

    public DefaultListModel getChildPlugins() {
        return this.localModel;
    }

    public void showRunningPluginsList() {
        try {
            if (this.manager == null) {
                Plugin plugin = this.startPlugin(PluginManager.class, "Running Plugins", new Vector<String>(), Alignment.RIGHT, null);
                if (plugin instanceof PluginManager) {
                    this.manager = (PluginManager)plugin;
                    this.enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDTAB, new Object[]{this.manager});
                } else {
                    this.enqueAction(PluginWorkbenchAction.STOPPLUGIN, new Object[]{plugin});
                }
            } else {
                this.enqueAction((Enum)Workbench.WorkbenchAction.UNHIDETAB, new Object[]{this.manager});
                this.enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDTAB, new Object[]{this.manager});
            }
        }
        catch (Exception exception) {
            this.core.logEvent(Level.SEVERE, "Unable to display running plugins", (Throwable)exception);
        }
    }

    public TabbablePopupListener getTabPopupListener() {
        if (this.pluginListener == null) {
            this.pluginListener = new PluginPopupListener(this);
        }
        return this.pluginListener;
    }

    public PluginWorkbench getHighestWorkbench() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getHighestWorkbench();
    }

    public void showOptions(Plugin plugin) {
        if (this.parent != null) {
            this.parent.showOptions(plugin);
        } else {
            Tabbable tabbable = super.getTabbableByClass(DszOptions.class);
            if (tabbable instanceof DszOptions) {
                DszOptions dszOptions = (DszOptions)DszOptions.class.cast(tabbable);
                this.enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDTAB, new Object[]{dszOptions});
                dszOptions.setSelectedOption(plugin);
            }
        }
    }

    public String getTitleAt(int n) {
        Tabbable tabbable;
        Component component = this.getComponentAt(n);
        if (component != null && (tabbable = super.getTabbableForDisplay(component)) != null) {
            return tabbable.getDockedTitle();
        }
        return super.getTitleAt(n);
    }

    protected boolean compareForClass(Tabbable tabbable, Class<? extends Tabbable> clazz) {
        return super.compareForClass(tabbable, clazz);
    }

    public void setParent(PluginWorkbench pluginWorkbench) {
        this.parent = pluginWorkbench;
    }

    public boolean pluginIsVisible(Plugin plugin) {
        return super.pluginIsVisible((Tabbable)plugin);
    }

    public boolean pluginIsHidden(Plugin plugin) {
        return super.pluginIsHidden((Tabbable)plugin);
    }

    public void setFocusOnDefaultElement() {
        JComponent jComponent;
        Tabbable tabbable = this.getTabbableForDisplay(this.getSelectedComponent());
        if (tabbable != null && (jComponent = tabbable.getDefaultElement()) != null) {
            jComponent.requestFocusInWindow();
        }
    }

    public void titleChanged() {
        Vector<Plugin> vector = new Vector<Plugin>();
        vector.addAll(this.runningPlugins);
        for (Plugin plugin : vector) {
            TabbableFrame tabbableFrame = plugin.getFrame();
            if (tabbableFrame != null) {
                tabbableFrame.setTitle(plugin.getDetachedTitle());
            }
            if (!(plugin instanceof PluginContainer)) continue;
            ((PluginContainer)PluginContainer.class.cast(plugin)).getWorkbench().titleChanged();
        }
    }

    public Dimension getLabelImageSize() {
        return this.core.getLabelImageSize();
    }

    public Dimension getTabImageSize() {
        return this.core.getTabImageSize();
    }

    protected class PredetachPlugin
    extends PredetachTab {
        public PredetachPlugin(Tabbable tabbable, Dimension dimension, Point point) {
            super(tabbable, dimension, point);
        }

        public void runTask() {
            if (this.size == null || this.position == null) {
                return;
            }
            super.runTask();
        }
    }

    protected class DetachPlugin
    extends DetachTab {
        public DetachPlugin(Tabbable tabbable, Dimension dimension, Point point) {
            super(tabbable, dimension, point);
        }

        public void runTask() {
            super.runTask();
            if (this.tab.getFrame() != null && this.size != null) {
                this.tab.getFrame().setSize(this.size);
            }
        }
    }

    protected class StopPlugin
    extends Workbench.DirectTabTask {
        Thread th;
        boolean started;
        boolean killed;

        public StopPlugin(Plugin plugin) {
            super((Workbench)PluginWorkbench.this, (Tabbable)plugin);
            this.th = null;
            this.started = false;
            this.killed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runTask() {
            Object object;
            if (!this.started) {
                this.started = true;
                this.th = new Thread(new Runnable(){

                    public void run() {
                        Plugin plugin = (Plugin)StopPlugin.this.tab;
                        PluginWorkbench.this.core.logEvent(Level.FINEST, "Stopping plugin: " + plugin.toString());
                        plugin.fini();
                        StopPlugin.this.killed = true;
                    }
                }, "Stopping " + this.tab.toString());
                this.th.setDaemon(true);
                this.th.setPriority(1);
                this.th.start();
                EventQueue.invokeLater((Runnable)((Object)this));
                return;
            }
            if (!this.killed) {
                try {
                    TimeUnit.MILLISECONDS.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EventQueue.invokeLater((Runnable)((Object)this));
                return;
            }
            Plugin plugin = (Plugin)this.tab;
            if (plugin.getFrame() != null) {
                object = plugin.getFrame();
                plugin.setFrame(null);
                object.setVisible(false);
                object.dispose();
            }
            object = PluginWorkbench.this.lock;
            synchronized (object) {
                Object object2 = plugin;
                while (object2 != null) {
                    Object object3;
                    Object object4 = DszProxyHandler.GetHandler((Object)object2);
                    if (object4 instanceof DszProxyHandler) {
                        ((DszProxyHandler)DszProxyHandler.class.cast(object4)).stop();
                    }
                    if ((object3 = DszProxyHandler.Unwrap((Object)object2, (boolean)false)) == object2) break;
                    object2 = object3;
                }
                plugin = (Plugin)DszProxyHandler.Unwrap((Object)plugin);
                PluginWorkbench.this.runningPlugins.remove(plugin);
                PluginWorkbench.this.localModel.removeElement(plugin);
                PluginWorkbench.this.enqueAction((Enum)Workbench.WorkbenchAction.REMOVETAB, new Object[]{plugin});
                PluginWorkbench.this.core.removeCommandEventListener((CommandEventListener)plugin);
                PluginWorkbench.this.core.removeConnectionChangeListener((ConnectionChangeListener)plugin);
                PluginWorkbench.this.core.removeInternalCommandHandler((InternalCommandHandler)plugin);
                if (PluginWorkbench.this.manager == plugin) {
                    PluginWorkbench.this.manager = null;
                }
            }
            PluginWorkbench.this.core.pluginStopped(plugin);
        }
    }

    protected class SetState
    extends Workbench.SetState {
        public SetState(Tabbable tabbable, Tabbable.TabState tabState) {
            super((Workbench)PluginWorkbench.this, tabbable, tabState);
        }

        public void runTask() {
            super.runTask();
        }
    }

    protected class SetSelectedTab
    extends Workbench.SetSelectedTab {
        public SetSelectedTab(Tabbable tabbable) {
            super((Workbench)PluginWorkbench.this, tabbable);
        }

        public void runTask() {
            super.runTask();
        }
    }

    protected class RenameTab
    extends Workbench.RenameTab {
        public RenameTab(Tabbable tabbable) {
            super((Workbench)PluginWorkbench.this, tabbable);
        }

        public RenameTab(Tabbable tabbable, String string) {
            super((Workbench)PluginWorkbench.this, tabbable, string);
        }

        public void runTask() {
            super.runTask();
        }
    }

    protected class TabbifyTab
    extends Workbench.TabbifyTab {
        public TabbifyTab(Tabbable tabbable) {
            super((Workbench)PluginWorkbench.this, tabbable);
        }

        public void runTask() {
            super.runTask();
        }
    }

    protected class PredetachTab
    extends Workbench.PredetachTab {
        public PredetachTab(Tabbable tabbable, Dimension dimension, Point point) {
            super((Workbench)PluginWorkbench.this, tabbable, dimension, point);
        }

        public void runTask() {
            super.runTask();
        }
    }

    protected class CloseTab
    extends Workbench.CloseTab {
        public CloseTab(Tabbable tabbable) {
            super((Workbench)PluginWorkbench.this, tabbable);
        }

        public void runTask() {
            PluginWorkbench.this.core.logEvent(Level.INFO, "Closing plugin: " + this.tab.toString());
            if (this.tab instanceof Plugin) {
                PluginWorkbench.this.invokeAction(PluginWorkbenchAction.STOPPLUGIN, new Object[]{this.tab});
            }
            this.tab.hideFrame();
        }
    }

    protected class DetachTab
    extends Workbench.DetachTab {
        public DetachTab(Tabbable tabbable, Dimension dimension, Point point) {
            super((Workbench)PluginWorkbench.this, tabbable, dimension, point);
        }

        public void runTask() {
            super.runTask();
            this.tab.setDetached();
        }
    }

    protected class UnhideTab
    extends Workbench.UnhideTab {
        public UnhideTab(Tabbable tabbable) {
            super((Workbench)PluginWorkbench.this, tabbable);
        }

        public void runTask() {
            super.runTask();
        }
    }

    protected class HideTab
    extends Workbench.HideTab {
        public HideTab(Tabbable tabbable) {
            super((Workbench)PluginWorkbench.this, tabbable);
        }

        public void runTask() {
            super.runTask();
        }
    }

    protected class StealFocus
    extends Workbench.StealFocus {
        public StealFocus(Tabbable tabbable) {
            super((Workbench)PluginWorkbench.this, tabbable);
        }

        public void runTask() {
            super.runTask();
        }
    }

    public class ModuleMetaData {
        public Module module;
        public String project;

        ModuleMetaData(Module module, String string) {
            this.module = module;
            this.project = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PluginWorkbenchAction {
        STOPPLUGIN,
        DETACHPLUGIN,
        PREDETACHPLUGIN;

    }
}

