/*
 * Decompiled with CFR 0.152.
 */
package ds.plugin.replay;

import ddb.CheckThreadViolationRepaintManager;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.connection.events.StatisticsEvent;
import ddb.dsz.core.controller.CommandSet;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.host.MutableHostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.Plugin;
import ddb.util.GeneralUtilities;
import ddb.util.PluginInitInfo;
import ddb.util.StartupConfigParser;
import ddb.util.XMLException;
import ds.core.DSConstants;
import ds.core.controller.AbstractCoreController;
import ds.jaxb.ipc.Message;
import ds.plugin.peer.Peer;
import ds.plugin.peer.PeerClient;
import ds.plugin.replay.ReplayTableModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpReplayDriver
extends AbstractCoreController
implements CoreController {
    CheckThreadViolationRepaintManager repaintManager = new CheckThreadViolationRepaintManager();
    public static String LOCAL = "0x00000004";
    public static String MONITOR = "0x00000010";
    public static String LOG = "0x00000020";
    public static String NOTIFY = "0x00000040";
    public static String BACKGROUND = "0x00000080";
    public static String TASK = "0x00000100";
    private final CommandSet commands = new CommandSet();
    private List<Plugin> plugins;
    boolean localMode;
    boolean loadPrevious;

    public OpReplayDriver(String[] stringArray) {
        super(stringArray);
        FileHandler fileHandler;
        Calendar calendar;
        RepaintManager.setCurrentManager((RepaintManager)this.repaintManager);
        this.plugins = new Vector<Plugin>();
        this.systemLogger = Logger.getLogger("ds.core");
        this.systemLogger.setLevel(Level.ALL);
        this.systemLogger.setUseParentHandlers(false);
        ReplayTableModel.getReplayModel().setAutoLoad(this.loadPrevious);
        File file = new File(this.getUserConfigDirectory(), "GuiSystemLog");
        file.mkdirs();
        try {
            calendar = Calendar.getInstance();
            fileHandler = new FileHandler(String.format("%s/%s-%%u.xml", file.getAbsolutePath(), GeneralUtilities.CalendarToStringFile((Calendar)calendar)));
            fileHandler.setLevel(Level.WARNING);
            this.systemLogger.addHandler(fileHandler);
        }
        catch (Exception exception) {
            this.logEvent(Level.WARNING, exception.getMessage(), exception);
        }
        if (this.isDebugMode()) {
            try {
                calendar = Calendar.getInstance();
                fileHandler = new FileHandler(String.format("%s/%s-%%u.all.xml", file.getAbsolutePath(), GeneralUtilities.CalendarToStringFile((Calendar)calendar)));
                fileHandler.setLevel(Level.ALL);
                this.systemLogger.addHandler(fileHandler);
            }
            catch (Exception exception) {
                this.logEvent(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    @Override
    protected void parseArg(String string, String string2) {
        super.parseArg(string, string2);
        if (string.equals("-local")) {
            try {
                this.localMode = Boolean.parseBoolean(string2);
            }
            catch (Exception exception) {}
        } else if (string.equalsIgnoreCase("-loadPrevious") && string2 != null) {
            try {
                this.loadPrevious = Boolean.parseBoolean(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void fireCommandEvent(CommandEvent commandEvent) {
        HostInfo hostInfo = this.getHostById(commandEvent.getTargetAddress());
        for (Plugin plugin : this.plugins) {
            if (!plugin.caresAboutLocalEvents() && hostInfo.isLocal()) continue;
            plugin.commandEventReceived(commandEvent);
        }
    }

    public CommandSet getCommandSet() {
        return this.commands;
    }

    public void addPlugin(Plugin plugin) {
        this.plugins.add(plugin);
    }

    public static void main(final String[] stringArray) {
        DSConstants.InstallDefaults();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final OpReplayDriver opReplayDriver = new OpReplayDriver(stringArray);
                opReplayDriver.initialize();
                JFrame jFrame = new JFrame();
                jFrame.setDefaultCloseOperation(3);
                jFrame.setSize(new Dimension(800, 600));
                jFrame.setLayout(new BorderLayout());
                opReplayDriver.setOwningFrame(jFrame);
                jFrame.setJMenuBar(opReplayDriver.getMenuBar());
                jFrame.setTitle("DanderSpritz Replay");
                JComponent jComponent = opReplayDriver.getMainWidget();
                jFrame.add(jComponent);
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowOpened(WindowEvent windowEvent) {
                        opReplayDriver.setFocusOnDefaultElement();
                    }
                });
                Vector<PluginInitInfo> vector = new Vector<PluginInitInfo>();
                List<File> list = DSConstants.getStartupConfigurationFiles(new File(opReplayDriver.getResourceDirectory()), "replay");
                for (File file : list) {
                    try {
                        vector.addAll(StartupConfigParser.parse(file.toURI().toURL().openStream(), opReplayDriver.getLogDir(), String.format("%s/%s", opReplayDriver.getResourceDirectory(), opReplayDriver.getDefaultPackage()), ""));
                    }
                    catch (XMLException xMLException) {
                    }
                    catch (IOException iOException) {}
                }
                opReplayDriver.instantiatePlugins(vector);
                opReplayDriver.createDirectoryMonitor();
                SwingUtilities.updateComponentTreeUI(jFrame);
                jFrame.setVisible(true);
            }
        });
    }

    public void instantiatePlugins(List<PluginInitInfo> list) {
        for (PluginInitInfo pluginInitInfo : list) {
            this.instantiatePlugin(pluginInitInfo);
        }
        if (this.getWorkbench().getTabCount() > 0) {
            this.getWorkbench().setSelectedIndex(0);
        }
    }

    public void shutdown() {
        super.saveUserConfig();
        System.exit(0);
    }

    public Task generateTaskForCommand(String string) {
        return null;
    }

    public void startCommand(String string, IdCallback idCallback, Object object, HostInfo hostInfo) throws DispatcherException {
        throw new DispatcherException("Not connected.  Replaying past operation.");
    }

    public void addPrefixesToTask(TaskId taskId, List<String> list) throws DispatcherException {
        throw new DispatcherException("Not connected.  Replaying past operation.");
    }

    public void killCommand(Task task) throws DispatcherException {
        throw new DispatcherException("Not connected.  Replaying past operation.");
    }

    public void interruptCommand(Task task) throws DispatcherException {
        throw new DispatcherException("Not connected.  Replaying past operation.");
    }

    public void stopCommandOutput(Task task) throws DispatcherException {
        throw new DispatcherException("Not connected.  Replaying past operation.");
    }

    public void sendPromptReply(int n, TaskId taskId, String string) throws DispatcherException {
        throw new DispatcherException("Not connected.  Replaying past operation.");
    }

    public TableModel getLogTableModel() {
        return null;
    }

    public void requestHelpStatement(String string, HostInfo hostInfo) throws DispatcherException {
        throw new DispatcherException("Not connected.  Replaying past operation.");
    }

    public File createLogFile(String string) {
        return null;
    }

    public Logger getSystemLogger() {
        return this.systemLogger;
    }

    public boolean isLiveOperation() {
        return false;
    }

    public void restartCommandOutput(Task task) throws DispatcherException {
    }

    @Override
    public <E extends Serializable> E getObject(Class<? extends Plugin> clazz, String string, Class<? extends E> clazz2) {
        return null;
    }

    @Override
    public void exceptionOccurredInPlugin(Plugin plugin) {
    }

    @Override
    public void shutdown(boolean bl) {
    }

    @Override
    public void updateConnectionInfo(Message message) {
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public void updateStatistics(StatisticsEvent statisticsEvent) {
    }

    @Override
    public Class<? extends Peer> getPeer() {
        return PeerClient.class;
    }

    @Override
    public boolean hasConnected() {
        return false;
    }

    @Override
    public void disconnected(String string) {
        HostInfo hostInfo = this.getHostById(string);
        if (hostInfo instanceof MutableHostInfo) {
            MutableHostInfo mutableHostInfo = (MutableHostInfo)hostInfo;
            mutableHostInfo.setConnected(false);
            this.fireDisconnectedHost((HostInfo)mutableHostInfo);
        }
    }

    public void requestShutdown() {
    }
}

