/*
 * Decompiled with CFR 0.152.
 */
package ds.util.contextmenu;

import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.contextmenu.ContextMenuAction;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.host.HostInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ItemActionListener
implements ActionListener {
    private final Collection<IndividualCommand> commands;
    private final String Label;
    private final IdCallback idcb;
    private final boolean showResult;
    private final boolean verify;
    private final ContextMenuAction actionHandler;
    private final CoreController core;
    private final HostInfo host;
    private final List<String> raw;
    private final Object extraContext;

    public ItemActionListener(CoreController coreController, Collection<IndividualCommand> collection, String string, IdCallback idCallback, HostInfo hostInfo, ContextMenuAction contextMenuAction, boolean bl, boolean bl2, List<String> list, Object object) {
        this.core = coreController;
        this.commands = new ArrayList<IndividualCommand>();
        this.commands.addAll(collection);
        this.Label = string;
        this.idcb = idCallback;
        this.host = hostInfo;
        this.showResult = bl;
        this.verify = bl2;
        this.actionHandler = contextMenuAction;
        this.raw = new Vector<String>();
        this.raw.addAll(list);
        this.extraContext = object;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.verify && JOptionPane.showConfirmDialog(null, "Are you sure you wish to do this:  " + this.Label, "System Change!", 0) != 0) {
            return;
        }
        for (IndividualCommand individualCommand : this.commands) {
            if (individualCommand.parameters != null && individualCommand.parameters.size() != 0) {
                this.actionHandler.action(individualCommand.parameters);
                continue;
            }
            try {
                this.core.startCommand(individualCommand.command, this.showResult ? this.idcb : null, (Object)individualCommand.command, this.host);
            }
            catch (DispatcherException dispatcherException) {
                this.core.logEvent(Level.WARNING, "Failure on " + this.Label);
            }
        }
        if (this.raw != null && this.extraContext != null) {
            this.actionHandler.action(this.raw, this.extraContext);
        }
    }

    public static class IndividualCommand {
        public String command;
        public List<String> parameters;
    }
}

