/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms;

import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.util.UtilityConstants;
import ddb.util.XmlCache;
import ds.core.impl.task.DocumentBlobAccess;
import ds.core.impl.task.TaskStateAccess;
import ds.util.datatransforms.IncompleteDataException;
import java.io.Reader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class AbstractDataTransformer
extends DataTransformer
implements Observer,
Runnable {
    protected static final int MAX_GENERATED = 5;
    protected static final Comparator<TaskDataAccess> TASK_DATA_SORTER = new Comparator<TaskDataAccess>(){

        @Override
        public int compare(TaskDataAccess taskDataAccess, TaskDataAccess taskDataAccess2) {
            if (taskDataAccess.isGenerated()) {
                if (taskDataAccess2.isGenerated()) {
                    if (taskDataAccess.getSize() > taskDataAccess2.getSize()) {
                        return -1;
                    }
                    if (taskDataAccess.getSize() == taskDataAccess2.getSize()) {
                        return 0;
                    }
                    return 1;
                }
                return -1;
            }
            if (taskDataAccess2.isGenerated()) {
                return 1;
            }
            if (taskDataAccess instanceof TaskStateAccess) {
                if (taskDataAccess2 instanceof TaskStateAccess) {
                    return 0;
                }
                return -1;
            }
            if (taskDataAccess2 instanceof TaskStateAccess) {
                return 1;
            }
            if (taskDataAccess.getOrdinal() < taskDataAccess2.getOrdinal()) {
                return -1;
            }
            if (taskDataAccess.getOrdinal() > taskDataAccess2.getOrdinal()) {
                return 1;
            }
            return taskDataAccess.getTask().getCreated().compareTo(taskDataAccess2.getTask().getCreated());
        }
    };
    private static final Object GENERATED_ACCESS_LOCK = new Object();
    private static int generatedAccessCount = 0;
    protected boolean stop = false;
    private final List<Task> subscribedTasks2 = new Vector<Task>();
    private Queue<TaskDataAccess> dataEvents;
    private Set<TaskDataAccess> pendingEvents;
    protected final Object TASK_LIST_LOCK = new Object();
    protected final Object DATA_LIST_LOCK = new Object();
    protected final boolean orderImportant;
    private ScheduledExecutorService DEQUEUER;
    protected Logger logger = Logger.getLogger("ds.core");

    private static String getName() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (stackTraceElement == null || stackTraceElement.getClassName() == null || !stackTraceElement.getClassName().startsWith("ddb.dsz") || stackTraceElement.getClassName().contains("DataTransformer")) continue;
                return stackTraceElement.getClassName();
            }
        }
        return "Unknown Parent";
    }

    protected AbstractDataTransformer() {
        this.orderImportant = false;
        this.init();
    }

    protected AbstractDataTransformer(boolean bl) {
        this.orderImportant = bl;
        this.init();
    }

    protected AbstractDataTransformer(String string) {
        this.orderImportant = false;
        this.init();
    }

    protected AbstractDataTransformer(String string, boolean bl) {
        this.orderImportant = bl;
        this.init();
    }

    protected AbstractDataTransformer(ThreadFactory threadFactory) {
        this.orderImportant = false;
        this.init();
    }

    protected AbstractDataTransformer(ThreadFactory threadFactory, boolean bl) {
        this.orderImportant = bl;
        this.init();
    }

    private void init() {
        this.init("ADT:  " + AbstractDataTransformer.getName());
    }

    private void init(String string) {
        this.init(UtilityConstants.createThreadFactory((String)string));
    }

    private void init(ThreadFactory threadFactory) {
        this.dataEvents = this.orderImportant ? new LinkedList<TaskDataAccess>() : new PriorityBlockingQueue<TaskDataAccess>(50, TASK_DATA_SORTER);
        this.pendingEvents = new HashSet<TaskDataAccess>();
        this.DEQUEUER = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.DEQUEUER.submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Task task) {
        if (task == null) {
            return;
        }
        Object object = this.TASK_LIST_LOCK;
        synchronized (object) {
            int n = Collections.binarySearch(this.subscribedTasks2, task, Task.TaskComparator);
            if (n >= 0) {
                return;
            }
            ++n;
            n = -n;
            this.subscribedTasks2.add(n, task);
        }
        task.subscribe((Observer)this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTasks() {
        Task[] taskArray = null;
        Object object = this.TASK_LIST_LOCK;
        synchronized (object) {
            taskArray = this.subscribedTasks2.toArray(new Task[this.subscribedTasks2.size()]);
            this.subscribedTasks2.clear();
        }
        for (Task task : taskArray) {
            task.unsubscribe((Observer)this);
        }
        Object object2 = this.DATA_LIST_LOCK;
        synchronized (object2) {
            this.dataEvents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Task task) {
        Vector<TaskDataAccess> vector = this.TASK_LIST_LOCK;
        synchronized (vector) {
            int n = Collections.binarySearch(this.subscribedTasks2, task, Task.TaskComparator);
            if (n < 0) {
                return;
            }
            this.subscribedTasks2.remove(n);
        }
        task.unsubscribe((Observer)this);
        Iterator iterator = this.DATA_LIST_LOCK;
        synchronized (iterator) {
            vector = new Vector<TaskDataAccess>();
            vector.addAll(this.dataEvents);
            this.dataEvents.clear();
        }
        for (TaskDataAccess taskDataAccess : vector) {
            Object object;
            if (taskDataAccess.getTask().equals(task)) {
                if (!taskDataAccess.isGenerated()) continue;
                object = GENERATED_ACCESS_LOCK;
                synchronized (object) {
                    --generatedAccessCount;
                }
                object = this.DATA_LIST_LOCK;
                synchronized (object) {
                    this.DATA_LIST_LOCK.notify();
                    continue;
                }
            }
            object = this.DATA_LIST_LOCK;
            synchronized (object) {
                this.dataEvents.offer(taskDataAccess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        try {
            Object object;
            TaskDataAccess taskDataAccess;
            block36: {
                int n;
                block35: {
                    taskDataAccess = null;
                    n = 0;
                    try {
                        object = this.DATA_LIST_LOCK;
                        synchronized (object) {
                            for (TaskDataAccess taskDataAccess2 : this.pendingEvents.toArray(new TaskDataAccess[0])) {
                                if (taskDataAccess2.getTask().isAlive()) continue;
                                this.pendingEvents.remove(taskDataAccess2);
                                this.dataEvents.add(taskDataAccess2);
                            }
                            taskDataAccess = this.dataEvents.poll();
                            n = this.dataEvents.size();
                            bl = this.pendingEvents.isEmpty();
                        }
                        if (!this.orderImportant) {
                            this.reschedule(taskDataAccess != null);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!this.orderImportant) {
                            this.reschedule(taskDataAccess != null);
                        }
                        throw throwable;
                    }
                    try {
                        if (taskDataAccess != null) break block35;
                        if (this.orderImportant) {
                            this.reschedule(!bl);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        if (this.orderImportant) {
                            this.reschedule(!bl);
                        }
                        throw throwable;
                    }
                }
                if (this.orderImportant || taskDataAccess.getType() != TaskDataAccess.DataType.TASKING || !taskDataAccess.getTask().isAlive()) break block36;
                object = this.DATA_LIST_LOCK;
                synchronized (object) {
                    this.pendingEvents.add(taskDataAccess);
                }
                if (n > 0) {
                    this.sleep();
                }
                if (this.orderImportant) {
                    this.reschedule(!bl);
                }
                return;
            }
            try {
                this.logger.log(Level.FINE, String.format("%d:  Handling #%d => %s", taskDataAccess.getTask().getId().getId(), taskDataAccess.getOrdinal(), taskDataAccess.toString()));
            }
            catch (NullPointerException nullPointerException) {
                this.logger.log(Level.FINE, String.format("??:  Handling #?? => %s", taskDataAccess));
            }
            if (taskDataAccess.isGenerated()) {
                object = GENERATED_ACCESS_LOCK;
                synchronized (object) {
                    --generatedAccessCount;
                }
                object = this.DATA_LIST_LOCK;
                synchronized (object) {
                    this.DATA_LIST_LOCK.notify();
                }
            }
            try {
                this.execute(taskDataAccess);
            }
            catch (Exception exception) {
                this.handleError(exception);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (this.orderImportant) {
                this.reschedule(!bl);
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            rejectedExecutionException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void reschedule(boolean bl) {
        try {
            if (bl) {
                this.DEQUEUER.submit(this);
            } else {
                this.DEQUEUER.schedule(this, 250L, TimeUnit.MILLISECONDS);
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            System.err.println("Rescheduling action rejected: " + AbstractDataTransformer.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable observable, Object object) {
        TaskDataAccess taskDataAccess = (TaskDataAccess)object;
        if (taskDataAccess != null) {
            try {
                this.logger.log(Level.FINE, String.format("%d:  Enqueing #d => %s", taskDataAccess.getTask().getId().getId(), taskDataAccess.getOrdinal(), taskDataAccess.toString()));
            }
            catch (NullPointerException nullPointerException) {
                this.logger.log(Level.FINE, String.format("??:  Enqueing #?? => %s", taskDataAccess));
            }
            Object object2 = this.DATA_LIST_LOCK;
            synchronized (object2) {
                this.dataEvents.offer(taskDataAccess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requeue(TaskDataAccess taskDataAccess) {
        try {
            this.logger.log(Level.FINE, String.format("%d:  Requeuing #d => %s", taskDataAccess.getTask().getId().getId(), taskDataAccess.getOrdinal(), taskDataAccess.toString()));
        }
        catch (NullPointerException nullPointerException) {
            this.logger.log(Level.FINE, String.format("??:  Requeuing %s", taskDataAccess));
        }
        if (this.isOrderImportant()) {
            this.execute(taskDataAccess);
        } else {
            Object object;
            if (taskDataAccess == null) {
                return;
            }
            if (!this.isValidTask(taskDataAccess.getTask())) {
                return;
            }
            if (taskDataAccess.isGenerated()) {
                while (true) {
                    object = GENERATED_ACCESS_LOCK;
                    synchronized (object) {
                        if (generatedAccessCount < 5) {
                            ++generatedAccessCount;
                            break;
                        }
                    }
                    object = this.DATA_LIST_LOCK;
                    synchronized (object) {
                        try {
                            this.DATA_LIST_LOCK.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            System.err.println(interruptedException.getMessage());
                        }
                    }
                }
                if (!this.isValidTask(taskDataAccess.getTask())) {
                    object = GENERATED_ACCESS_LOCK;
                    synchronized (object) {
                        --generatedAccessCount;
                    }
                    object = this.DATA_LIST_LOCK;
                    synchronized (object) {
                        this.DATA_LIST_LOCK.notify();
                    }
                    return;
                }
            }
            object = this.DATA_LIST_LOCK;
            synchronized (object) {
                this.dataEvents.offer(taskDataAccess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isValidTask(Task task) {
        Object object = this.TASK_LIST_LOCK;
        synchronized (object) {
            int n = Collections.binarySearch(this.subscribedTasks2, task, Task.TaskComparator);
            return n >= 0;
        }
    }

    public void stop() {
        this.stop = true;
        this.removeAllTasks();
        this.DEQUEUER.shutdown();
    }

    private void sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract void execute(TaskDataAccess var1);

    protected void handleError(Exception exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Document parseDocument(TaskDataAccess taskDataAccess) {
        block11: {
            if (taskDataAccess instanceof DocumentBlobAccess) {
                return ((DocumentBlobAccess)DocumentBlobAccess.class.cast(taskDataAccess)).getDocument();
            }
            DocumentBuilder documentBuilder = XmlCache.getBuilder();
            try {
                Document document;
                if (documentBuilder == null) break block11;
                documentBuilder.reset();
                Reader reader = taskDataAccess.getReader();
                if (reader == null) {
                    Document document2 = null;
                    return document2;
                }
                try {
                    document = documentBuilder.parse(new InputSource(reader));
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        throw new IncompleteDataException(exception);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                reader.close();
                return document;
            }
            finally {
                XmlCache.releaseBuilder((DocumentBuilder)documentBuilder);
            }
        }
        return null;
    }

    protected final boolean isOrderImportant() {
        return this.orderImportant;
    }
}

