/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms.transformers;

import java.math.BigInteger;
import org.apache.commons.collections.Transformer;

public class LongTransformer
implements Transformer {
    public Object transform(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return LongTransformer.parseLong(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return null;
        }
    }

    static Long parseLong(String string) {
        BigInteger bigInteger = LongTransformer.parseBigInteger(string);
        if (bigInteger == null) {
            return null;
        }
        return bigInteger.longValue();
    }

    private static BigInteger parseBigInteger(String string) {
        if ((string = string.trim().toLowerCase()).length() == 0) {
            return BigInteger.ZERO;
        }
        if (string.length() == 1) {
            return new BigInteger(string);
        }
        if (string.charAt(0) == '0') {
            int n = 10;
            if (string.charAt(1) == 'x') {
                string = string.substring(2);
                n = 16;
            } else {
                string = string.substring(1);
                n = 8;
            }
            try {
                return new BigInteger(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return new BigInteger(string, 16);
                }
                catch (NumberFormatException numberFormatException2) {
                    return null;
                }
            }
        }
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

